/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.database;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.Context;
import org.traccar.config.Keys;
import org.traccar.database.DataManager;
import org.traccar.database.ExtendedObjectManager;
import org.traccar.model.Calendar;
import org.traccar.model.Event;
import org.traccar.model.Notification;
import org.traccar.model.Position;
import org.traccar.model.Typed;

public class NotificationManager
extends ExtendedObjectManager<Notification> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NotificationManager.class);
    private boolean geocodeOnRequest = Context.getConfig().getBoolean(Keys.GEOCODER_ON_REQUEST);

    public NotificationManager(DataManager dataManager) {
        super(dataManager, Notification.class);
    }

    private Set<Long> getEffectiveNotifications(long userId, long deviceId, Date time) {
        HashSet<Long> result = new HashSet<Long>();
        Set<Long> deviceNotifications = this.getAllDeviceItems(deviceId);
        for (long itemId : this.getUserItems(userId)) {
            Calendar calendar;
            if (!((Notification)this.getById(itemId)).getAlways() && !deviceNotifications.contains(itemId)) continue;
            long calendarId = ((Notification)this.getById(itemId)).getCalendarId();
            Calendar calendar2 = calendar = calendarId != 0L ? (Calendar)Context.getCalendarManager().getById(calendarId) : null;
            if (calendar != null && !calendar.checkMoment(time)) continue;
            result.add(itemId);
        }
        return result;
    }

    public void updateEvent(Event event, Position position) {
        try {
            this.getDataManager().addObject(event);
        }
        catch (SQLException error) {
            LOGGER.warn("Event save error", (Throwable)error);
        }
        if (position != null && this.geocodeOnRequest && Context.getGeocoder() != null && position.getAddress() == null) {
            position.setAddress(Context.getGeocoder().getAddress(position.getLatitude(), position.getLongitude(), null));
        }
        long deviceId = event.getDeviceId();
        Set<Long> users = Context.getPermissionsManager().getDeviceUsers(deviceId);
        HashSet<Long> usersToForward = null;
        if (Context.getEventForwarder() != null) {
            usersToForward = new HashSet<Long>();
        }
        for (long userId : users) {
            if (event.getGeofenceId() != 0L && !Context.getGeofenceManager().checkItemPermission(userId, event.getGeofenceId()) || event.getMaintenanceId() != 0L && !Context.getMaintenancesManager().checkItemPermission(userId, event.getMaintenanceId())) continue;
            if (usersToForward != null) {
                usersToForward.add(userId);
            }
            HashSet<String> notificators = new HashSet<String>();
            for (long notificationId : this.getEffectiveNotifications(userId, deviceId, event.getServerTime())) {
                Notification notification = (Notification)this.getById(notificationId);
                if (!((Notification)this.getById(notificationId)).getType().equals(event.getType())) continue;
                boolean filter = false;
                if (event.getType().equals("alarm")) {
                    String alarmsAttribute = notification.getString("alarms");
                    if (alarmsAttribute == null) {
                        filter = true;
                    } else {
                        List<String> alarms = Arrays.asList(alarmsAttribute.split(","));
                        boolean bl = filter = !alarms.contains(event.getString("alarm"));
                    }
                }
                if (filter) continue;
                notificators.addAll(notification.getNotificatorsTypes());
            }
            for (String notificator : notificators) {
                Context.getNotificatorManager().getNotificator(notificator).sendAsync(userId, event, position);
            }
        }
        if (Context.getEventForwarder() != null) {
            Context.getEventForwarder().forwardEvent(event, position, usersToForward);
        }
    }

    public void updateEvents(Map<Event, Position> events) {
        for (Map.Entry<Event, Position> event : events.entrySet()) {
            this.updateEvent(event.getKey(), event.getValue());
        }
    }

    public Set<Typed> getAllNotificationTypes() {
        Field[] fields;
        HashSet<Typed> types = new HashSet<Typed>();
        for (Field field : fields = Event.class.getDeclaredFields()) {
            if (!Modifier.isStatic(field.getModifiers()) || !field.getName().startsWith("TYPE_")) continue;
            try {
                types.add(new Typed(field.get(null).toString()));
            }
            catch (IllegalAccessException | IllegalArgumentException error) {
                LOGGER.warn("Get event types error", (Throwable)error);
            }
        }
        return types;
    }
}

