<!doctype html>
<html lang="fr">
 
<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <meta name="csrf-token" content="{{ csrf_token() }}" />
    
    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="{{url('/')}}/assets/vendor/bootstrap/css/bootstrap.min.css">
    <link href="{{url('/')}}/assets/vendor/fonts/circular-std/style.css" rel="stylesheet">
    <link rel="stylesheet" href="{{url('/')}}/assets/libs/css/style.css">
    <link rel="stylesheet" href="{{url('/')}}/assets/vendor/fonts/fontawesome/css/fontawesome-all.css">
    
    <link rel="stylesheet" href="{{url('/')}}/assets/vendor/fonts/material-design-iconic-font/css/materialdesignicons.min.css">
    <link rel="stylesheet" href="{{url('/')}}/assets/vendor/charts/c3charts/c3.css">
    <link rel="stylesheet" href="{{url('/')}}/assets/vendor/fonts/flag-icon-css/flag-icon.min.css">
    <link rel="stylesheet" href="{{url('/')}}/assets/vendor/charts/morris-bundle/morris.css">

    <link rel="stylesheet" href="{{url('/')}}/assets/vendor/bootstrap-select/css/bootstrap-select.css">

    <title>@yield('title')</title>
    @yield('CSS')

    <style type="text/css">
        .bootstrap-select .dropdown-menu { z-index: 99999; }
        .slimScrollBar {  
            display: block !important;
 
            opacity: 1 !important;
            padding:4px 7px 4px 7px !important;

            background: rgb(114,136,255) !important;
            background: linear-gradient(90deg, rgba(114,136,255,1) 0%, rgba(114,136,255,1) 44%, rgba(27,63,255,1) 100%) !important;

        }
        .slimScrollDiv { height: 90% !important; }

        .sidebar-dark3 .nav-item a, .sidebar-dark3 .nav-item i{ 
            color: #1B3FFF !important;
        }

        .sidebar-dark3 .nav-item a{ 
            font-weight: bold !important;
            font-size: 15px !important;
        }

        .submenu {
            background-color: #efeff6 !important;
        }


    </style>



</head>

<body>
    <!-- ============================================================== -->
    <!-- main wrapper -->
    <!-- ============================================================== -->
    <div class="dashboard-main-wrapper">
        <!-- ============================================================== -->
        <!-- navbar -->
        <!-- ============================================================== -->
        <div class="dashboard-header">
            <nav class="navbar navbar-expand-lg bg-white fixed-top">
                <a style="font-size: 18px;" class="navbar-brand" href="{{url('/')}}">
                    <img class="logo-img img-fluid" width="160px" src="{{url('/')}}/assets/images/logo4.png" alt="Groupe Scolaire Verdin"> 
                </a>
                <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                    <span class="navbar-toggler-icon"></span>
                </button>
                <div class="collapse navbar-collapse " id="navbarSupportedContent">
                    <ul class="navbar-nav ml-auto navbar-right-top">



                        <li class="nav-item">
                            <div id="custom-search" class="top-search-bar">
                                <h3 class="mt-1">Vous êtes connecté en tant que: <strong style="color: #0328EB;" >{{ auth()->user()->last_name . ' ' .  auth()->user()->first_name }}</strong>

@if(auth()->user()->is_student == 1) 

    @if(!empty(auth()->user()->class_id))

    <?php $getuserClasse = \App\Classes::find(auth()->user()->class_id); ?>
    <br>Classe: <strong style="color: #0328EB;">{{ $getuserClasse->name }}</strong>

    @endif
@endif
                                </h3>
                            </div>
                        </li>


                        <li class="nav-item nav-user">
                            <a class="nav-link nav-icons text-uppercase" target="_black" href="https://verdin.ma:2096/" ><i class="fa fa-envelope"></i> Mon Verdin Mail</a>
                        </li>


@if(auth()->user()->is_admin == 1)

                        <li class="nav-item dropdown notification">
                            <a class="nav-link nav-icons" href="#" id="navbarDropdownMenuLink1" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i class="fas fa-fw fa-bell"></i> <span class="indicator"></span></a>
                            <ul class="dropdown-menu dropdown-menu-right notification-dropdown">
                                <li>
                                    <div class="notification-title"> Historique</div>
                                    <div class="notification-list">
                                        <div class="list-group">

<?php $historiqueN = \App\Historique::orderBy('id', 'desc')->take(3)->get(); ?> 

                                            @foreach($historiqueN as $historN)
                                            <a href="{{ URL::route('historique') }}" class="list-group-item list-group-item-action">
                                                <div class="notification-info">
                                                <div class="notification-list-user-img">

@if(!empty($historN->teacher->image))
    <img src="{{ url('/') }}/uploads/images/{{ $historN->teacher->image }}" alt="" class="user-avatar-md rounded-circle">
 @else
    <img src="{{ url('/') }}/uploads/images/user.png" alt="" class="user-avatar-md rounded-circle">
@endif

                                                </div>
                                                    <div class="notification-list-user-block"><span class="notification-list-user-name">{{ $historN->teacher->last_name . ' ' . $historN->teacher->first_name }} </span>{{ html_entity_decode($historN->historique) }}
                                                        <div class="notification-date"><?php $enTofr = DateTime::createFromFormat('Y-m-d H:i', substr($historN->created_at, 0, 16)); ?>
                                                        {{ $enTofr->format('d/m/Y H:i') }}</div>
                                                    </div>
                                                </div>
                                            </a>

                                            @endforeach
                                        </div>
                                    </div>
                                </li>
                                <li>
                                    <div class="list-footer"> <a href="{{ URL::route('historique') }}">Voir toute l'historique</a></div>
                                </li>
                            </ul>
                        </li>

@endif

                       
                    

                        <li class="nav-item dropdown nav-user">

                        
                            <a class="nav-link nav-user-img" href="#" id="navbarDropdownMenuLink2" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">

                            @if(!empty(auth()->user()->image))
                                <img src="{{ url('/') }}/uploads/images/{{ auth()->user()->image }}" alt="" class="user-avatar-md rounded-circle" style="width: 50px; height: 50px;">
                            @else
                                <i class="fa fa-user"></i> 
                            @endif
                                

                            </a>

                            <div class="dropdown-menu dropdown-menu-right nav-user-dropdown" aria-labelledby="navbarDropdownMenuLink2">
                            @if(auth()->user()->is_admin == 1)

                                <div class="nav-user-info">
                                    <h5 class="mb-0 text-white nav-user-name"> Administrateur </h5>
                                </div>

                            @else
                                <div class="nav-user-info">
                                    <h5 class="mb-0 text-white nav-user-name"> {{ auth()->user()->last_name . ' ' .  auth()->user()->first_name }} </h5>
                                </div>

                            @endif

                                <a class="dropdown-item" href="{{ URL::route('logout') }}"><i class="fas fa-power-off mr-2"></i>Se déconnecter</a>

                            </div>
                        </li>
                    </ul>
                </div>
            </nav>
        </div>
        <!-- ============================================================== -->
        <!-- end navbar -->
        <!-- ============================================================== -->
        <!-- ============================================================== -->
        <!-- left sidebar -->
        <!-- ============================================================== -->
        <div class="nav-left-sidebar sidebar-dark3">
            <div class="menu-list">
                <nav class="navbar navbar-expand-lg navbar-light">
                    <a class="d-xl-none d-lg-none" href="#"><h4 style="color: #353535;" class="mt-2">Vous êtes connecté en tant que: <strong >{{ auth()->user()->last_name . ' ' .  auth()->user()->first_name }}</strong>
                    @if(auth()->user()->is_student == 1) 

                    @if(!empty(auth()->user()->class_id))
                    <?php $getuserClasse = \App\Classes::find(auth()->user()->class_id); ?>

                    <br>Classe: <strong>{{ $getuserClasse->name }}</strong>

                    @endif
                    @endif
                      </h4></a>
                    <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
                        <span class="navbar-toggler-icon"></span>
                    </button>
                    <div class="collapse navbar-collapse" id="navbarNav">
                        <ul class="navbar-nav flex-column">
                            <li class="nav-divider">
                                Menu
                            </li>

@if(auth()->user()->is_admin == 1)  

                            <li>
                                <h3 style="text-align: center; color: #FF5722; font-size: 17px;" class="text-uppercase">Espace Administration</h3>
                            </li> 

                            <li class="nav-item ">
                                <a class="nav-link" href="{{ URL::route('admin_index') }}"><i class="fa fa-fw fas fa-box"></i>Statistiques</a>
                            </li>

                            <li class="nav-item ">
                                <a class="nav-link" href="{{ URL::route('personnel') }}"><i class="fas fa-address-card"></i>Personnel</a>
                            </li>

                            <li class="nav-item ">
                                <a class="nav-link" href="{{ URL::route('enseignants') }}"><i class="fa fa-fw fa-users"></i>Enseignants</a>
                            </li>

                            <li class="nav-item ">
                                <a class="nav-link" href="{{ URL::route('enseignants_suspendus') }}"><i class="fa fa-fw fa-users"></i>Enseignants Suspendus</a>
                            </li>

                            <li class="nav-item ">
                                <a class="nav-link" href="{{ URL::route('admin_grille_evaluation') }}"><i class="fas fa-th-list"></i> Grille d'évaluation</a>
                            </li>
        
                            <li class="nav-item ">
                                <a class="nav-link" href="{{ URL::route('students') }}"><i class="fas fa-graduation-cap"></i>Les élèves</a>
                            </li>

                            <li class="nav-item ">
                                <a class="nav-link" href="{{ URL::route('admin_fournitures_annee') }}"><i class="fas fa-suitcase"></i>Fournitures de l'année</a>
                            </li>

                            <li class="nav-item ">
                                <a class="nav-link" href="{{ URL::route('admin_orientation') }}"><i class="fas fa-map-signs"></i>Orientation</a>
                            </li>

                            <li class="nav-item ">
                                <a class="nav-link" href="{{ URL::route('admin_assiduite') }}"><i class="far fa-building"></i>Assiduité</a>
                            </li>

                            <li class="nav-item ">
                                <a class="nav-link" href="{{ URL::route('admin_compte_rendu') }}"><i class="fas fa-file-alt"></i>Compte rendu</a>
                            </li>

                            <li class="nav-item ">
                                <a class="nav-link" href="{{ URL::route('classes_subjects') }}"><i class="fas fa-book"></i>Classes & Matières</a>
                            </li>

                        <?php /* ?> 
                            <li class="nav-item">
                                <a class="nav-link" href="#" data-toggle="collapse" aria-expanded="false" data-target="#submenu-10" aria-controls="submenu-10"><i class="fas fa-book"></i>Classes & Matières</a>
                                <div id="submenu-10" class="collapse submenu" style="">
                                    <ul class="nav flex-column">
                                        <li class="nav-item">
                                            <a class="nav-link" href="{{ URL::route('classes_subjects') }}"> <i class="fas fa-list"></i> Classes & Matières</a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="nav-link" href="{{ URL::route('classes_subjects') }}#Affectation"> <i class="fas fa-sync-alt"></i> Affectation Enseignants-Matières</a>
                                        </li>
                                    </ul>
                                </div>
                            </li>

                            <?php */ ?> 


                            <li class="nav-item">
                                <a class="nav-link" href="#" data-toggle="collapse" aria-expanded="false" data-target="#submenu-18" aria-controls="submenu-18"><i class="fa fa-fw fa-table"></i>Emploi & dépôt documents</a>
                                <div id="submenu-18" class="collapse submenu" style="">
                                    <ul class="nav flex-column">
                                        <li class="nav-item ">
                                            <a class="nav-link" href="{{ URL::route('admin_emploi') }}"><i class="fa fa-fw fa-table"></i>Emploi du temps</a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="nav-link" href="{{ URL::route('admin_emploi') }}#documents"> <i class="fas fa-file-pdf"></i> Dépôt des documents</a>
                                        </li>
                                    </ul>
                                </div>
                            </li>

                            

                            <li class="nav-item ">
                                <a class="nav-link" href="{{ URL::route('admin_planning_devoirs') }}"><i class="fas fa-calendar-alt"></i>Planning des devoirs</a>
                            </li>


                            <li class="nav-item ">
                                <a class="nav-link" href="{{ URL::route('enseignant_dossiers') }}"><i class="fa fa-fw fa-folder"></i>Dossiers & ressources</a>
                            </li>

                            <li class="nav-item ">
                                <a class="nav-link" href="{{ URL::route('historique') }}"><i class="fas fa-history"></i>Historique de ressources</a>
                            </li>


                            <li class="nav-item ">
                                <a class="nav-link" href="{{ URL::route('admin_repartition') }}"><i class="fas fa-sitemap"></i>التوزيع الدوري</a>
                            </li>

                            <li class="nav-item ">
                                <a class="nav-link" href="{{ URL::route('admin_cahier_journal') }}"><i class="fa fa-fw fa-book"></i> دفاتر النصوص</a>
                            </li>

                            <?php $CountDemandesDocuments = \App\DemandesDocuments::where('is_readed', 0)->get(); ?>

                            <li class="nav-item ">
                                <a class="nav-link" href="{{ URL::route('admin_demandes_documents') }}"><i class="fa fa-info-circle"></i>طلبات الوثائق @if(count($CountDemandesDocuments) > 0) <strong style="font-size: 16px; color: #1B3FFF;">( {{ count($CountDemandesDocuments) }} )</strong> @endif </a>
                            </li>


                            <?php $CountRequest = \App\AbsenceRequest::where('is_readed', 0)->get(); ?>

                            <li class="nav-item ">
                                <a class="nav-link" href="{{ URL::route('admin_absence_request') }}"><i class="fa fa-info-circle"></i>طلبات ترخيص الغياب @if(count($CountRequest) > 0) <strong style="font-size: 16px; color: #1B3FFF;">( {{ count($CountRequest) }} )</strong> @endif </a>
                            </li>


                            <li class="nav-item ">
                                <a class="nav-link" href="{{ URL::route('admin_demandes_rencontre') }}"><i class="fas fa-diagnoses"></i> Demandes de rencontre</a>
                            </li>

                            <li class="nav-item">
                                <a class="nav-link" href="{{ URL::route('admin_evaluations_simili') }}"><i class="fas fa-clipboard-list"></i> Simili</a>
                            </li>

                            <li class="nav-item">
                                <a class="nav-link" href="#" data-toggle="collapse" aria-expanded="false" data-target="#submenu-11" aria-controls="submenu-11"><i class="fas fa-clipboard-list"></i>Devoirs & Alerts</a>
                                <div id="submenu-11" class="collapse submenu" style="">
                                    <ul class="nav flex-column">
                                        <li class="nav-item">
                                            <a class="nav-link" href="{{ URL::route('admin_devoirs') }}"><i class="fas fa-clipboard-list"></i>Les devoirs</a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="nav-link" href="{{ URL::route('admin_devoirs_alerts') }}"><i class="fas fa-minus-circle"></i>Alerts</a>
                                        </li>
                                    </ul>
                                </div>
                            </li>

                            <li class="nav-item ">
                                <a class="nav-link" href="{{ URL::route('admin_preparation_exam') }}"><i class="far fa-clipboard"></i>Préparation à l'exam</a>
                            </li>

                            <li class="nav-item">
                                <a class="nav-link" href="{{ URL::route('admin_evaluations_controle') }}"><i class="fas fa-clipboard-list"></i>Evaluation des apprentissages</a>
                            </li>






@elseif(auth()->user()->is_teacher == 1) 

                            <li>
                                <h3 style="text-align: center; color: #FF5722" class="text-uppercase">Espace Enseignant</h3>
                            </li>

                            <li class="nav-item ">
                                <a class="nav-link" href="{{ URL::route('enseignant_index') }}"><i class="fa fa-fw fas fa-box"></i>Statistiques</a>
                            </li>

                            <li class="nav-item ">
                                <a class="nav-link" href="{{ URL::route('enseignant_avis_notes') }}"><i class="fa fa-fw fas fa-globe"></i> Avis et notes</a>
                            </li>

                            <li class="nav-item ">
                                <a class="nav-link" href="{{ URL::route('enseignant_fournitures_annee') }}"><i class="fas fa-suitcase"></i>Fournitures de l'année</a>
                            </li>


                            <li class="nav-item ">
                                <a class="nav-link" href="{{ URL::route('enseignant_documents') }}"><i class="fa fa-fw fa-folder"></i>Mes dossiers</a>
                            </li>

                            <li class="nav-item ">
                                <a class="nav-link" href="{{ URL::route('enseignant_emploi') }}"><i class="fa fa-fw fa-table"></i>Emploi du temps</a>
                            </li>

                            <li class="nav-item ">
                                <a class="nav-link" href="{{ URL::route('enseignant_grille_evaluation') }}"><i class="fas fa-th-list"></i> Grille d'évaluation</a>
                            </li>

                            <li class="nav-item">
                                <a class="nav-link" href="{{ URL::route('enseignant_depot_document') }}"> <i class="fas fa-file-pdf"></i> Documents</a>
                            </li>

                            <li class="nav-item ">
                                <a class="nav-link" href="{{ URL::route('enseignant_demandes_rencontre') }}"><i class="fas fa-diagnoses"></i> Demandes de rencontre</a>
                            </li>

                            <li class="nav-item ">
                                <a class="nav-link" href="{{ URL::route('enseignant_repartition') }}"><i class="fas fa-sitemap"></i>التوزيع الدوري</a>
                            </li>

                            <li class="nav-item ">
                                <a class="nav-link" href="{{ URL::route('cahier_journal') }}"><i class="fa fa-fw fa-book"></i>دفتر النصوص</a>
                            </li>

                            <li class="nav-item ">
                                <a class="nav-link" href="{{ URL::route('enseignant_absence_request') }}"><i class="fa fa-info-circle"></i> طلب ترخيص الغياب</a>
                            </li>

                            <li class="nav-item ">
                                <a class="nav-link" href="{{ URL::route('enseignant_demandes_documents') }}"><i class="fas fa-file-alt"></i>طلب الوثائق</a>
                            </li>

                            <li class="nav-item ">
                                <a class="nav-link" href="{{ URL::route('enseignant_devoirs') }}"><i class="fas fa-clipboard-list"></i> Les devoirs de la semaine</a>
                            </li>

                            <li class="nav-item">
                                <a class="nav-link" href="#" data-toggle="collapse" aria-expanded="false" data-target="#submenu-19" aria-controls="submenu-19"><i class="far fa-clipboard"></i>Préparation à l'exam</a>
                                <div id="submenu-19" class="collapse submenu" style="">
                                    <ul class="nav flex-column">

                                        <li class="nav-item ">
                                            <a class="nav-link" href="{{ URL::route('enseignant_preparation') }}?cl=2Bac"><i class="far fa-clipboard"></i>2Bac</a>
                                        </li>

                                        <li class="nav-item ">
                                            <a class="nav-link" href="{{ URL::route('enseignant_preparation') }}?cl=1Bac"><i class="far fa-clipboard"></i>1Bac</a>
                                        </li>

                                        <li class="nav-item ">
                                            <a class="nav-link" href="{{ URL::route('enseignant_preparation') }}?cl=3AC"><i class="far fa-clipboard"></i>3AC</a>
                                        </li>

                                        <li class="nav-item ">
                                            <a class="nav-link" href="{{ URL::route('enseignant_preparation') }}?cl=C6"><i class="far fa-clipboard"></i>C6</a>
                                        </li>

                                    </ul>
                                </div>
                            </li>

                            <li class="nav-item">
                                <a class="nav-link" href="{{ URL::route('enseignant_evaluations_simili') }}"><i class="fas fa-file-alt"></i> Simili</a>
                            </li>


                            <li class="nav-item">
                                <a class="nav-link" href="#" data-toggle="collapse" aria-expanded="false" data-target="#submenu-10" aria-controls="submenu-10"><i class="fas fa-list"></i>Évaluations</a>
                                <div id="submenu-10" class="collapse submenu" style="">
                                    <ul class="nav flex-column">
                                        <li class="nav-item">
                                           <a class="nav-link" href="{{ URL::route('enseignant_evaluations') }}"><i class="fas fa-file-alt"></i>Évaluations Devoirs</a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="nav-link" href="{{ URL::route('enseignant_evaluations_controle') }}"><i class="fas fa-file-alt"></i>Evaluation des apprentissages</a>
                                        </li>
                                    </ul>
                                </div>
                            </li>


                            <li class="nav-item ">
                                <a class="nav-link" href="{{ URL::route('enseignant_assiduite') }}"><i class="far fa-building"></i>Assiduité</a>
                            </li>

                            <li class="nav-item ">
                                <a class="nav-link" href="{{ URL::route('enseignant_compte_rendu') }}"><i class="fas fa-file-alt"></i>Compte rendu</a>
                            </li>

                            <li class="nav-item ">
                                <a class="nav-link" href="{{ URL::route('enseignant_profile') }}"><i class="fa fa-fw fa-user"></i>Profil</a>
                            </li>

@elseif(auth()->user()->is_student == 1)  
                            
                            <li>
                                <h2 style="text-align: center; color: #FF5722" class="text-uppercase">Espace Élève</h2>
                            </li>

                            <li class="nav-item ">
                                <a class="nav-link" href="{{ URL::route('students_index') }}"><i class="fa fa-fw fas fa-box"></i>Statistiques</a>
                            </li>

                            <li class="nav-item ">
                                <a class="nav-link" href="{{ URL::route('eleve_avis_notes') }}"><i class="fa fa-fw fas fa-globe"></i> Avis et notes</a>
                            </li>

                            <li class="nav-item">
                                <a class="nav-link" href="#" data-toggle="collapse" aria-expanded="false" data-target="#submenu-13" aria-controls="submenu-13"><i class="fas fa-book"></i>Mon cahier de texte</a>
                                <div id="submenu-13" class="collapse submenu" style="">
                                    <ul class="nav flex-column">
                                        <li class="nav-item">
                                           <a class="nav-link" href="{{ URL::route('travaux_afaire') }}"><i class="far fa-clipboard"></i>Travaux à faire <small>(devoirs)</small></a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="nav-link" href="{{ URL::route('students_preparation_exam') }}"><i class="far fa-clipboard"></i>Préparation à l'exam</a>
                                        </li>
                                    </ul>
                                </div>
                            </li>

     

                            <li class="nav-item ">
                                <a class="nav-link" href="{{ URL::route('students_dossiers') }}"><i class="fa fa-fw fa-folder"></i>Mes ressources</a>
                            </li>

                            <li class="nav-item ">
                                <a class="nav-link" href="{{ URL::route('students_emploi') }}"><i class="fa fa-fw fa-table"></i>Emploi du temps</a>
                            </li>


                            <li class="nav-item">
                                <a class="nav-link" href="{{ URL::route('students_depot_document') }}"> <i class="fas fa-file-pdf"></i> Documents</a>
                            </li>

                            <li class="nav-item">
                                <a class="nav-link" href="{{ URL::route('student_evaluations_simili') }}"><i class="fas fa-clipboard-list"></i> Simili</a>
                            </li>


                            <li class="nav-item">
                                <a class="nav-link" href="#" data-toggle="collapse" aria-expanded="false" data-target="#submenu-10" aria-controls="submenu-10"><i class="fas fa-list"></i>Mes évaluations</a>
                                <div id="submenu-10" class="collapse submenu" style="">
                                    <ul class="nav flex-column">
                                        <li class="nav-item">
                                           <a class="nav-link" href="{{ URL::route('students_evaluations') }}"><i class="fas fa-clipboard-list"></i>Évaluations devoirs</a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="nav-link" href="{{ URL::route('student_evaluations_controle') }}"><i class="fas fa-clipboard-list"></i>Evaluation des apprentissages</a>
                                        </li>
                                    </ul>
                                </div>
                            </li>


                            <li class="nav-item">
                                <a class="nav-link" href="#" data-toggle="collapse" aria-expanded="false" data-target="#submenu-14" aria-controls="submenu-14"><i class="fas fa-building"></i>Mon assiduité</a>
                                <div id="submenu-14" class="collapse submenu" style="">
                                    <ul class="nav flex-column">
                                        <li class="nav-item">
                                           <a class="nav-link" href="{{ URL::route('student_assiduite') }}"><i class="far fa-building"></i>Assiduité</a>
                                        </li>

                                        <?php $CountCompteRendu = \App\CompteRendu::where('student_id', auth()->user()->id)->where('readed', 0)->get(); ?>

                                        <li class="nav-item">
                                            <a class="nav-link" href="{{ URL::route('student_compte_rendu') }}"><i class="fas fa-file-alt"></i>Compte rendu @if(count($CountCompteRendu) > 0) <strong style="font-size: 16px; color: #1B3FFF;">( {{ count($CountCompteRendu) }} )</strong> @endif </a>
                                        </li>
                                    </ul>
                                </div>
                            </li>



                            <li class="nav-item ">
                                <a class="nav-link" href="{{ URL::route('student_profile') }}"><i class="fa fa-fw fa-user"></i>Profil</a>
                            </li>


@endif                     

                            <li class="nav-item ">
                                <a class="nav-link" href="{{ URL::route('logout') }}"><i class="fas fa-power-off"></i>Se déconnecter</a>
                            </li>
                            
                        </ul>
                    </div>
                </nav>
            </div>
        </div>
        <!-- ============================================================== -->
        <!-- end left sidebar -->
        <!-- ============================================================== -->
        <div class="dashboard-wrapper">
            <div class="dashboard-influence">

<div class="container-fluid dashboard-content">

    @yield('content')

</div>

            <!-- ============================================================== -->
            <!-- footer -->
            <!-- ============================================================== -->
            <?php /* ?>
            <div class="footer">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12 col-12">
                             Copyright © 2021 Groupe Scolaire Verdin.
                        </div>
                    </div>
                </div>
            </div>
            <?php */ ?>
            <!-- ============================================================== -->
            <!-- end footer -->
            <!-- ============================================================== -->
        </div>
        <!-- ============================================================== -->
        <!-- end wrapper  -->
        <!-- ============================================================== -->
    </div>
</div>    
    <!-- ============================================================== -->
    <!-- end main wrapper  -->
    <!-- ============================================================== -->
    <!-- Optional JavaScript -->
    <!-- jquery 3.3.1 -->
    <script src="{{url('/')}}/assets/vendor/jquery/jquery-3.3.1.min.js"></script>
    <!-- bootstap bundle js -->
    <script src="{{url('/')}}/assets/vendor/bootstrap/js/bootstrap.bundle.js"></script>
    <!-- slimscroll js -->
    <script src="{{url('/')}}/assets/vendor/slimscroll/jquery.slimscroll.js"></script>
    <!-- main js -->
    <script src="{{url('/')}}/assets/libs/js/main-js.js"></script>


    <!-- morris-chart js -->
    <script src="{{url('/')}}/assets/vendor/charts/morris-bundle/raphael.min.js"></script>
    <script src="{{url('/')}}/assets/vendor/charts/morris-bundle/morris.js"></script>
    <script src="{{url('/')}}/assets/vendor/charts/morris-bundle/morrisjs.html"></script>
    
    <!-- chart js -->
    <script src="{{url('/')}}/assets/vendor/charts/charts-bundle/Chart.bundle.js"></script>
    <script src="{{url('/')}}/assets/vendor/charts/charts-bundle/chartjs.js"></script>
    <!-- dashboard js -->
    <script src="{{url('/')}}/assets/libs/js/dashboard-influencer.js"></script>

    <script src="{{url('/')}}/assets/vendor/bootstrap-select/js/bootstrap-select.js"></script>
        
    @yield('JS')

@if(auth()->user()->is_admin == 1) 
<script type="text/javascript">
$(document).ready(function () {
    const timeoutz = 600000;  // 600000 ms = 10 minutes
    var idleTimer = null;
    $('*').bind('mousemove click mouseup mousedown keydown keypress keyup submit change mouseenter scroll resize dblclick', function () {
        clearTimeout(idleTimer);
        idleTimer = setTimeout(function () {
            window.location='{{ url("/") }}/logout';
        }, timeoutz);
    });
    $("body").trigger("mousemove");
});
</script>
@endif

</body>
 
</html>