@extends('layouts.master_panel')

@section('title') Mes dossiers @stop

@section('CSS') 


<link rel="stylesheet" type="text/css" href="{{url('/')}}/js/datatables/dataTables.bootstrap4.min.css">

<style type="text/css">
.figure-attachment {
    min-height: 100px;
}
.fa-lg {
  font-size: 36px !important;
}


</style>

@stop

@section('JS') 


<script src="{{url('/')}}/js/datatables/jquery.dataTables.min.js"></script>
<script src="{{url('/')}}/js/datatables/dataTables.bootstrap4.min.js"></script>

<script type="text/javascript" class="init">
  $(document).ready(function() {
    $("#example").dataTable({ "language": { "url": "{{ url('/') }}/js/datatables/lang/fr.json" }
    });
  });
  </script>

@stop


@section('content')
                  
                  <!-- ============================================================== -->
                  <!-- pageheader  -->
                  <!-- ============================================================== -->
                  <div class="row">
                      <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                          <div class="page-header">
                              <h3 class="mb-2">Mes dossiers </h3>
                           
                              <div class="page-breadcrumb">
                                  <nav aria-label="breadcrumb">
                                      <ol class="breadcrumb">
                                          <li class="breadcrumb-item"><a href="{{ URL::route('enseignant_index') }}" class="breadcrumb-link">Accueil</a></li>
                                          <li class="breadcrumb-item active" aria-current="page">Mes dossiers</li>
                                      </ol>
                                  </nav>
                              </div>
                          </div>
                      </div>
                  </div>
                  <!-- ============================================================== -->
                  <!-- end pageheader  -->
                  <!-- ============================================================== -->


<div class="row">


<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
  <div class="card">
    <h5 class="card-header">
      <a href="#" class="btn btn-primary mb-1" data-toggle="modal" data-target="#exampleModal"><i class="fa fa-folder"></i> Nouveau dossier </a>

<?php 
$settings = \App\Settings::first();
$allyears = \App\AcademicYear::where('id', '!=', $settings->default_year)->orderBy('id', 'desc')->get(); 
?>

@foreach($allyears as $ayear)
<a href="{{ URL::route('old_dossiers', $ayear->id) }}" class="btn btn-brand mb-1" ><i class="fa fa-calendar"></i> Dossiers de l'ancienne année ({{ $ayear->name }}) </a>
@endforeach

    </h5>
  <div class="card-body">

<!-- Modal -->
<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
<div class="modal-dialog modal-lg" role="document">
  <div class="modal-content">
    <div class="modal-header">
      <h5 class="modal-title" id="exampleModalLabel">Nouveau dossier</h5>
      <a href="#" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></a>
    </div>
    <div class="modal-body">

<form method="POST" action="{{ URL::route('folders_store') }}">

{{ csrf_field() }}


  <div class="col-md-12 mb-3">
    <div class="form-group">
    <label>Nouveau dossier:</label>
    <input name="folder_name" type="text" class="form-control input-lg" value="{{ old('folder_name') }}" required>
    </div>
  </div>

<div class="col-md-12 mb-4">
      <label>Classes - Matières</label>
      <select name="class_id" class="selectpicker" data-width="100%" required="required">   
      <option value="">Choisir</option>
        @foreach($subjects as $subject)
          <option value="{{ $subject->cl_id }}">{{ $subject->cl_name }} - {{ $subject->sbj_name }}</option>
        @endforeach
      </select>
</div>


<div class="col-md-12">
    <button class="btn btn-success btn-block input-lg" type="submit">Ajouter</button>
</div>


</form>

    </div>
    <div class="modal-footer">
      <a href="#" class="btn btn-dark" data-dismiss="modal">Fermer</a>
    </div>
  </div>
</div>
</div>
<!-- End Modal -->


<div class="clearfix"></div>

@if(Session::has('error'))

<div class="alert alert-danger alert-dismissible fade show text-center" role="alert">
  <strong>{{ Session::get('error') }}</strong>
  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
    <span aria-hidden="true">&times;</span>
  </button>
</div>

@endif

@if(Session::has('success'))
<div class="alert alert-success alert-dismissible fade show text-center" role="alert">
  <strong>{{ Session::get('success') }}</strong>
  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
    <span aria-hidden="true">&times;</span>
  </button>
</div>
@endif

<div class="clearfix"></div>

<div class="row">
@foreach($folders as $folder)

<div class="col-xl-4 col-lg-6 col-md-6 col-sm-12 col-12">
  <div class="card card-figure">

<a href="{{ URL::route('folder_files', $folder->id) }}">
      <figure class="figure">
        <div class="figure-attachment">
          <span class="fa-stack fa-lg">
            <i class="fa fa-square fa-stack-2x text-primary"></i>
            <i class="fa fa-folder fa-stack-1x fa-inverse"></i>
          </span>
        </div>
        <figcaption class="figure-caption">
          <ul class="list-inline d-flex text-muted mb-0">
            <li class="list-inline-item text-truncate mr-auto">
              {{ html_entity_decode($folder->folder_name) }}
              <p class="text-muted"><i class="fa fa-file"></i> <small><strong>{{ count(App\EnseignantsFiles::where('folder_id', $folder->id)->get()) }}</strong> ressources</small>

              <?php $GetClass = \App\Classes::find($folder->class_id); ?> 
              @if($GetClass !== null) <i class="fa fa-table"></i> <small><strong>{{ $GetClass->name }}</strong></small> @endif

              </p>
              <a href="#" data-toggle="modal" data-target="#exampleModal-{{ $folder->id }}" class="btn btn-outline-primary btn-xs"><i class="fa fa-edit"></i> Modifier</a>
            </li>
          </ul>
        </figcaption>
      </figure>
</a>

    </div>
  </div>        



<!-- Modal -->
<div class="modal fade" id="exampleModal-{{ $folder->id }}" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel-{{ $folder->id }}" aria-hidden="true">
<div class="modal-dialog" role="document">
  <div class="modal-content">
    <div class="modal-header">
      <h5 class="modal-title" id="exampleModalLabel-{{ $folder->id }}">Renommer</h5>
      <a href="#" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></a>
    </div>
    <div class="modal-body">

<form method="POST" action="{{ URL::route('folder_update', $folder->id) }}">

{{ csrf_field() }}


  <div class="col-md-12">
    <div class="form-group">
    <label>Nom de dossier:</label>
    <input name="folder_name_up" type="text" class="form-control input-lg" value="<?php echo html_entity_decode($folder->folder_name); ?>" required>
    </div>
  </div>


<div class="col-md-12 mb-4">
      <label>Classes - Matières</label>
      <select name="class_id_up" class="selectpicker" data-width="100%" required="required"> 

@if($GetClass !== null) 
<option value="{{ $GetClass->id }}">{{ $GetClass->name }}</option>
@else
<option value="">Choisir</option>
@endif 
      
        @foreach($subjects as $subject)
          <option value="{{ $subject->cl_id }}">{{ $subject->cl_name }} - {{ $subject->sbj_name }}</option>
        @endforeach
      </select>
</div>


<div class="clearfix"></div><br>

<div class="col-md-12">
    <button class="btn btn-success btn-block input-lg" type="submit">Renommer</button>
</div>


</form>

    </div>
    <div class="modal-footer">
      <a href="#" class="btn btn-dark" data-dismiss="modal">Fermer</a>
    </div>
  </div>
</div>
</div>
<!-- End Modal -->


@endforeach
</div>

    </div>
  </div>
</div>

                          
</div><!-- END row -->

                    

@stop