<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>{{ $grille_evaluation->titre }}</title>

    <link rel="stylesheet" href="{{url('/')}}/assets/vendor/bootstrap/css/bootstrap.min.css">


<style type="text/css">


.print {margin-bottom: 0; padding-bottom: 0;}


body {
    background-color: #FFFFFF;
    margin:0;
    padding-top: 6mm;
}

.clear { clear: both; }
.center { text-align: center; }


table { page-break-inside:auto }
tr    { page-break-inside:avoid; page-break-after:auto }
thead { display:table-header-group }
tfoot { display:table-footer-group }



hr {
    display: block;
    height: 1px;
    background: transparent;
    width: 100%;
    border: none;
    border-top: solid 1px #000;
    margin: 0px; padding: 0px;
}

@media print {
   body {
       padding-top: 0.2cm;
       padding-bottom: 0cm;
       height: auto;
   }

   img.img-thumbnail { width: 20%; margin-left: 1%; overflow: all;}

    .clear { clear: both; }
    .center { text-align: center; }
    .no-print { display: none; }

}

@page {
    size: A4 ;   /* auto is the initial value */
    margin: 2mm;  /* this affects the margin in the printer settings */
}

.table-border tr, .table-border th, .table-border td {
    border-width: 1px !important;
    border-style: solid !important;
    border-color: #000 !important;
    padding: 20px;
    
  }

.table-border {
    margin-top: 20px;

}

table p { font-size: 0.8em; }

.mr-15 { margin-right: 25px; }
.mr-50 { margin-right: 50px; }
.ml-50 { margin-left: 100px; }
.mt-30 { clear: both; margin-top: 30px; }

tr strong { margin-right: 100px; }



</style>




</head>
<body onload=" //window.print(); ">

<div class="col-md-12 no-print">
<button onclick="window.print();" class="btn btn-primary btn-lg no-print" style="font-size: 22px;"><i class="fa fa-print"></i> Imprimer</button>
</div>


<table width="100%">
  <tr>

     <td align="center" style="width: 30%;">
        <p style="font-size: 14px; margin-top: 3px; font-weight: bold; color: #0000ff; font-family: georgia, 'times new roman', times, serif;">Groupe Scolaire VERDIN</p>
        <p style="font-size: 10px; margin-top: -11px; line-height: 18px; font-family: georgia, 'times new roman', times, serif;">Maternelle – Primaire – Collège – Lycée <br>
          15 Rue Abou Abdellah Mahassibi Casa-Anfa 
        </p>
     </td>
      <td align="center" style="width: 40%;"><strong>Grille d'évaluation de l'enseignant</strong></td>
    <?php $year = \App\AcademicYear::find($grille_evaluation->year_id); ?>
     <td align="center" style="width: 30%;">Année scolaire: {{ $year->name }}</td>

  </tr>
</table>



<div class="clear"></div><br>

<table width="100%">
  <tr>
<?php $FindSubject = \App\Subjects::find($grille_evaluation->subject_id); ?>
     <td align="center" style="width: 100%;">
        <p>
          Nom de l’enseignant(e): <strong>{{ $grille_evaluation->teacher->last_name . ' ' . $grille_evaluation->teacher->first_name }}</strong>

          Matière: <strong>@if($FindSubject !== null ) {{ $FindSubject->name }} @endif</strong>

          Classe: <strong>@if($FindSubject !== null ) {{ $FindSubject->classe->name }} @endif</strong>

        </p>

        <p>
          Titre de la leçon observée: <strong>{{ $grille_evaluation->titre }}</strong>

          Date: <strong><?php 
                    $FrDateTime = \DateTime::createFromFormat('Y-m-d', $grille_evaluation->date);
                    echo $FrDateTime->format('d/m/Y');
                    ?></strong>

          Heure: <strong>{{ $grille_evaluation->heure }}</strong>

        </p>
        
     </td>

  </tr>
</table>


<div class="col-md-12">
<table width="100%" class="table-border">
  <tr>
    <td align="left" style="width: 100%;">

  <p><strong>DOCUMENTATION DE L’ENSEIGNANT(E):</strong></p>

  <p>Progression annuelle - respectée: <strong class="mr-50">@if($grille_evaluation->progression_annuelle_respectee == 1) Oui @else Non @endif</strong>

    Progression annuelle - validée: <strong class="mr-50">@if($grille_evaluation->progression_annuelle_validee == 1) Oui @else Non @endif</strong>

  </p>

  <p>Progression semestrielle - respectée: <strong class="mr-50">@if($grille_evaluation->progression_semestrielle_respectee == 1) Oui @else Non @endif</strong>

    Progression semestrielle - validée: <strong class="mr-50">@if($grille_evaluation->progression_semestrielle_validee == 1) Oui @else Non @endif</strong>

  </p>


  <p>L’emploi du temps - respecté: <strong class="mr-50">@if($grille_evaluation->emploi_temps_respecte == 1) Oui @else Non @endif</strong>

    Le cahier journal - à jour: <strong class="mr-50">@if($grille_evaluation->cahier_journal_ajour == 1) Oui @else Non @endif</strong>

    Le cahier journal - détaillé: <strong class="mr-50">@if($grille_evaluation->cahier_journal_detaille == 1) Oui @else Non @endif</strong>

    Le cahier journal - bien présenté: <strong class="mr-50">@if($grille_evaluation->cahier_journal_bpresente == 1) Oui @else Non @endif</strong>

  </p>

  <p>Les fiches de préparation - sous format papier: <strong class="mr-50">@if($grille_evaluation->fiches_preparation_fpexiste == 1) Oui @else Non @endif</strong>

    Les fiches de préparation - sous format numérique: <strong class="mr-50">@if($grille_evaluation->fiches_preparation_fnexiste == 1) Oui @else Non @endif</strong>
  </p>
  <p>Les fiches de préparation - bien présentées: <strong class="mr-50">@if($grille_evaluation->fiches_preparation_bpresente == 1) Oui @else Non @endif</strong>

  </p>

  <p>Les fiches de préparation - conforment au protocole N°1 d'enseignement: <strong class="mr-50">@if($grille_evaluation->fiches_preparation_conforment == 1) Oui @else Non @endif</strong>

    Les fiches de préparation - prévoit des exercices de soutien et d'approfondissement: <strong class="mr-50">@if($grille_evaluation->fiches_preparation_soutien_approfon == 1) Oui @else Non @endif</strong>

  </p>


    </td>
  </tr>
</table>  
</div><!-- .col-md-12 -->




<div class="col-md-12">
<table width="100%" class="table-border">
  <tr>
    <td align="left" style="width: 100%;">

  <p><strong>CAHIERS TENUS PAR LES ELEVES - Cahiers d'exercices:</strong></p>

  <p>Fréquence des exercices réalisés par semaine: <strong class="mr-50">@if($grille_evaluation->cahiers_exercices_frequence == 1) Toujours @elseif($grille_evaluation->cahiers_exercices_frequence == 2) Souvent @else Pas assez @endif</strong>

    Qualité des exercices (appropriés): <strong class="mr-50">@if($grille_evaluation->cahiers_exercices_qualiteappropries == 1) Oui @else Non @endif</strong>

    Qualité des exercices (diversifiés): <strong class="mr-50">@if($grille_evaluation->cahiers_exercices_qualitediversifies == 1) Oui @else Non @endif</strong>

    Qualité des exercices (prévoient des tâches complexes): <strong class="mr-50">@if($grille_evaluation->cahiers_exercices_qualitetachescomplexe == 1) Oui @else Non @endif</strong>

  </p>


  <p>Correction par les élèves: <strong class="mr-50">@if($grille_evaluation->cahiers_exercices_correction == 1) Toujours @elseif($grille_evaluation->cahiers_exercices_correction == 2) Souvent @else Pas assez @endif</strong>

    Soins (propreté): <strong class="mr-50">@if($grille_evaluation->cahiers_exercices_soinsproprete == 1) Toujours @elseif($grille_evaluation->cahiers_exercices_soinsproprete == 2) Souvent @else Pas assez @endif</strong>

    Soins (soulignement): <strong class="mr-50">@if($grille_evaluation->cahiers_exercices_soinssoulignement == 1) Toujours @elseif($grille_evaluation->cahiers_exercices_soinssoulignement == 2) Souvent @else Pas assez @endif</strong>

    Notation des exercices: <strong class="mr-50">@if($grille_evaluation->cahiers_exercices_notation == 1) Toujours @elseif($grille_evaluation->cahiers_exercices_notation == 2) Souvent @else Pas assez @endif</strong>

    Appréciations existantes: <strong class="mr-50">@if($grille_evaluation->cahiers_exercices_appreciationsexist == 1) Toujours @elseif($grille_evaluation->cahiers_exercices_appreciationsexist == 2) Souvent @else Pas assez @endif</strong>

  </p>

  <p>Favorisant davantage l’implication de l’élève: <strong class="mr-50">@if($grille_evaluation->cahiers_exercices_appreciationsimplication == 1) Oui @else Non @endif</strong>

  </p>


    </td>
  </tr>
</table>  
</div><!-- .col-md-12 -->





<div class="col-md-12">
<table width="100%" class="table-border">
  <tr>
    <td align="left" style="width: 100%;">

  <p><strong>CAHIERS TENUS PAR LES ELEVES - Cahiers de leçons:</strong></p>

  <p>Soins (propreté): <strong class="mr-50">@if($grille_evaluation->cahiers_lecons_soinsproprete == 1) Toujours @elseif($grille_evaluation->cahiers_lecons_soinsproprete == 2) Souvent @else Pas assez @endif</strong>

    Soins (soulignement): <strong class="mr-50">@if($grille_evaluation->cahiers_lecons_soinssoulignement == 1) Toujours @elseif($grille_evaluation->cahiers_lecons_soinssoulignement == 2) Souvent @else Pas assez @endif</strong>

    visés par l’enseignant: <strong class="mr-50">@if($grille_evaluation->cahiers_lecons_visesenseignant == 1) Toujours @elseif($grille_evaluation->cahiers_lecons_visesenseignant == 2) Souvent @else Pas assez @endif</strong>

    À jour: <strong class="mr-50">@if($grille_evaluation->cahiers_lecons_ajour == 1) Oui @else Non @endif</strong>

    Visés: <strong class="mr-50">@if($grille_evaluation->cahiers_lecons_vises == 1) Toujours @elseif($grille_evaluation->cahiers_lecons_vises == 2) Souvent @else Pas assez @endif</strong>

  </p>




    </td>
  </tr>
</table>  
</div><!-- .col-md-12 -->





<div class="col-md-12">
<table width="100%" class="table-border">
  <tr>
    <td align="left" style="width: 100%;">

  <p><strong>CAHIERS TENUS PAR LES ELEVES - Cahiers de maison/recherche:</strong></p>

  <p>Fréquence des exercices réalisés par semaine: <strong class="mr-50">@if($grille_evaluation->cahiers_maison_frequence == 1) Toujours @elseif($grille_evaluation->cahiers_maison_frequence == 2) Souvent @else Pas assez @endif</strong>

    Qualité des exercices (appropriés): <strong class="mr-50">@if($grille_evaluation->cahiers_maison_qualiteappropries == 1) Oui @else Non @endif</strong>

    Qualité des exercices (diversifiés): <strong class="mr-50">@if($grille_evaluation->cahiers_maison_qualitediversifies == 1) Oui @else Non @endif</strong>

    Qualité des exercices (Tâches complexes): <strong class="mr-50">@if($grille_evaluation->cahiers_maison_qualitetachescomplexe == 1) Oui @else Non @endif</strong>

  </p>


  <p>Correction par les élèves: <strong class="mr-50">@if($grille_evaluation->cahiers_maison_correction == 1) Toujours @elseif($grille_evaluation->cahiers_maison_correction == 2) Souvent @else Pas assez @endif</strong>

    Soins (propreté): <strong class="mr-50">@if($grille_evaluation->cahiers_maison_soinsproprete == 1) Toujours @elseif($grille_evaluation->cahiers_maison_soinsproprete == 2) Souvent @else Pas assez @endif</strong>

    Soins (soulignement): <strong class="mr-50">@if($grille_evaluation->cahiers_maison_soinssoulignement == 1) Toujours @elseif($grille_evaluation->cahiers_maison_soinssoulignement == 2) Souvent @else Pas assez @endif</strong>

    Notation des exercices: <strong class="mr-50">@if($grille_evaluation->cahiers_maison_notation == 1) Toujours @elseif($grille_evaluation->cahiers_maison_notation == 2) Souvent @else Pas assez @endif</strong>

    Appréciations existantes: <strong class="mr-50">@if($grille_evaluation->cahiers_maison_appreciationsexist == 1) Toujours @elseif($grille_evaluation->cahiers_maison_appreciationsexist == 2) Souvent @else Pas assez @endif</strong>

    Visés: <strong class="mr-50">@if($grille_evaluation->cahiers_maison_vises == 1) Toujours @elseif($grille_evaluation->cahiers_maison_vises == 2) Souvent @else Pas assez @endif</strong>

  </p>




    </td>
  </tr>
</table>  
</div><!-- .col-md-12 -->




<div class="col-md-12">

  <div class="clearfix"></div><br><br>

<table width="100%" class="table-border">
  <tr>
    <td align="left" style="width: 100%;">

  <p><strong>LE TRAVAIL EN CLASSE - Intérêt de l'enseignant pour son cours:</strong></p>

  <p>utilise différents supports pédagogiques: <strong class="mr-50">@if($grille_evaluation->interet_supportspedagogiques == 1) Oui @else Non @endif</strong>

    lit ses notes ou un document écrit: <strong class="mr-50">@if($grille_evaluation->interet_lirenotes == 1) Oui @else Non @endif</strong>

    suggère des implications pratiques: <strong class="mr-50">@if($grille_evaluation->interet_implicationspratiques == 1) Oui @else Non @endif</strong>

  </p>
  <p>montre de l'intérêt et de l'enthousiasme: <strong class="mr-50">@if($grille_evaluation->interet_montreenthousiasme == 1) Oui @else Non @endif</strong>

  </p>


 <p><strong>LE TRAVAIL EN CLASSE - Clarté du cours:</strong></p>

  <p>utilise un débit de parole approprié: <strong class="mr-50">@if($grille_evaluation->clartecours_paroleapproprie == 1) Oui @else Non @endif</strong>

    parle d'une voix non monotone: <strong class="mr-50">@if($grille_evaluation->clartecours_nonmonotone == 1) Oui @else Non @endif</strong>

    s'exprime clairement: <strong class="mr-50">@if($grille_evaluation->clartecours_exprimeclairement == 1) Oui @else Non @endif</strong>

    

  </p>

  <p>avance dans son cours à une vitesse mesurée: <strong class="mr-50">@if($grille_evaluation->clartecours_avancecoursvmesuree == 1) Oui @else Non @endif</strong>

  utilise le tableau pour rendre son cours plus clair: <strong class="mr-50">@if($grille_evaluation->clartecours_utilisetableau == 1) Oui @else Non @endif</strong></p>


  <p><strong>LE TRAVAIL EN CLASSE - Relation avec les élèves:</strong></p>

  <p>accepte des points de vue divergents: <strong class="mr-50">@if($grille_evaluation->relationeleves_pointsvuedivergents == 1) Oui @else Non @endif</strong>

    apporte de l'aide en cas d'incompréhension: <strong class="mr-50">@if($grille_evaluation->relationeleves_apporteaide == 1) Oui @else Non @endif</strong>

    montre du respect envers les élèves: <strong class="mr-50">@if($grille_evaluation->relationeleves_montrerespect == 1) Oui @else Non @endif</strong>

  </p>


  <p><strong>LE TRAVAIL EN CLASSE - Organisation du cours:</strong></p>

  <p>donne les objectifs de son cours: <strong class="mr-50">@if($grille_evaluation->organisationcours_donneobjectifs == 1) Oui @else Non @endif</strong>

  présente le cours de manière organisée: <strong class="mr-50">@if($grille_evaluation->organisationcours_organise == 1) Oui @else Non @endif</strong>

  donne des documents de travail: <strong class="mr-50">@if($grille_evaluation->organisationcours_donnedocuments == 1) Oui @else Non @endif</strong>

  </p>

  <p>fait des synthèses utiles lors de son cours: <strong class="mr-50">@if($grille_evaluation->organisationcours_faitsyntheses == 1) Oui @else Non @endif</strong>

  respecte les 3 temps de la séance: <strong class="mr-50">@if($grille_evaluation->organisationcours_respecte3temps == 1) Oui @else Non @endif</strong>

  </p>


   <p><strong>LE TRAVAIL EN CLASSE - Incitation à la participation:</strong></p>

  <p>encourage les questions et les commentaires: <strong class="mr-50">@if($grille_evaluation->incitationparticipation_encouragequestions == 1) Oui @else Non @endif</strong>

  questionne individuellement les élèves: <strong class="mr-50">@if($grille_evaluation->incitationparticipation_questionneindividuellement == 1) Oui @else Non @endif</strong>

  pose des questions à la classe entière: <strong class="mr-50">@if($grille_evaluation->incitationparticipation_posequestions == 1) Oui @else Non @endif</strong>

  </p>

  <p>incite les élèves à interagir: <strong class="mr-50">@if($grille_evaluation->incitationparticipation_inciteeleves == 1) Oui @else Non @endif</strong>

  pose des questions complexes: <strong class="mr-50">@if($grille_evaluation->incitationparticipation_questionscomplexes == 1) Oui @else Non @endif</strong>

  </p>


  <p><strong>LE TRAVAIL EN CLASSE - Explications:</strong></p>

  <p>utilise des exemples: <strong class="mr-50">@if($grille_evaluation->explications_utiliseexemples == 1) Oui @else Non @endif</strong>

  répète ce qui est difficile: <strong class="mr-50">@if($grille_evaluation->explications_repetedifficile == 1) Oui @else Non @endif</strong>

  souligne les points centraux: <strong class="mr-50">@if($grille_evaluation->explications_pointscentraux == 1) Oui @else Non @endif</strong>

  donne des détails utiles: <strong class="mr-50">@if($grille_evaluation->explications_donnedetails == 1) Oui @else Non @endif</strong>

</p>
<p>
  identifie les points clés: <strong class="mr-50">@if($grille_evaluation->explications_pointscles == 1) Oui @else Non @endif</strong>

  </p>


  <p><strong>LE TRAVAIL EN CLASSE - Attitude des élèves:</strong></p>

  <p>sont attentifs et appliqués: <strong class="mr-50">@if($grille_evaluation->attitudeeleves_attentifs == 1) Oui @else Non @endif</strong>

  participent activement au cours: <strong class="mr-50">@if($grille_evaluation->attitudeeleves_participentactivement == 1) Oui @else Non @endif</strong>

  respectent l'enseignant(e): <strong class="mr-50">@if($grille_evaluation->attitudeeleves_respectent == 1) Oui @else Non @endif</strong>

  sont motivés par le cours: <strong class="mr-50">@if($grille_evaluation->attitudeeleves_motives == 1) Oui @else Non @endif</strong>

  </p>


    </td>
  </tr>
</table>  
</div><!-- .col-md-12 -->



<div class="col-md-12">
<table width="100%" class="table-border">
  <tr>
    <td align="left" style="width: 100%;">

  <p><strong>LE TRAVAIL EN CLASSE:</strong></p>

  <p>Matériel didactique - existant: <strong class="mr-50">@if($grille_evaluation->materieldidactique_existant == 1) Oui @else Non @endif</strong>

  Matériel didactique - bien utilisé: <strong class="mr-50">@if($grille_evaluation->materieldidactique_bienutilise == 1) Oui @else Non @endif</strong>

  </p>


  <p>Respecte l’emploi du temps: <strong class="mr-50">@if($grille_evaluation->tc_respecteemploi == 1) Oui @else Non @endif</strong>

  Respecte le temps attribué à la discipline: <strong class="mr-50">@if($grille_evaluation->tc_respectetempsattribue == 1) Oui @else Non @endif</strong>

  </p>




    </td>
  </tr>
</table>  
</div><!-- .col-md-12 -->




<div class="col-md-12">
<table width="100%" class="table-border">
  <tr>
    <td align="left" style="width: 100%;">

  <p><strong>Appréciation générale:</strong></p>

  <p><?php echo html_entity_decode($grille_evaluation->appreciation_general); ?></p>


  <p><strong>Recommandations:</strong></p>

  <p><?php echo html_entity_decode($grille_evaluation->recommandations); ?></p>




    </td>
  </tr>
</table>  
</div><!-- .col-md-12 -->

<br />

</body>
</html>