@extends('layouts.master_panel')

@section('title') Compte rendu @stop

@section('CSS') 


<link rel="stylesheet" type="text/css" href="{{url('/')}}/js/datatables/dataTables.bootstrap4.min.css">

<link rel="stylesheet" href="{{url('/')}}/assets/vendor/datepicker/tempusdominus-bootstrap-4.css" />


@stop

@section('JS') 


<script src="{{url('/')}}/js/datatables/jquery.dataTables.min.js"></script>
<script src="{{url('/')}}/js/datatables/dataTables.bootstrap4.min.js"></script>

<script type="text/javascript" class="init">
  $(document).ready(function() {
    $("#example").dataTable({ "language": { "url": "{{ url('/') }}/js/datatables/lang/fr.json" },
      "order": [[ 0, "desc" ]]
    });
  });
  </script>



@stop


@section('content')


                  <!-- ============================================================== -->
                  <!-- pageheader  -->
                  <!-- ============================================================== -->
                  <div class="row">
                      <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                          <div class="page-header">
                              <h3 class="mb-2">Compte rendu</h3>
                           
                              <div class="page-breadcrumb">
                                  <nav aria-label="breadcrumb">
                                      <ol class="breadcrumb">
                                          <li class="breadcrumb-item"><a href="{{ URL::route('students_index') }}" class="breadcrumb-link">Accueil</a></li>
                                          <li class="breadcrumb-item active" aria-current="page">Compte rendu </li>
                                      </ol>
                                  </nav>
                              </div>
                          </div>
                      </div>
                  </div>
                  <!-- ============================================================== -->
                  <!-- end pageheader  -->
                  <!-- ============================================================== -->


<div class="row">


<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
  <div class="card">
  
  <div class="card-body">



      <div class="table-responsive">
          <table id="example" class="table table-striped table-bordered first">
            <thead>
            <tr class="text-uppercase">
              
              <th style="display: none;">#</th>
              <th>Classe/Matière</th>
              <th>Enseignant</th>
              <th>Date</th>
              <th>détails</th>
            </tr>
            </thead>
            <tbody>

@foreach($compte_rendu as $compte_r)

              <tr>

                  <td style="display: none;">{{ $compte_r->id }}</td>

                  <td>
                    <?php $FindSubject = \App\Subjects::find($compte_r->subject_id); ?>
                    {{ $compte_r->classe->name }} @if($FindSubject !== null ) - {{ $FindSubject->name }} @endif
                  </td>
                  
                  <td>{{ $compte_r->teacher->last_name . ' ' . $compte_r->teacher->first_name }}</td>             


                  <td>{{ $compte_r->date }}</td> 
                
                  <td>

                    <a class="btn btn-primary btn-sm" href="#" data-toggle="modal" data-target="#exampleModal-{{ $compte_r->id }}"><i class="fa fa-eye"></i> détail</a>



      
<!-- Modal -->
<div class="modal fade" id="exampleModal-{{ $compte_r->id }}" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel-{{ $compte_r->id }}" aria-hidden="true">
<div class="modal-dialog modal-lg" role="document">
  <div class="modal-content">
    <div class="modal-header">
      <h5 class="modal-title" id="exampleModalLabel-{{ $compte_r->id }}">Détails</h5>
      <a href="#" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></a>
    </div>
    <div class="modal-body">

      <?php echo html_entity_decode($compte_r->details); ?>
   
    </div>
    <div class="modal-footer">
      <a href="#" class="btn btn-dark" data-dismiss="modal">Fermer</a>
    </div>
  </div>
</div>
</div>
<!-- End Modal -->
                    
                  </td>

              </tr>

@endforeach
                  </tbody>
                  </table>
               </div>

    </div>
  </div>
</div>

                                     


</div><!-- END row -->
                
               

@stop