@extends('layouts.master_panel')

@section('title') Espace Enseignant @stop

@section('CSS') 


<link rel="stylesheet" type="text/css" href="{{url('/')}}/js/datatables/dataTables.bootstrap4.min.css">

@stop

@section('JS') 


<script src="{{url('/')}}/js/datatables/jquery.dataTables.min.js"></script>
<script src="{{url('/')}}/js/datatables/dataTables.bootstrap4.min.js"></script>

<script type="text/javascript" class="init">
  $(document).ready(function() {
    $("#example").dataTable({ "language": { "url": "{{ url('/') }}/js/datatables/lang/fr.json" }
    });
  });
  </script>

<script type="text/javascript">
$(document).ready(function() {
    $('#ressources').modal('show');
});
</script>


@stop


@section('content')



                  <div class="row">
                      <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                          <div class="page-header">
                              <h3 class="mb-2">Statistiques </h3>
                              <div class="page-breadcrumb">
                                  <nav aria-label="breadcrumb">
                                      <ol class="breadcrumb">
                                          <li class="breadcrumb-item"><a href="#" class="breadcrumb-link">Statistiques</a></li>
                                      </ol>
                                  </nav>
                              </div>
                          </div>
                      </div>
                  </div>
  

                  <!-- ============================================================== -->
                      <!-- widgets   -->
                      <!-- ============================================================== -->
                      <div class="row">

<?php 

//$monday = strtotime('last monday', strtotime(date('2021-04-22')));
$monday = strtotime('last monday', strtotime('tomorrow'));
$sunday = strtotime('+5 days', $monday);
//echo "<P>". date('Y-m-d', $monday) . " to " . date('Y-m-d', $sunday) . "</P>";

$from = date('Y-m-d', $monday) . ' 00:00:01';
$to = date('Y-m-d', $sunday) . ' 23:59:59';

$fromFR = \DateTime::createFromFormat('Y-m-d', date('Y-m-d', $monday)); 
$toFR = \DateTime::createFromFormat('Y-m-d', date('Y-m-d', $sunday)); 

$CheckEnseignantsFiles = \App\EnseignantsFiles::where('teacher_id', auth()->user()->id)->whereBetween('created_at', [$from, $to])->get();

//echo count($CheckEnseignantsFiles);
?>

@if(count($CheckEnseignantsFiles) == 0)

<!-- Modal -->
<div class="modal fade" data-keyboard="false" id="ressources" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
<div class="modal-dialog modal-lg" role="document">
  <div class="modal-content">
    <div class="modal-header">
      <h5 class="modal-title" id="exampleModalLabel">Notification</h5>
      <a href="#" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></a>
    </div>
    <div class="modal-body">

<div class="alert alert-warning  alert-dismissible fade show text-center mt-1 mb-1" role="alert" style="font-size: 18px;"> 
    <i class="fas fa-fw fa-bell" style="font-size: 20px;"></i><br>
    Vous n'avez déposé aucune ressource pour la semaine du {{ $fromFR->format('d/m/Y') }} au {{ $toFR->format('d/m/Y') }}
 </div>

    </div>
    <div class="modal-footer">
      <a class="btn btn-block btn-rounded btn-primary btn-lg text-uppercase" href="{{ URL::route('enseignant_documents') }}"><i class="fas fa-check-circle mr-2"></i>Mes dossiers</a>
    </div>
  </div>
</div>
</div>
<!-- End Modal -->

@endif




<?php 
$Avis_notifications = \App\AvisNotifications::where('user_id', auth()->user()->id)->where('user_type', 1)->count(); 
?>

@if($Avis_notifications > 0)
<div class="col-md-12">
  <div class="alert alert-warning alert-dismissible fade show" role="alert">
<a href="{{ URL::route('enseignant_avis_notes') }}" style="color: #856404; font-size: 18px;">
    <i class="fas fa-fw fa-bell"></i> <strong>Notification:</strong> Veuillez consulter la page Avis et Notes.
</a>
    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
      <span aria-hidden="true">&times;</span>
    </button>
  </div>
</div>
@endif




<?php $checkFolders = \App\Folders::where('teacher_id', auth()->user()->id)->where('class_id', null)->get(); ?>


@if(count($checkFolders) > 0)


<div class="col-md-12">
  <div class="alert alert-danger alert-dismissible fade show" role="alert">

    <a href="{{ URL::route('enseignant_documents') }}" style="color: #720e0e; font-size: 18px;">
    <i class="fas fa-fw fa-bell"></i> <strong>Notification: </strong>Veuillez affecter les dossiers @foreach($checkFolders as $checkFolder) (<?php echo html_entity_decode($checkFolder->folder_name); ?>) @endforeach aux classes appropriées.
  </a>
    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
      <span aria-hidden="true">&times;</span>
    </button>
  </div>
</div>


@endif




<?php $demandes_rencontre = \App\DemandesRencontre::where('teacher_id', auth()->user()->id)->where('etat', 1)->where('teacher_readed', 0)->get(); ?>

@if(count($demandes_rencontre) > 0)

@foreach($demandes_rencontre as $demand_rencontre)

<?php $DateTime = \DateTime::createFromFormat('Y-m-d', $demand_rencontre->date); ?>

<div class="col-md-12">
  <div class="alert alert-danger alert-dismissible fade show" role="alert">

    <a href="{{ URL::route('enseignant_demandes_rencontre') }}" style="color: #720e0e; font-size: 18px;">
    <i class="fas fa-fw fa-bell"></i> <strong>Notification: </strong>Prière de préparer les documents nécessaires à la rencontre avec les parents de l'élève<small>(s):</small> @foreach($demand_rencontre->students as $stnd) <span class="badge badge-dark">{{ $stnd->student->last_name . ' ' . $stnd->student->first_name }}</span> @endforeach de la classe de <span class="badge badge-dark">{{ $demand_rencontre->classe->name }}</span> du <span class="badge badge-dark">{{ $DateTime->format('d/m/Y') }} à {{ $demand_rencontre->heure }}</span>.
  </a>
    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
      <span aria-hidden="true">&times;</span>
    </button>
  </div>
</div>

@endforeach

@endif



<?php 
$grille_evaluations = \App\GrilleEvaluation::where('readed', 0)->where('teacher_id', auth()->user()->id)->first();

?>

@if($grille_evaluations !== null)

<div class="col-md-12">
  <div class="alert alert-warning alert-dismissible fade show" style="font-size: 18px;" role="alert">

    <a href="{{ URL::route('enseignant_grille_evaluation') }}" style="color: #856404; font-size: 18px;">
    <i class="fas fa-fw fa-bell"></i> <strong>Notification: </strong> Consulter grille d'évaluation de l'enseignant(e).
  </a>
    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
      <span aria-hidden="true">&times;</span>
    </button>
  </div>
</div>

@endif



<?php 
$Depotdocuments = \App\DepotDocument::where('is_readed', 0)->where('teacher_id', auth()->user()->id)->first();

?>

@if($Depotdocuments !== null)

<div class="col-md-12">
  <div class="alert alert-warning alert-dismissible fade show" style="font-size: 18px;" role="alert">

    <a href="{{ URL::route('enseignant_depot_document') }}" style="color: #856404; font-size: 18px;">
    <i class="fas fa-fw fa-bell"></i> <strong>Notification: </strong> Consulter vos documents.
  </a>
    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
      <span aria-hidden="true">&times;</span>
    </button>
  </div>
</div>

@endif



<?php 
$EmploiNotifications = \App\EmploiNotification::where('readed', 0)->where('user_id', auth()->user()->id)->first();

?>

@if($EmploiNotifications !== null)

<div class="col-md-12">
  <div class="alert alert-warning alert-dismissible fade show" style="font-size: 18px;" role="alert">

    <a href="{{ URL::route('enseignant_emploi') }}" style="color: #856404; font-size: 18px;">
    <i class="fas fa-fw fa-bell"></i> <strong>Notification: </strong> consulter votre nouvel emploi du temps.
  </a>
    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
      <span aria-hidden="true">&times;</span>
    </button>
  </div>
</div>

@endif


<?php 
$HeuresNotification = \App\EnseignantsHeures::where('is_notified', 1)->where('reste', '>', 0)->where('teacher_id', auth()->user()->id)->get(); 

?>

@if(count($HeuresNotification) > 0)

@foreach($HeuresNotification as $HeuresNotif)
<?php  $HouresExplode = explode(".", $HeuresNotif->reste); ?>

<div class="col-md-12">
  <div class="alert alert-warning alert-dismissible fade show" style="font-size: 18px;" role="alert">

    <i class="fas fa-fw fa-bell"></i> <strong>Notification: </strong> Il vous reste {{ $HouresExplode[0] }} heures @if(count($HouresExplode) > 1) et 30 minutes @endif pour compléter vos heures de ({{ $HeuresNotif->classe->name}} -  {{$HeuresNotif->subject->name}})

   
    <a class="close" href="{{ URL::route('enseignants_heures_notif', $HeuresNotif->id) }}"><span aria-hidden="true">&times;</span></a>
  </div>
</div>
@endforeach

@endif



                          <div class="col-xl-3 col-lg-6 col-md-6 col-sm-12 col-12">
                              <div class="card">
                                  <div class="card-body">
                                      <div class="d-inline-block">
                                          <h5 class="text-muted">Devoirs</h5>
                                          <h2 class="mb-0"> {{ count($devoirs) }}</h2>
                                      </div>
                                      <div class="float-right icon-circle-medium  icon-box-lg  bg-primary-light mt-1">
                                          <i class="fas fa-clipboard-list fa-sm text-primary"></i>
                                      </div>
                                  </div>
                              </div>
                          </div>

                          <div class="col-xl-3 col-lg-6 col-md-6 col-sm-12 col-12">
                              <div class="card">
                                  <div class="card-body">
                                      <div class="d-inline-block">
                                          <h5 class="text-muted">Dossiers</h5>
                                          <h2 class="mb-0"> {{ count($folders) }}</h2>
                                      </div>
                                      <div class="float-right icon-circle-medium  icon-box-lg  bg-info-light mt-1">
                                          <i class="fa fa-folder fa-fw fa-sm text-info"></i>
                                      </div>
                                  </div>
                              </div>
                          </div>
 
                          <div class="col-xl-3 col-lg-6 col-md-6 col-sm-12 col-12">
                              <div class="card">
                                  <div class="card-body">
                                      <div class="d-inline-block">
                                          <h5 class="text-muted">Ressources</h5>
                                          <h2 class="mb-0"> {{ count($files) }}</h2>
                                      </div>
                                      <div class="float-right icon-circle-medium  icon-box-lg  bg-info-light mt-1">
                                          <i class="fas fa-file fa-fw fa-sm text-info"></i>
                                      </div>
                                  </div>
                              </div>
                          </div>
 

<?php 
function formatSizeUnits($bytes)
    {
        if ($bytes >= 1073741824)
        {
            $bytes = number_format($bytes / 1073741824, 2) . ' GB';
        }
        elseif ($bytes >= 1048576)
        {
            $bytes = number_format($bytes / 1048576, 2) . ' MB';
        }
        elseif ($bytes >= 1024)
        {
            $bytes = number_format($bytes / 1024, 2) . ' KB';
        }
        elseif ($bytes > 1)
        {
            $bytes = $bytes . ' bytes';
        }
        elseif ($bytes == 1)
        {
            $bytes = $bytes . ' byte';
        }
        else
        {
            $bytes = '0 bytes';
        }

        return $bytes;
}

$total_size = 0;
foreach($files as $fil) {
  $total_size = $total_size + $fil->file_size;
}

 ?>

                          <div class="col-xl-3 col-lg-6 col-md-6 col-sm-12 col-12">
                              <div class="card">
                                  <div class="card-body">
                                      <div class="d-inline-block">
                                          <h5 class="text-muted">Taille</h5>
                                          <h2 class="mb-0">{{ formatSizeUnits($total_size) }}</h2>
                                      </div>
                                      <div class="float-right icon-circle-medium  icon-box-lg  bg-info-light mt-1">
                                          <i class="fa fa-database fa-fw fa-sm text-info"></i>
                                      </div>
                                  </div>
                              </div>
                          </div>
                          

<?php /* ?>                          
                          <!-- ============================================================== -->
                          <!-- total earned   -->
                          <!-- ============================================================== -->
                          <div class="col-xl-3 col-lg-6 col-md-6 col-sm-12 col-12">
                              <div class="card">
                                  <div class="card-body">
                                      <div class="d-inline-block">
                                          <h5 class="text-muted">Total Earned</h5>
                                          <h2 class="mb-0"> $149.00</h2>
                                      </div>
                                      <div class="float-right icon-circle-medium  icon-box-lg  bg-brand-light mt-1">
                                          <i class="fa fa-money-bill-alt fa-fw fa-sm text-brand"></i>
                                      </div>
                                  </div>
                              </div>
                          </div>
                          <!-- ============================================================== -->
                          <!-- end total earned   -->
                          <!-- ============================================================== -->
<?php */ ?>                          
                      </div>
                      <!-- ============================================================== -->
                      <!-- end widgets   -->
                      <!-- ============================================================== -->


                      <div class="row">

                     
                      </div>
                    

@stop