@extends('layouts.master_panel')

@section('title') Compte rendu @stop

@section('CSS') 


<link rel="stylesheet" type="text/css" href="{{url('/')}}/js/datatables/dataTables.bootstrap4.min.css">

<link rel="stylesheet" href="{{url('/')}}/assets/vendor/datepicker/tempusdominus-bootstrap-4.css" />

<link rel="stylesheet" href="{{url('/')}}/assets/vendor/summernote/css/summernote-bs4.css">

@stop

@section('JS') 


<script src="{{url('/')}}/js/datatables/jquery.dataTables.min.js"></script>
<script src="{{url('/')}}/js/datatables/dataTables.bootstrap4.min.js"></script>

<script type="text/javascript" class="init">
  $(document).ready(function() {
    $("#example").dataTable({ "language": { "url": "{{ url('/') }}/js/datatables/lang/fr.json" },
      "order": [[ 0, "desc" ]]
    });
  });
  </script>


<script src="{{url('/')}}/assets/vendor/datepicker/moment.js"></script>
<script src="{{url('/')}}/assets/vendor/datepicker/tempusdominus-bootstrap-4.js"></script>
<script src="{{url('/')}}/assets/vendor/datepicker/datepicker.js"></script>

<script src="{{url('/')}}/assets/vendor/datepicker/fr.js"></script>

<script type="text/javascript">
    $(function () {
        $('#datetimepickerdate').datetimepicker({
          format: 'DD/M/YYYY',
          locale: 'fr'
      });
    });

</script>


<script src="{{url('/')}}/assets/vendor/summernote/js/summernote-bs4.js"></script>

<script>
    $(document).ready(function() {
        $('#summernote').summernote({
            height: 150

        });
    });
</script>


<script type="text/javascript">
$(document).ready(function () { 

            $('#subjectID').on('change',function(e){
            var subject_id = e.target.value;

            $.ajax({
            type: "GET",
            url: "{{ url('/') }}/enseignant/ajax_subject_class?subject_id="+subject_id,
                success: function(data) {  

                    var class_id = $("#classID").val(data);

                    $.ajax({
                    type: "GET",
                    url: "{{ url('/') }}/enseignant/ajax_students_class?class_id="+data,
                        success: function(data) {  

                            var subcat =  $('#studentsID').empty();

                            $.each(data, function(key, val) { 
                            //  console.log(val.last_name); 
                            subcat.append('<option value ="'+val.id+'">'+val.last_name+' '+val.first_name+'</option>');

                            });

                            $('.selectpicker').selectpicker('refresh');

                        }

                    });


                }

            });

            


        });
});
</script>


@stop


@section('content')


                  <!-- ============================================================== -->
                  <!-- pageheader  -->
                  <!-- ============================================================== -->
                  <div class="row">
                      <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                          <div class="page-header">
                              <h3 class="mb-2">Compte rendu  </h3>
                           
                              <div class="page-breadcrumb">
                                  <nav aria-label="breadcrumb">
                                      <ol class="breadcrumb">
                                          <li class="breadcrumb-item"><a href="{{ URL::route('enseignant_index') }}" class="breadcrumb-link">Accueil</a></li>
                                          <li class="breadcrumb-item active" aria-current="page">Compte rendu  </li>
                                      </ol>
                                  </nav>
                              </div>
                          </div>
                      </div>
                  </div>
                  <!-- ============================================================== -->
                  <!-- end pageheader  -->
                  <!-- ============================================================== -->


<div class="row">


<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
  <div class="card">
@if(!isset($_GET['id']))
  @if(auth()->user()->is_teacher == 1)
    <h5 class="card-header">
      <a href="#" class="btn btn-primary mb-1" data-toggle="modal" data-target="#exampleModal"><i class="fa fa-plus"></i> Ajouter </a>
    </h5>
  @endif
@endif    
  <div class="card-body">


@if(isset($_GET['id']))

<?php $getCompteRendu = \App\CompteRendu::find(e($_GET['id'])); ?>

@if($getCompteRendu !== null AND $getCompteRendu->teacher_id == auth()->user()->id)

<style type="text/css">
  .table-responsive { display: none; }
</style>

<form method="POST" action="{{ URL::route('compte_rendu_update', $getCompteRendu->id) }}" >

{{ csrf_field() }}


<div class="form-row">


  <div class="col-md-12 mb-3">
      <label>Élèves</label>
      <select name="student_id" class="selectpicker" data-width="100%" required="required" >   
        <option selected="selected" value="{{ $getCompteRendu->student->id }}">{{ $getCompteRendu->student->last_name . ' ' . $getCompteRendu->student->first_name }}</option>
      </select>
  </div>


  <div class="col-md-12 mb-3">
    <label>Date:</label>
    <div class="form-group">
    <div class="input-group date" id="datetimepickerdate" data-target-input="nearest">

    <input name="date" type="text" class="form-control datetimepicker-input" data-target="#datetimepickerdate" required="required" value="{{ $getCompteRendu->date }}" />
    
      <div class="input-group-append" data-target="#datetimepickerdate" data-toggle="datetimepicker">
      <div class="input-group-text"><i class="far fa-calendar-alt"></i></div>
      </div>
    </div>
  </div>
  </div>



  <div class="col-md-12 mb-3">
    <label>Détails:</label>
    <textarea name="details" id="summernote" class="form-control" required="required"><?php echo html_entity_decode($getCompteRendu->details); ?></textarea>
  </div>



 
</div>

<div class="form-row">
<div class="col-md-12">
    <button class="btn btn-success btn-block" type="submit">Modifier</button>
</div>
</div>

</form>

@endif

<div class="clearfix"></div><hr>


@else


@if(auth()->user()->is_teacher == 1)

<!-- Modal -->
<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
<div class="modal-dialog modal-lg" role="document">
  <div class="modal-content">
    <div class="modal-header">
      <h5 class="modal-title" id="exampleModalLabel">Compte rendu</h5>
      <a href="#" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></a>
    </div>
    <div class="modal-body">

<form method="POST" action="{{ URL::route('enseignant_compte_rendu_store') }}">

{{ csrf_field() }}


<div class="form-row">

  <div class="col-md-6 mb-3">
      <label>Matières / Classes</label>
      <select name="subject_id" id="subjectID" class="selectpicker" data-width="100%" required="required">   
        
      <option value="">Choisir</option>
        @foreach($subjects as $subject)

          <?php $getclass = \App\Classes::find($subject->class_id); ?>

          <option value="{{ $subject->id }}">{{ $subject->name }} ({{ $getclass->name }})</option>

        @endforeach
      </select>

      <input type="hidden" name="class_id" id="classID" value="">

  </div>

  <div class="col-md-6 mb-3">
      <label>Élèves</label>
      <select name="student_id" id="studentsID" class="selectpicker" data-width="100%" required="required" title="Choisir">   
      </select>
  </div>


  <div class="col-md-12 mb-3">
    <label>Date:</label>
    <div class="form-group">
    <div class="input-group date" id="datetimepickerdate" data-target-input="nearest">

    <input name="date" type="text" class="form-control datetimepicker-input" data-target="#datetimepickerdate" required="required" value="{{ old('date') }}" />
    
      <div class="input-group-append" data-target="#datetimepickerdate" data-toggle="datetimepicker">
      <div class="input-group-text"><i class="far fa-calendar-alt"></i></div>
      </div>
    </div>
  </div>
  </div>




  <div class="col-md-12 mb-3">
    <label>Détails:</label>
    <textarea name="details" id="summernote" class="form-control" required="required">{{ old('details') }}</textarea>
  </div>




 
</div>

<div class="form-row mt-1">
<div class="col-md-12">
    <button class="btn btn-success btn-block" type="submit">Valider</button>
</div>
</div>

</form>

    </div>
    <div class="modal-footer">
      <a href="#" class="btn btn-dark" data-dismiss="modal">Fermer</a>
    </div>
  </div>
</div>
</div>
<!-- End Modal -->

@endif

@endif

<div class="clearfix"></div>

@if(Session::has('error'))

<div class="alert alert-danger alert-dismissible fade show text-center" role="alert">
  <strong>{{ Session::get('error') }}</strong>
  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
    <span aria-hidden="true">&times;</span>
  </button>
</div>

@endif

@if(Session::has('success'))
<div class="alert alert-success alert-dismissible fade show text-center" role="alert">
  <strong>{{ Session::get('success') }}</strong>
  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
    <span aria-hidden="true">&times;</span>
  </button>
</div>
@endif

<div class="clearfix"></div>

      <div class="table-responsive">
          <table id="example" class="table table-striped table-bordered first">
            <thead>
            <tr class="text-uppercase">
              <th style="display: none;"></th>
              <th>Élève</th>
              @if(auth()->user()->is_admin == 1)
                <th>Enseignant</th> 
              @endif
              <th>Classe/Matière</th>
              <th>Date</th>
              <th>détails</th>
              <th>Action</th>
            </tr>
            </thead>
            <tbody>

             @foreach($compte_rendu as $compte_r)
                <tr>

                  <td style="display: none;">{{ $compte_r->id }}</td>

                  <td>{{ $compte_r->student->last_name . ' ' . $compte_r->student->first_name }}</td>

                  @if(auth()->user()->is_admin == 1)
                    <td>{{ $compte_r->teacher->last_name . ' ' . $compte_r->teacher->first_name }}</td> 
                  @endif

                  <td>
                    <?php $FindSubject = \App\Subjects::find($compte_r->subject_id); ?>
                    {{ $compte_r->classe->name }} @if($FindSubject !== null ) - {{ $FindSubject->name }} @endif
                  </td>

                  <td>{{ $compte_r->date }}</td>
                  
                  <td>

                    <a class="btn btn-primary btn-sm" href="#" data-toggle="modal" data-target="#exampleModal-{{ $compte_r->id }}"><i class="fa fa-eye"></i> détail</a>



      
<!-- Modal -->
<div class="modal fade" id="exampleModal-{{ $compte_r->id }}" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel-{{ $compte_r->id }}" aria-hidden="true">
<div class="modal-dialog modal-lg" role="document">
  <div class="modal-content">
    <div class="modal-header">
      <h5 class="modal-title" id="exampleModalLabel-{{ $compte_r->id }}">Détails</h5>
      <a href="#" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></a>
    </div>
    <div class="modal-body">

      <?php echo html_entity_decode($compte_r->details); ?>
   
    </div>
    <div class="modal-footer">
      <a href="#" class="btn btn-dark" data-dismiss="modal">Fermer</a>
    </div>
  </div>
</div>
</div>
<!-- End Modal -->
                    
                  </td>

                      <td>
                    @if(auth()->user()->is_teacher == 1)
                        <a href="{{ URL::current() . '?id=' . $compte_r->id }}" class="btn btn-success btn-sm"><i class="fa fa-edit"></i>  </a>
                    @endif

                    @if(auth()->user()->super_admin == 1)
                        <a onclick="return confirm('Supprimer?')" href="{{ URL::route('compte_rendu_delete', $compte_r->id) }}" class="btn btn-danger btn-sm"><i class="fa fa-trash"></i>  </a>
                    @endif
                      </td>

                    </tr>

                    @endforeach
                  </tbody>
                  </table>
               </div>

    </div>
  </div>
</div>

                                     


</div><!-- END row -->
                
               

@stop