<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml"><head>
<meta charset="utf-8">
<title>Historique</title>

<style type="text/css">
       
        body {
            background-color: #FFFFFF;
            margin:0;
            padding: 6mm;
        }

        table#details {
            clear: both;
            border-collapse: collapse;
            width: 100%;
        }

        table#details, table#details th, table#details td {
           border: 1px solid black;
        }

        table#details td {
            text-align: center;
        }

        @media print {

           @page {
                size: a4;   /* auto is the initial value */
                margin: 3mm;  /* this affects the margin in the printer settings */
            }



          .table-border thead tr th, .table-border thead tr td, .table-border tbody tr td{
              border-width: 1px !important;
              border-style: solid !important;
              border-color: #000 !important;
           }

           .print { display: none; }


        }

        .table-border thead tr th, .table-border tbody tr td {
            padding: 8px !important;
         }

.btn {
    font-size: 14px;
    padding: 9px 16px;
    border-radius: 2px;
    cursor: pointer;
}

.btn-wishlist {
    background-color: #efeff6;
    border-radius: 100px;
    height: 30px;
    width: 30px;
    padding: 5px 3px;
    display: inline-block;
    font-size: 14px;
    color: #3d405c;
    text-align: center;
    line-height: 1.7;
}

.btn-wishlist:hover {
    background-color: #ff407b;
    color: #fff;
}


/*--- btn default --*/

.btn-brand {
    color: #2e2f39;
    background-color: #ffc750;
    border-color: #ffc750;
}

.btn-brand:hover {
    color: #2e2f39;
    background-color: #efb63e;
    border-color: #efb63e;
}

.btn-brand.focus,
.btn-brand:focus {
    color: #2e2f39;
    background-color: #efb63e;
    border-color: #efb63e;
    box-shadow: none;
}


/*--- btn primary --*/

.btn-primary {
    color: #fff;
    background-color: #5969ff;
    border-color: #5969ff;
}

.btn-primary:hover {
    color: #fff;
    background-color: #4656e9;
    border-color: #4656e9;
}

.btn-primary.focus,
.btn-primary:focus {
    color: #fff;
    background-color: #4656e9;
    border-color: #4656e9;
    box-shadow: 0 0 0 1px rgb(37, 52, 158);
}

.btn-primary:not(:disabled):not(.disabled).active:focus,
.btn-primary:not(:disabled):not(.disabled):active:focus,
.show>.btn-primary.dropdown-toggle:focus {
    box-shadow: 0 0 0 0.2rem rgb(37, 52, 158);
}

.btn-primary:not(:disabled):not(.disabled).active,
.btn-primary:not(:disabled):not(.disabled):active,
.show>.btn-primary.dropdown-toggle {
    color: #fff;
    background-color: #4656e9;
    border-color: #4656e9;
}



</style>


</head><body onload=" // window.print(); ">

<button class="print btn btn-primary" onclick="window.print();" style="">Imprimer</button>

<h3 style="text-align: center; text-transform: uppercase;">Historique pointage: (période du {{ $from_fr }} au {{ $to_fr }}) :</h3>


<section>
<table width="100%" id="details" class="table-border">
    <thead>
        <tr>
            <th>#</th>
            <th>Nom et Prénom</th>
            <th>Type</th>
            <th>Pointage</th>
            <th>Retard</th> 
        </tr>
    </thead>

    <tbody>


@foreach($historique as $histor)

      <tr>
              

@if(!empty($histor->student_id))
<td>  <span class="badge badge-info"><i class="fa fa-user"></i> Elève</span> </td>
<td> {{ $histor->student->last_name . ' ' . $histor->student->first_name }} </td>
@endif

@if(!empty($histor->personnel_id))
<td>  <span class="badge badge-info"><i class="fa fa-user"></i> Personnel</span> </td>
<td>  {{ $histor->personnel->last_name . ' ' . $histor->personnel->first_name }} </td>
@endif

@if(!empty($histor->teacher_id))
<td>  <span class="badge badge-info"><i class="fa fa-user"></i> Enseignant</span> </td>
<td>  {{ $histor->teacher->last_name . ' ' . $histor->teacher->first_name }} </td>
@endif

          
            <td>
                @if($histor->type == 1) Entrée @else Sortie @endif
            </td>

            <td>
              <?php $enTofr = DateTime::createFromFormat('Y-m-d H:i', substr($histor->created_at, 0, 16)); ?>

              {{ $enTofr->format('d/m/Y H:i') }}
            </td>

            <td>
                @if($histor->late_minutes > 0)
                    {{ $histor->late_minutes }} Minutes
                @else - @endif
            </td>

            

        </tr>

@endforeach 


    </tbody>

</table>
</section>




</body></html>