<?php

namespace App\Imports;

use Hash;

use App\User;
use App\HorairesTravail;
use App\Settings;

use App\Horaires;

use Maatwebsite\Excel\Concerns\ToModel;

use Maatwebsite\Excel\Concerns\WithStartRow;

// use Maatwebsite\Excel\Concerns\WithMultipleSheets;


class HorairesImport implements ToModel, WithStartRow 
{
    

    public function startRow(): int
    {
        return 2;
    }


    /**
    * @param array $row
    *
    * @return \Illuminate\Database\Eloquent\Model|null
    */
    public function model(array $row)
    {   
        

$days_en = ['Monday','Tuesday','Wednesday','Thursday','Friday','Saturday','Sunday'];
$days_fr = ['lundi','mardi','mercredi','jeudi','vendredi','samedi','dimanche'];


        if(!empty($row[0]) AND !empty($row[2]) AND !empty($row[3])) {

                $input = request()->all();

                $settings = Settings::first();

                $GetUser = User::where('barcode', e($row[0]))->first();

                if ($GetUser !== null) {

                    // 24-hour
                    if (preg_match("/^(?:2[0-3]|[01][0-9]):[0-5][0-9]$/", $row[3]) AND preg_match("/^(?:2[0-3]|[01][0-9]):[0-5][0-9]$/", $row[4])) {
                    
                        $day_key = array_search($row[2], $days_fr);  

                        return new HorairesTravail([

                            'teacher_id'     => $GetUser->id,

                            'day_id'     => $days_en[$day_key],

                            'entry_time'    => $row[3],

                            'exit_time'    => $row[4], 

                            'year_id'    => $settings->default_year,

                        ]);

                    }

                }


        }
        
    } 
}
