@extends('layouts.master_panel')

@section('title') Espace Élèves @stop

@section('CSS') 


@stop

@section('JS') 

<script type="text/javascript">
$(document).ready(function() {
    $('#OrientationStudents').modal('show');
});
</script>

@stop


@section('content')


<!-- ============================================================== -->
                  <!-- pageheader  -->
                  <!-- ============================================================== -->
                  <div class="row">
                      <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                          <div class="page-header">
                              <h3 class="mb-2">Statistiques </h3>
                              <div class="page-breadcrumb">
                                  <nav aria-label="breadcrumb">
                                      <ol class="breadcrumb">
                                          <li class="breadcrumb-item"><a href="#" class="breadcrumb-link">Statistiques</a></li>
                                          
                                      </ol>
                                  </nav>
                              </div>
                          </div>
                      </div>
                  </div>
                  <!-- ============================================================== -->
                  <!-- end pageheader  -->
                  <!-- ============================================================== -->


                  <!-- ============================================================== -->
                      <!-- widgets   -->
                      <!-- ============================================================== -->
                      <div class="row">
<div class="col-md-12 mb-3">
@if(Session::has('success'))
<div class="alert alert-success alert-dismissible fade show text-center" role="alert">
  <strong>{{ Session::get('success') }}</strong>
  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
    <span aria-hidden="true">&times;</span>
  </button>
</div>
@endif
</div>


@if($OrientationNotif == true)
<!-- Modal -->
<div class="modal fade" id="OrientationStudents" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
<div class="modal-dialog modal-lg" role="document">
  <div class="modal-content">
    <div class="modal-header">
      <h5 class="modal-title" id="exampleModalLabel">Orientation</h5>
      <a href="#" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></a>
    </div>
    <div class="modal-body">

<?php $getuserClasse = \App\Classes::find(auth()->user()->class_id); ?>

    <h2 class="text-center" dir="rtl">التوجيه الأولي لتلاميذ : {{ $getuserClasse->name }}</h2>

    <h3 class="text-danger text-center">تنبيه  عام  :    يعتبر هذا  الاختيار أوليا   في عملية التوجيه  -    و لا يعد نهائيا  إلا بعد   تحقيق   شروط  التوجيه لكل شعبة</h3>
<div class="clearfix"></div><hr>
<form method="POST" action="{{ URL::route('student_store_orientation') }}">

{{ csrf_field() }}

<div class="form-row">

<div class="col-md-4 mb-2">
    <div class="form-group">
    <label>Nom:</label>
    <input name="last_name" type="text" class="form-control input-lg" value="{{ auth()->user()->last_name }}" readonly="readonly">
    </div>
</div>

<div class="col-md-4 mb-2">
    <div class="form-group">
    <label>Prénom:</label>
    <input name="first_name" type="text" class="form-control input-lg" value="{{ auth()->user()->first_name }}" readonly="readonly">
    </div>
</div>

<div class="col-md-4 mb-2">
    <div class="form-group">
    <label>Classe:</label>
    <input name="first_name" type="text" class="form-control input-lg" value="{{ $getuserClasse->name }}" readonly="readonly">
    </div>
</div>

@if($ListOrientations !== null) 
  <div class="col-md-12 mb-3">
      <label>اختر الشعبة :</label>
      <select name="orientation" class="selectpicker" data-width="100%" title="اختر الشعبة " required="required"> 
        <?php $pieces = explode(",", $ListOrientations->orientations); ?>  
        @foreach($pieces as $piec)
          @if($piec !== '') 
            <option value="{{ $piec }}">{{ $piec }}</option>
          @endif
        @endforeach
      </select>
  </div>
  <input type="hidden" name="orient_id" value="{{ $ListOrientations->id }}">
@endif

</div>

<div class="form-row mt-3">
<div class="col-md-8">
    <button class="btn btn-success btn-block" type="submit"><i class="fas fa-check-circle mr-2"></i>تأكيد</button>
</div>
<div class="col-md-4">
  <a href="#" class="btn btn-dark btn-block" data-dismiss="modal">إلغاء</a>
</div>
</div>

</form>



    </div>
    <div class="modal-footer">
      
    </div>
  </div>
</div>
</div>
<!-- End Modal -->
@endif




<?php 
$Avis_notifications = \App\AvisNotifications::where('user_id', auth()->user()->id)->where('user_type', 2)->count(); 
?>

@if($Avis_notifications > 0)
<div class="col-md-12">
  <div class="alert alert-warning alert-dismissible fade show" role="alert">
<a href="{{ URL::route('eleve_avis_notes') }}" style="color: #856404; font-size: 18px;">
    <i class="fas fa-fw fa-bell"></i> <strong>Notification:</strong> Veuillez consulter la page Avis et Notes.
</a>
    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
      <span aria-hidden="true">&times;</span>
    </button>
  </div>
</div>
@endif




<?php 
$simili_evaluations = \App\SimiliEvaluations::where('s_readed', 0)->where('student_id', auth()->user()->id)->get(); 

?>

@if(count($simili_evaluations) > 0)
<div class="col-md-12">
  <div class="alert alert-warning alert-dismissible fade show" role="alert">
<a href="{{ URL::route('student_evaluations_simili') }}" style="color: #856404; font-size: 18px;">
    <i class="fas fa-fw fa-bell"></i> <strong>Notification:</strong> consulter vos évaluations (Simili).
</a>
    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
      <span aria-hidden="true">&times;</span>
    </button>
  </div>
</div>
@endif



<?php 
$EmploiNotifications = \App\EmploiNotification::where('readed', 0)->where('user_id', auth()->user()->id)->first();

?>

@if($EmploiNotifications !== null)

<div class="col-md-12">
  <div class="alert alert-warning alert-dismissible fade show" style="font-size: 18px;" role="alert">

    <a href="{{ URL::route('students_emploi') }}" style="color: #856404; font-size: 18px;">
    <i class="fas fa-fw fa-bell"></i> <strong>Notification: </strong> consulter votre nouvel emploi du temps.
  </a>
    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
      <span aria-hidden="true">&times;</span>
    </button>
  </div>
</div>

@endif


<?php 
$checkDevoirsNotification = \App\DevoirsNotification::where('readed', 0)->where('is_preparation', 0)->where('student_id', auth()->user()->id)->get(); 

$checkDevoirsNotification2 = \App\DevoirsNotification::where('readed', 0)->where('is_preparation', 1)->where('student_id', auth()->user()->id)->get(); 

$checkRessourcesNotification = \App\RessourcesNotification::where('readed', 0)->where('student_id', auth()->user()->id)->get(); 

?>

@if(count($checkDevoirsNotification) > 0)
<div class="col-md-12">
  <div class="alert alert-warning alert-dismissible fade show" role="alert">
<a href="{{ URL::route('travaux_afaire') }}" style="color: #856404; font-size: 18px;">
    <i class="fas fa-fw fa-bell"></i> <strong>Notification:</strong> Vérifiez vos devoirs de la semaine.
</a>
    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
      <span aria-hidden="true">&times;</span>
    </button>
  </div>
</div>
@endif

@if(count($checkDevoirsNotification2) > 0)
<div class="col-md-12">
  <div class="alert alert-warning alert-dismissible fade show" role="alert">
<a href="{{ URL::route('students_preparation_exam') }}" style="color: #856404; font-size: 18px;">
@if(count($checkDevoirsNotification2) > 1)
    <i class="fas fa-fw fa-bell"></i> <strong>Notification:</strong> vous avez {{ count($checkDevoirsNotification2) }} nouvelles préparations d'examen
@else
    <i class="fas fa-fw fa-bell"></i> <strong>Notification:</strong> vous avez {{ count($checkDevoirsNotification2) }} nouvelle préparation d'examen
@endif
</a>
    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
      <span aria-hidden="true">&times;</span>
    </button>
  </div>
</div>
@endif

@if(count($checkRessourcesNotification) > 0)

<?php 
$arrFloders = array();
foreach($checkRessourcesNotification as $rnot) {
  $CheckFolder = \App\Folders::find($rnot->folder_id); 
  if ($CheckFolder !== null) { 
    $arrFloders[$CheckFolder->id] = $CheckFolder->folder_name;
  }
}

 ?>
<div class="col-md-12">
  <div class="alert alert-warning alert-dismissible fade show" role="alert">
<a href="{{ URL::route('students_dossiers') }}" style="color: #856404; font-size: 18px;">

    <i class="fas fa-fw fa-bell"></i> <strong>Notifications!</strong> vous avez {{ count($checkRessourcesNotification) }} nouvelles ressources dans @foreach($arrFloders as $arrFloder) ({{ html_entity_decode($arrFloder) }}) @endforeach 

</a>
    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
      <span aria-hidden="true">&times;</span>
    </button>
  </div>
</div>
@endif



                          
                          <div class="col-xl-4 col-lg-6 col-md-6 col-sm-12 col-12"> 
                              <div class="card"> 
                                  <div class="card-body">
                                      <div class="d-inline-block">
                                          <h5 class="text-muted">Devoirs</h5>
                                          <h2 class="mb-0"> {{ count($devoirs) }}</h2>
                                      </div>
                                      <div class="float-right icon-circle-medium  icon-box-lg  bg-primary-light mt-1">
                                          <i class="fas fa-clipboard-list fa-sm text-primary"></i>
                                      </div>
                                  </div>
                              </div>
                          </div>

                          <div class="col-xl-4 col-lg-6 col-md-6 col-sm-12 col-12">
                              <div class="card">
                                  <div class="card-body">
                                      <div class="d-inline-block">
                                          <h5 class="text-muted">Évaluations</h5>
                                          <h2 class="mb-0"> {{ count($evaluations) + count($controle_evaluations) }}</h2>
                                      </div>
                                      <div class="float-right icon-circle-medium  icon-box-lg  bg-info-light mt-1">
                                          <i class="fa fa-list fa-fw fa-sm text-info"></i>
                                      </div>
                                  </div>
                              </div>
                          </div>


                          <div class="col-xl-4 col-lg-6 col-md-6 col-sm-12 col-12">
                              <div class="card">
                                  <div class="card-body">
                                      <div class="d-inline-block">
                                          <h5 class="text-muted">Assiduité</h5>
                                          <h2 class="mb-0"> {{ count($assiduite) }}</h2>
                                      </div>
                                      <div class="float-right icon-circle-medium  icon-box-lg  bg-danger-light mt-1">
                                          <i class="fa fa-info-circle fa-fw fa-sm text-danger"></i>
                                      </div>
                                  </div>
                              </div>
                          </div>
 
                          
                          
           
                      </div>
                      <!-- ============================================================== -->
                      <!-- end widgets   -->
                      <!-- ============================================================== -->


                      <div class="row">

                     
                      </div>
                    

@stop