@extends('layouts.master_panel')

@section('title') Assiduité @stop

@section('CSS') 


<link rel="stylesheet" type="text/css" href="{{url('/')}}/js/datatables/dataTables.bootstrap4.min.css">

<link rel="stylesheet" href="{{url('/')}}/assets/vendor/datepicker/tempusdominus-bootstrap-4.css" />


@stop

@section('JS') 


<script src="{{url('/')}}/js/datatables/jquery.dataTables.min.js"></script>
<script src="{{url('/')}}/js/datatables/dataTables.bootstrap4.min.js"></script>

<script type="text/javascript" class="init">
  $(document).ready(function() {
    $("#example").dataTable({ "language": { "url": "{{ url('/') }}/js/datatables/lang/fr.json" },
      "order": [[ 0, "desc" ]]
    });
  });
  </script>



@stop


@section('content')


                  <!-- ============================================================== -->
                  <!-- pageheader  -->
                  <!-- ============================================================== -->
                  <div class="row">
                      <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                          <div class="page-header">
                              <h3 class="mb-2">Assiduité</h3>
                           
                              <div class="page-breadcrumb">
                                  <nav aria-label="breadcrumb">
                                      <ol class="breadcrumb">
                                          <li class="breadcrumb-item"><a href="{{ URL::route('students_index') }}" class="breadcrumb-link">Accueil</a></li>
                                          <li class="breadcrumb-item active" aria-current="page">Assiduité </li>
                                      </ol>
                                  </nav>
                              </div>
                          </div>
                      </div>
                  </div>
                  <!-- ============================================================== -->
                  <!-- end pageheader  -->
                  <!-- ============================================================== -->


<div class="row">


<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
  <div class="card">
  
  <div class="card-body">



      <div class="table-responsive">
          <table id="example" class="table table-striped table-bordered first">
            <thead>
            <tr class="text-uppercase">
              
              <th style="display: none;">#</th>
              <th style="width: 50%">Motif</th>
              <th>Classe/Matière</th>
              <th>Date/Heure</th>
              <th>Enseignant</th>
            </tr>
            </thead>
            <tbody>

@foreach($assiduite as $assidu)

              <tr>

                  <td style="display: none;">{{ $assidu->id }}</td>

                  <td>{{ htmlspecialchars_decode($assidu->motif) }}</td>
                                  
                  <td>
                    <?php $FindSubject = \App\Subjects::find($assidu->subject_id); ?>
                    {{ $assidu->classe->name }} @if($FindSubject !== null ) - {{ $FindSubject->name }} @endif
                  </td>

                  <td>{{ $assidu->date }} à {{ $assidu->hour }}</td> 
                
                  <td>{{ $assidu->teacher->last_name . ' ' . $assidu->teacher->first_name }}</td>

              </tr>

@endforeach
                  </tbody>
                  </table>
               </div>

    </div>
  </div>
</div>

                                     


</div><!-- END row -->
                
               

@stop