<!doctype html>
<html lang="fr">
 
<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="csrf-token" content="{{ csrf_token() }}" />
    <title>Devoirs</title>
    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="{{url('/')}}/assets/vendor/bootstrap/css/bootstrap.min.css">
    <link href="{{url('/')}}/assets/vendor/fonts/circular-std/style.css" rel="stylesheet">
    <link rel="stylesheet" href="{{url('/')}}/assets/libs/css/style.css">
    <link rel="stylesheet" href="{{url('/')}}/assets/vendor/fonts/fontawesome/css/fontawesome-all.css">
    <style>
    
    </style>
</head>

<body>
    



@if(!empty(auth()->user()->class_id))

<?php $getClasse = \App\Classes::find(auth()->user()->class_id); ?>

@if($getClasse !== null)


 <div class="container mt-5">
        <div class="card">
            <div class="card-header text-center"><a href="https://verdin.ma"><img class="logo-img img-fluid" width="250px" src="{{url('/')}}/assets/images/logo4.png" alt="Groupe Scolaire Verdin"></a></div>
            <div class="card-body row">

            <div class="col-md-6">
                <h4>Vous êtes connecté en tant que: <strong>{{ auth()->user()->last_name . ' ' . auth()->user()->first_name }}</strong> | Classe: <strong>{{ $getClasse->name }}</strong> </h4>
            </div>

            <div class="col-md-6">
                <a class="btn btn-danger btn-sm float-right" href="{{ URL::route('logout') }}"><i class="fas fa-power-off"></i> Se déconnecter</a>
            </div>

            </div>
           
        </div>
</div>



<?php $devoirs = \App\Devoirs::where('class_id', $getClasse->id)->where('year_id', $settings->default_year)->orderBy('id', 'desc')->get(); ?>

<div class="clearfix"></div>

<div class="container">

@if(count($devoirs) < 1)

<div class="card">
<div class="card-body text-center">

<h1 class="display-3"><i class="fas fa-info-circle"></i></h1>
<h3 class="display-3" style="font-size: 26px;">Pas de devoirs.</h3>

</div>
</div>

@endif
  

@foreach($devoirs as $devoir)


<div class="card">
<div class="card-header d-flex"> {{ $devoir->title }} </div>
<div class="card-body">

  <h4>
    <span class="badge badge-primary mr-2 mb-1"> <i class="fas fa-book"></i> {{ $devoir->subject->name }} </span>

    <span class="badge badge-light mr-2 mb-1"> <i class="fas fa-user"></i> {{ $devoir->teacher->last_name . ' ' . $devoir->teacher->first_name }} </span>

  </h4>

  

  <div class="row">

    <div class="col-md-12 mb-3 text-danger">
      <h2><label>Travail à faire pour le:</label> <span class="badge badge-warning text-white">{{ $devoir->date }}</span></h2>
    </div>

    <div class="clearfix"></div>
    

    <div class="col-md-12 mb-3">
      <?php echo html_entity_decode($devoir->details); ?>
    </div>

    <div class="col-md-12 mb-3">
      @if(!empty($devoir->file_join))

        <div class="alert alert-warning alert-dismissible fade show" role="alert">
            <a target="_black" href="{{ url('/') }}/uploads/devoirs/{{ $devoir->file_join }}">
                <i class="fa fa-download"></i> Téléchargez le fichier joint
            </a>
        </div>

      @endif
    </div>

  </div>


</div>
</div>
  


@endforeach

<?php /* ?>
    <div class="clearfix"></div>
    <div class="col-md-12">
         {{ $devoirs->links() }}
    </div>
<?php */ ?>

  
</div>


@endif
@endif


    <script src="{{url('/')}}/assets/vendor/jquery/jquery-3.3.1.min.js"></script>
    <script src="{{url('/')}}/assets/vendor/bootstrap/js/bootstrap.bundle.js"></script>
<?php /* ?>
<script type="text/javascript">
$(document).ready(function () { 
    $(".pagination").addClass('pagination-lg');
});
</script>
<?php */ ?>
</body>
 
</html>