@extends('layouts.master_panel')

@section('title') Grille d'évaluation de l'enseignant @stop

@section('CSS') 


<link rel="stylesheet" type="text/css" href="{{url('/')}}/js/datatables/dataTables.bootstrap4.min.css">

<link rel="stylesheet" href="{{url('/')}}/assets/vendor/datepicker/tempusdominus-bootstrap-4.css" />

<link rel="stylesheet" href="{{url('/')}}/assets/vendor/summernote/css/summernote-bs4.css">

@stop

@section('JS') 


<script src="{{url('/')}}/js/datatables/jquery.dataTables.min.js"></script>
<script src="{{url('/')}}/js/datatables/dataTables.bootstrap4.min.js"></script>

<script type="text/javascript" class="init">
  $(document).ready(function() {
    $("#example").dataTable({ "language": { "url": "{{ url('/') }}/js/datatables/lang/fr.json" },
      "order": [[ 0, "desc" ]]
    });
  });
  </script>


<script src="{{url('/')}}/assets/vendor/datepicker/moment.js"></script>
<script src="{{url('/')}}/assets/vendor/datepicker/tempusdominus-bootstrap-4.js"></script>
<script src="{{url('/')}}/assets/vendor/datepicker/datepicker.js"></script>

<script src="{{url('/')}}/assets/vendor/datepicker/fr.js"></script>

<script type="text/javascript">
    $(function () {
        $('#datetimepickerdate').datetimepicker({
          format: 'DD/MM/YYYY',
          locale: 'fr'
      });
    });

    $(function () {
        $('#datetimepickerdate2').datetimepicker({
          format: 'DD/MM/YYYY',
          locale: 'fr'
      });
    });

</script>


@stop


@section('content')


                  <!-- ============================================================== -->
                  <!-- pageheader  -->
                  <!-- ============================================================== -->
                  <div class="row">
                      <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                          <div class="page-header">
                              <h3 class="mb-2">Grille d'évaluation de l'enseignant  </h3>
                           
                              <div class="page-breadcrumb">
                                  <nav aria-label="breadcrumb">
                                      <ol class="breadcrumb">
                                          <li class="breadcrumb-item"><a href="{{ URL::route('admin_index') }}" class="breadcrumb-link">Accueil</a></li>
                                          <li class="breadcrumb-item active" aria-current="page">Grille d'évaluation de l'enseignant  </li>
                                      </ol>
                                  </nav>
                              </div>
                          </div>
                      </div>
                  </div>
                  <!-- ============================================================== -->
                  <!-- end pageheader  -->
                  <!-- ============================================================== -->


<div class="row">


<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
  <div class="card">  
    @if(auth()->user()->super_admin == 1)
    <h5 class="card-header">
      <a href="{{ URL::route('new_grille_evaluation') }}" class="btn btn-primary ml-1 mb-1" ><i class="fas fa-plus"></i> Ajouter</a>
    </h5>
    @endif
  <div class="card-body">


@if(Session::has('error'))

<div class="alert alert-danger alert-dismissible fade show text-center" role="alert">
  <strong>{{ Session::get('error') }}</strong>
  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
    <span aria-hidden="true">&times;</span>
  </button>
</div>

@endif

@if(Session::has('success'))
<div class="alert alert-success alert-dismissible fade show text-center" role="alert">
  <strong>{{ Session::get('success') }}</strong>
  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
    <span aria-hidden="true">&times;</span>
  </button>
</div>
@endif

<div class="clearfix"></div>

      <div class="table-responsive">
          <table id="example" class="table table-striped table-bordered first">
            <thead>
            <tr class="text-uppercase">
              <th style="display: none;">#</th>
              <th>Enseignant</th>
              <th>Titre leçon</th>
              <th>Date</th>
              <th>Classe - Matière</th>
              <th>détails</th>
              @if(auth()->user()->super_admin == 1)
              <th>Action</th>
              @endif
            </tr>
            </thead>
            <tbody>

@foreach($grille_evaluations as $grille_evaluation)



                <tr>
                  <td style="display: none;">{{ $grille_evaluation->id }}</td>

                  <td>{{ $grille_evaluation->teacher->last_name . ' ' . $grille_evaluation->teacher->first_name }}</td>
                  
                  <td>{{ $grille_evaluation->titre }}</td>

                  <td>
                    <?php 
                    $FrDateTime = \DateTime::createFromFormat('Y-m-d', $grille_evaluation->date);
                    echo $FrDateTime->format('d/m/Y');
                    ?>
                  </td>

                  <td>
                    <?php $FindSubject = \App\Subjects::find($grille_evaluation->subject_id); ?>@if($FindSubject !== null ) {{ $FindSubject->classe->name }} - {{ $FindSubject->name }} @endif
                  </td>

                  
                  

                  <td>

                    @if(auth()->user()->is_admin == 1)
                      <a class="btn btn-primary btn-sm mb-1" href="{{ URL::route('admin_grille_evaluation_details', $grille_evaluation->id) }}" target="_black"><i class="fa fa-eye"></i> détail</a>
                    @endif

                    @if(auth()->user()->is_teacher == 1)
                      <a class="btn btn-primary btn-sm mb-1" href="{{ URL::route('enseignant_grille_evaluation_details', $grille_evaluation->id) }}" target="_black"><i class="fa fa-eye"></i> détail</a>
                    @endif
                    
                  </td>

                  @if(auth()->user()->super_admin == 1)
                    <td>
                        <a href="{{ URL::route('admin_grille_evaluation_edit', $grille_evaluation->id) }}" class="btn btn-success btn-sm mb-1"><i class="fa fa-edit"></i> Modifier </a>

                        <a onclick="return confirm('Supprimer?')" href="{{ URL::route('admin_grille_evaluation_delete', $grille_evaluation->id) }}" class="btn btn-danger btn-sm mb-1"><i class="fa fa-trash"></i> </a>
                    </td>
                  @endif

                    </tr>


@endforeach

                  </tbody>
                  </table>
               </div>

    </div>
  </div>
</div>

                                     



</div><!-- END row -->
                
               

@stop