<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App;
use View;
use Hash;
use Redirect;
use Validator;
use Response;
use Auth;
use Illuminate\Validation\Rule;
use App\User;
use App\Settings;
use App\Folders;
use App\EnseignantsFiles;
use App\Historique;

use App\Classes;
use App\Subjects;
use App\SubjectNames;

use App\Repartition;
use App\CahierJournal;
use App\Devoirs;
use App\DevoirsAlerts;
use App\Evaluations;
use App\Assiduite;

use App\Pointage;

use App\ControleContinu;
use App\ControleContinuEvaluations;

use App\DevoirsNotification;

use App\CompteRendu;

use Excel;
use App\Imports\UsersImport;

use App\Imports\StudentsImport;

use Illuminate\Support\Facades\DB;

class StudentsController extends Controller
{



    public function __construct()
    {
    //    $this->middleware('auth');
    }




    public function students()
    {   
        $settings = Settings::first();

        $classes = Classes::where('year_id', $settings->default_year)->orderBy('name', 'asc')->get();

        $students = User::where('is_student', true)->orderBy('id', 'desc')->get();

        return View::make('admin.students', compact('students', 'classes'));
            
    }


    





    public function students_importer(Request $request)
    {   
        
        $inputs = $request->all();


        $validation = Validator::make($inputs, [
            'file'=>'required',
            'class_id'=>'required',
        ]); 

            if ($validation->fails()) {

                return Redirect::back()->withInput()->withErrors($validation);

            } 

            else {

            $whitelist = array("xlsx","xls","XLS","XLSX");

            if ($request->hasFile('file')) {

                if (!(in_array($request->file('file')->extension(), $whitelist))) {
                    return Redirect::back()->withInput()->withError('Extension non autorisée');
                    die();
                } else {

                    $import = new StudentsImport();

                    Excel::import($import, request()->file('file'));

                }

            } 


            return Redirect::back()->withSuccess('Importé avec succèss');

            }

    }


    public function students_store(Request $request)
    {   
        
        $inputs = $request->all();


        $validation = Validator::make($inputs, [

          'last_name'=>'required',
          'first_name'=>'required',
          'username'=>'required|unique:users',
          'password'=>'required',
        
        ]); 

            if ($validation->fails()) {

                return Redirect::back()->withInput()->withErrors($validation);

            } 

            else {



            $barcode = date('Y').rand(11111, 99999);

            $checkBarcode = User::where('barcode', $barcode)->first();

            if ($checkBarcode !== null) {
                return Redirect::back()->with('error', 'Error! try again..');
                die();
            }


            $student = User::create([

                'is_student' => 1,

                'class_id' => e($inputs['class_id']),

                'last_name' => e($inputs['last_name']),
                'first_name' => e($inputs['first_name']),
                'email' => e($inputs['email']),
                'phone' => e($inputs['phone']),
                'username' => e($inputs['username']),
                'password' => Hash::make(e($inputs['password'])),
                'barcode' => $barcode,


            ]);

            $student->save();


            return Redirect::back()->withSuccess('Ajouter avec succès');

            }

    }



    public function student_edit($id)
    { 
        $student = User::find($id);

        if ($student !== null) {

            $settings = Settings::first();

            $classes = Classes::where('year_id', $settings->default_year)->orderBy('name', 'asc')->get();

            return View::make('admin.student_edit', compact('student', 'classes'));
        } else {
            return View::make('404');
        }
    }


    public function student_update($id, Request $request)
    { 
        $student = User::find($id);

        $inputs = $request->all();

        if ($student !== null) {

            

            $validation = Validator::make($inputs, [

              'last_name'=>'required',
              'first_name'=>'required',
            //  'email'=>'unique:users,email,'.$student->id,
            ]); 

            if ($validation->fails()) {

                return Redirect::back()->withInput()->withErrors($validation);

            } 

            else {

                $student->class_id = e($inputs['class_id']);
                
                $student->last_name = e($inputs['last_name']);
                $student->first_name = e($inputs['first_name']);

                $student->email = e($inputs['email']);
                $student->phone = e($inputs['phone']);


                $student->save();

                return Redirect::back()->withSuccess('Mise à jour avec succès');

            }

        } else {
            return View::make('404');
        }
    }


    public function student_password_update($id, Request $request)
    { 
        $student = User::find($id);

        $inputs = $request->all();

        if ($student !== null) {


            $validation = Validator::make($inputs, [
              'username'=>'unique:users,username,'.$student->id,
            ]); 

            if ($validation->fails()) {

                return Redirect::back()->withInput()->withErrors($validation);

            } 

            else {

    
                $student->username = e($inputs['username']);
                $student->password = Hash::make(e($inputs['password']));

                $student->save();

                return Redirect::back()->withSuccess('Mise à jour avec succès');

            }

        } else {
            return View::make('404');
        }
    }


    public function student_destroy($id)
    { 
        $student = User::find(e($id));

        if ($student !== null) {

            //---> SuiviPreparation
            \App\SuiviPreparation::where('student_id', $student->id)->delete();
            
            //---> DemandesRencontreStds
            \App\DemandesRencontreStds::where('student_id', $student->id)->delete();

            //---> DemandeDocsParent
            \App\DemandeDocsParent::where('student_id', $student->id)->delete();

            //---> OrientationStudents
            \App\OrientationStudents::where('student_id', $student->id)->delete();

            //---> ReglementNotification
            \App\ReglementNotification::where('user_id', $student->id)->delete();

            //---> AbsencesStudents
            \App\AbsencesStudents::where('student_id', $student->id)->delete();

            //---> RessourcesNotification
            \App\RessourcesNotification::where('student_id', $student->id)->delete();

            //---> DevoirsNotification
            \App\DevoirsNotification::where('student_id', $student->id)->delete();

            //---> EmailContent
            \App\EmailContent::where('user_id', $student->id)->delete();

            //---> Reclamations
            \App\Reclamations::where('student_id', $student->id)->delete();

            //---> CompteRendu
            CompteRendu::where('student_id', $student->id)->delete();

            //---> Pointage
            Pointage::where('student_id', $student->id)->delete();

            //--> delete ControleContinuEvaluations
            ControleContinuEvaluations::where('student_id', $student->id)->delete();

            //---> Assiduite
            Assiduite::where('student_id', $student->id)->delete();

            //---> DevoirsAlerts
            DevoirsAlerts::where('student_id', $student->id)->delete();

            //---> Evaluations
            Evaluations::where('student_id', $student->id)->delete();

            $student->delete();

            return Redirect::back()->withError('Supprimé avec succès');

           
        } else {
            return View::make('404');
        }
    }


/*--------------


students ZONE

-------------*/



    public function students_index()
    { 
        $settings = Settings::first();

        $evaluations = Evaluations::where('student_id', auth()->user()->id)->where('year_id', $settings->default_year)->orderBy('id', 'desc')->get();

        $devoirs = Devoirs::where('preparation_exam', null)->where('class_id', auth()->user()->class_id)->where('year_id', $settings->default_year)->orderBy('id', 'desc')->get();

        $assiduite = Assiduite::where('student_id', auth()->user()->id)->where('year_id', $settings->default_year)->orderBy('id', 'desc')->get();

        $controle_evaluations = ControleContinuEvaluations::where('student_id', auth()->user()->id)->where('year_id', $settings->default_year)->get();

//----> Orientation

        $OrientationNotif = false;
        $ListOrientations = null;
        $CheckOrient = \App\Orientation::where('class_id', auth()->user()->class_id)->get();

        if (count($CheckOrient) > 0) {

            foreach ($CheckOrient as $CheckOrie) {

                $CheckOrientStudent = \App\OrientationStudents::where('student_id', auth()->user()->id)->where('orient_id', $CheckOrie->id)->first();

                if ($CheckOrientStudent == null) {
                    $OrientationNotif = true;
                    $ListOrientations = $CheckOrie;
                    break;
                }

            }

        } 

//----> End Orientation

    

        return view('students.index', compact('evaluations', 'devoirs', 'assiduite', 'controle_evaluations', 'OrientationNotif', 'ListOrientations'));
    }



    public function student_store_orientation(Request $request)
    {   
        $settings = Settings::first();

        $inputs = $request->all();

        $validation = Validator::make($inputs, [
            'orientation'=>'required',
            'orient_id'=>'required',
        ]); 

        if ($validation->fails()) {
            return Redirect::back()->withInput()->withErrors($validation);
        } 

        else {

            \App\OrientationStudents::create([
                'orient_id' => $inputs['orient_id'],
                'orientation' => $inputs['orientation'],
                'student_id' => auth()->user()->id,
                'class_id' => auth()->user()->class_id,
            ]);

            return Redirect::back()->withSuccess('تم ارسال التوجيه الذي اخترتم');

        }


    }




    public function students_evaluations()
    { 

//--> Activites Historique
$user_type = 3; //-> student
\App\ActivitesHistorique::create([
    'user_id' => Auth::user()->id,
    'type' => $user_type,
    'rubrique' => 'Évaluations',
]);
//--> End Activites Historique

        $settings = Settings::first();

        $evaluations = Evaluations::where('student_id', auth()->user()->id)->where('year_id', $settings->default_year)->orderBy('id', 'desc')->get();

        return view('students.evaluations', compact('evaluations'));
    }



    public function student_profile()
    {   
        $student = User::find(auth()->user()->id);
        return view('students.profile', compact('student'));
    }


    public function student_profile_password_update(Request $request)
    { 
        $user = User::find(auth()->user()->id);

        $inputs = $request->all();

        if ($user !== null) {

            $old_password = $inputs['old_password'];

            if (Hash::check($old_password, $user->password)) {


                $user->password = Hash::make(e($inputs['password']));
                $user->save();

                return Redirect::back()->withSuccess('Mise à jour avec succès');

             } else { 
                return Redirect::back()->withError('Mot de passe incorrect.');
            }

            
        } else {
            return View::make('404');
        }
    }


/*---------------

    assiduite

--------------*/
    
    public function student_assiduite()
    {   
        $settings = Settings::first();

        $assiduite = Assiduite::where('student_id', auth()->user()->id)->where('year_id', $settings->default_year)->orderBy('id', 'desc')->get();

        return View::make('students.assiduite', compact('assiduite'));
    }


/*---------------

    devoirs

--------------*/
    
    public function students_devoirs(Request $request)
    {   

$days_en = ['Monday','Tuesday','Wednesday','Thursday','Friday','Saturday'];
$days_fr = ['Lundi','Mardi','Mercredi','Jeudi','Vendredi','Samedi'];


//$friday = strtotime('last friday', strtotime(date('2021-04-09')));
$friday = strtotime('last friday', strtotime('tomorrow'));
$sunday = strtotime('+7 days', $friday);
//echo "<P>". date('Y-m-d', $friday) . " to " . date('Y-m-d', $sunday) . "</P>";

//$from = date('Y-m-d', $friday);
$to = date('Y-m-d', $sunday);

        $inputs = $request->all();

        if ($request->input('from') AND $request->input('to')) {

            $fromDateTime = \DateTime::createFromFormat('d/m/Y', e($inputs['from']));
            $toDateTime = \DateTime::createFromFormat('d/m/Y', e($inputs['to']));

            if ($fromDateTime !== false AND $toDateTime !== false) {

                $from = date($fromDateTime->format('Y-m-d'));
            //    $to = date($toDateTime->format('Y-m-d')) ;

                $devoirs = Devoirs::where('preparation_exam', null)
                ->where('class_id', auth()->user()->class_id)
                ->whereBetween('date_en', [$from, $to])
                ->orderBy('id', 'desc')->paginate(50)->appends(request()->query());

                return View::make('students.devoirs', compact('devoirs'));
            }

            else { return redirect()->route('travaux_afaire'); }
            

        }
        else { return redirect()->route('travaux_afaire'); }
        



               
    }


    public function travaux_afaire()
    {   

//--> Activites Historique
$user_type = 3; //-> student
\App\ActivitesHistorique::create([
    'user_id' => Auth::user()->id,
    'type' => $user_type,
    'rubrique' => 'Les devoirs',
]);
//--> End Activites Historique

        $DevoirsNotification = \App\DevoirsNotification::where('readed', 0)->where('is_preparation', 0)->where('student_id', auth()->user()->id)->get();

        foreach ($DevoirsNotification as $DevNotification) {
            $DevNotification->delete();
        }

        return View::make('students.travaux_afaire');

    }


    public function fix_devoirs()
    {   
        
        $devoirs = \App\Devoirs::where('preparation_exam', null)->get();
        foreach ($devoirs as $devoir) {
            if (!empty($devoir->date)) {
                $fromEN = \DateTime::createFromFormat('d/m/Y', substr($devoir->date, 0, 10)); 
                if ($fromEN) {
                   $devoir->date_en = $fromEN->format('Y-m-d');
                    $devoir->save();
                }     
            }  
        }
        

    }



    public function devoir_details($id)
    { 

        $devoir = Devoirs::find(e($id));

        if ($devoir !== null) {

            return View::make('students.devoir_details', compact('devoir'));
           
        } else {
            return View::make('404');
        }
    }




/*---------------

    Préparation à l'exam

--------------*/
    
    public function preparation_exam()
    {   

//--> Activites Historique
$user_type = 3; //-> student
\App\ActivitesHistorique::create([
    'user_id' => Auth::user()->id,
    'type' => $user_type,
    'rubrique' => 'Préparation à l\'exam',
]);
//--> End Activites Historique

        $settings = Settings::first();

        $DevoirsNotification = \App\DevoirsNotification::where('readed', 0)->where('is_preparation', 1)->where('student_id', auth()->user()->id)->get();

        foreach ($DevoirsNotification as $DevNotification) {
            $DevNotification->delete();
        }

        $devoirs = Devoirs::where('class_id', auth()->user()->class_id)->where('year_id', $settings->default_year)->orderBy('id', 'desc')->get();

        return View::make('students.preparation', compact('devoirs'));
    }




/*---------------

    Contrôle continu 

--------------*/
    
    public function student_evaluations_controle()
    {   

//--> Activites Historique
$user_type = 3; //-> student
\App\ActivitesHistorique::create([
    'user_id' => Auth::user()->id,
    'type' => $user_type,
    'rubrique' => 'Évaluations',
]);
//--> End Activites Historique
        
        $settings = Settings::first();

        $controle_continu_evaluations = ControleContinuEvaluations::where('student_id', auth()->user()->id)->where('year_id', $settings->default_year)->orderBy('id', 'desc')->get();

        return View::make('students.controle_continu', compact('controle_continu_evaluations'));
    }



/*---------------

    Simili 

--------------*/
    
    public function student_evaluations_simili()
    {   

        
        $settings = Settings::first();

        $simili_evaluations = \App\SimiliEvaluations::where('student_id', auth()->user()->id)->where('year_id', $settings->default_year)->orderBy('id', 'desc')->get();

        foreach ($simili_evaluations as $simili_evaluation) {
            $simili_evaluation->s_readed = 1;
            $simili_evaluation->save();
        }

        return View::make('students.simili', compact('simili_evaluations'));
    }





/*---------------

    compte rendu

--------------*/
    
    public function student_compte_rendu()
    {   
        $settings = Settings::first();

        $compte_rendu = CompteRendu::where('student_id', auth()->user()->id)->where('year_id', $settings->default_year)->orderBy('id', 'desc')->get();

        foreach ($compte_rendu as $compte_r) {
            $compte_r->readed = 1;
            $compte_r->save();
        }

        return View::make('students.compte_rendu', compact('compte_rendu'));
    }


/*---------------

    dossiers / ressources 

--------------*/
    
    public function students_dossiers()
    {   

//--> Activites Historique
$user_type = 3; //-> student
\App\ActivitesHistorique::create([
    'user_id' => Auth::user()->id,
    'type' => $user_type,
    'rubrique' => 'Les ressources',
]);
//--> End Activites Historique

    /*    $folders = Subjects::join('folders', 'folders.teacher_id', '=', 'subjects.teacher_id')
        ->where('subjects.class_id', auth()->user()->class_id)
        ->select(
            'folders.id', 
            'folders.teacher_id', 
            'folders.folder_name')
        ->orderBy('folders.id', 'DESC')
        ->get();
    */  

        $RessourcesNotification = \App\RessourcesNotification::where('readed', 0)->where('student_id', auth()->user()->id)->get();

        foreach ($RessourcesNotification as $RessNotification) {
            $RessNotification->delete();
        }


        $settings = Settings::first();

        $folders = Folders::where('year_id', $settings->default_year)->where('class_id', auth()->user()->class_id)->orderBy('id', 'desc')->get();

        return view('students.dossiers', compact('folders'));
    }


    public function students_ressources($id)
    { 
        $folder = Folders::find($id);

        if ($folder !== null) {

            if ($folder->class_id == auth()->user()->class_id) {
                
                $files = EnseignantsFiles::where('folder_id', $folder->id)->orderBy('id', 'desc')->get();

                return view('students.dossiers_ressources', compact('folder', 'files'));
            }
 
           
        } else {
            return View::make('404');
        }
    }




/**********************
     avis notes
**********************/

    public function eleve_avis_notes()
    { 
        $settings = Settings::first();

        $liste_avis = \App\AvisNotes::where('for_students', 1)->where('year_id', $settings->default_year)->orderBy('id', 'desc')->paginate(50);

        \App\AvisNotifications::where('user_id', auth()->user()->id)->where('user_type', 2)->delete(); 

        return View::make('avis', compact('liste_avis'));
    }





}