@extends('layouts.master_panel')

@section('title') Assiduité @stop

@section('CSS') 


<link rel="stylesheet" type="text/css" href="{{url('/')}}/js/datatables/dataTables.bootstrap4.min.css">

<link rel="stylesheet" href="{{url('/')}}/assets/vendor/datepicker/tempusdominus-bootstrap-4.css" />


@stop

@section('JS') 


<script src="{{url('/')}}/js/datatables/jquery.dataTables.min.js"></script>
<script src="{{url('/')}}/js/datatables/dataTables.bootstrap4.min.js"></script>

<script type="text/javascript" class="init">
  $(document).ready(function() {
    $("#example").dataTable({ "language": { "url": "{{ url('/') }}/js/datatables/lang/fr.json" },
      "order": [[ 0, "desc" ]]
    });
  });
  </script>


<script src="{{url('/')}}/assets/vendor/datepicker/moment.js"></script>
<script src="{{url('/')}}/assets/vendor/datepicker/tempusdominus-bootstrap-4.js"></script>
<script src="{{url('/')}}/assets/vendor/datepicker/datepicker.js"></script>

<script src="{{url('/')}}/assets/vendor/datepicker/fr.js"></script>

<script type="text/javascript">
    $(function () {
        $('#datetimepickerdate').datetimepicker({
          format: 'DD/M/YYYY',
          locale: 'fr'
      });
    });

    $(function () {
        $('#timepicker').datetimepicker({
          format: 'HH:mm',
          locale: 'fr'
      });
    });

</script>



<script type="text/javascript">
$(document).ready(function () { 

            $('#subjectID').on('change',function(e){
            var subject_id = e.target.value;

            $.ajax({
            type: "GET",
            url: "{{ url('/') }}/enseignant/ajax_subject_class?subject_id="+subject_id,
                success: function(data) {  

                    var class_id = $("#classID").val(data);

                    $.ajax({
                    type: "GET",
                    url: "{{ url('/') }}/enseignant/ajax_students_class?class_id="+data,
                        success: function(data) {  

                            var subcat =  $('#studentsID').empty();

                            $.each(data, function(key, val) { 
                            //  console.log(val.last_name); 
                            subcat.append('<option value ="'+val.id+'">'+val.last_name+' '+val.first_name+'</option>');

                            });

                            $('.selectpicker').selectpicker('refresh');

                        }

                    });


                }

            });

            


        });
});
</script>



@stop


@section('content')


                  <!-- ============================================================== -->
                  <!-- pageheader  -->
                  <!-- ============================================================== -->
                  <div class="row">
                      <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                          <div class="page-header">
                              <h3 class="mb-2">Assiduité</h3>
                           
                              <div class="page-breadcrumb">
                                  <nav aria-label="breadcrumb">
                                      <ol class="breadcrumb">
                                          <li class="breadcrumb-item"><a href="{{ URL::route('enseignant_index') }}" class="breadcrumb-link">Accueil</a></li>
                                          <li class="breadcrumb-item active" aria-current="page">Assiduité </li>
                                      </ol>
                                  </nav>
                              </div>
                          </div>
                      </div>
                  </div>
                  <!-- ============================================================== -->
                  <!-- end pageheader  -->
                  <!-- ============================================================== -->


<div class="row">


<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
  <div class="card">

<?php /* ?>
    <h5 class="card-header">
      <a href="#" class="btn btn-primary mb-1" data-toggle="modal" data-target="#exampleModal"><i class="fa fa-plus"></i> Ajouter </a>
    </h5>
<?php */ ?>
  <div class="card-body">

<?php /* ?>

<!-- Modal -->
<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
<div class="modal-dialog modal-lg" role="document">
  <div class="modal-content">
    <div class="modal-header">
      <h5 class="modal-title" id="exampleModalLabel">Ajouter</h5>
      <a href="#" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></a>
    </div>
    <div class="modal-body">

<form method="POST" action="{{ URL::route('enseignant_assiduite_store') }}">

{{ csrf_field() }}


<div class="form-row">

  <div class="col-md-12 mb-3">
      <label>Matières / Classes</label>
      <select name="subject_id" id="subjectID" class="selectpicker" data-width="100%" required="required">   
        
      <option value="">Choisir</option>
        @foreach($subjects as $subject)

          <?php $getclass = \App\Classes::find($subject->class_id); ?>

          <option value="{{ $subject->id }}">{{ $subject->name }} ({{ $getclass->name }})</option>

        @endforeach
      </select>

      <input type="hidden" name="class_id" id="classID" value="">

  </div>

  <div class="col-md-12 mb-3">
      <label>Élèves</label>
      <select name="student_id" id="studentsID" class="selectpicker" data-width="100%" required="required" title="Choisir">   
      </select>
  </div>


  <div class="col-md-6 mb-3">
    <label>Le:</label>
    <div class="form-group">
    <div class="input-group date" id="datetimepickerdate" data-target-input="nearest">

    <input name="date" type="text" class="form-control datetimepicker-input" data-target="#datetimepickerdate" required="required" value="{{ old('date') }}" />
    
      <div class="input-group-append" data-target="#datetimepickerdate" data-toggle="datetimepicker">
      <div class="input-group-text"><i class="far fa-calendar-alt"></i></div>
      </div>
    </div>
  </div>
  </div>

  <div class="col-md-6 mb-3">
    <label>Heure:</label>
    <div class="form-group">
    <div class="input-group date" id="timepicker" data-target-input="nearest">

    <input name="hour" type="text" class="form-control datetimepicker-input" data-target="#timepicker" value="{{ old('hour') }}" />
    
      <div class="input-group-append" data-target="#timepicker" data-toggle="datetimepicker">
      <div class="input-group-text"><i class="far fa-clock"></i></div>
      </div>
    </div>
  </div>
  </div>


  <div class="col-md-12 mb-5 ">
      <label>Motif</label>
      <select name="motif" class="selectpicker" data-width="100%" title="Choisir" required="required">   
        @foreach($assiduite_motifs as $assiduite_motif)
          <option value="{{ htmlspecialchars_decode($assiduite_motif->motif) }}">{{ htmlspecialchars_decode($assiduite_motif->motif) }}</option>
        @endforeach
      </select>
  </div>



 
</div>

<div class="form-row mt-1">
<div class="col-md-12">
    <button class="btn btn-success btn-block" type="submit">Valider</button>
</div>
</div>

</form>

    </div>
    <div class="modal-footer">
      <a href="#" class="btn btn-dark" data-dismiss="modal">Fermer</a>
    </div>
  </div>
</div>
</div>
<!-- End Modal -->

<?php */ ?>

<div class="clearfix"></div>

@if(Session::has('error'))

<div class="alert alert-danger alert-dismissible fade show text-center" role="alert">
  <strong>{{ Session::get('error') }}</strong>
  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
    <span aria-hidden="true">&times;</span>
  </button>
</div>

@endif

@if(Session::has('success'))
<div class="alert alert-success alert-dismissible fade show text-center" role="alert">
  <strong>{{ Session::get('success') }}</strong>
  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
    <span aria-hidden="true">&times;</span>
  </button>
</div>
@endif

<div class="clearfix"></div>

      <div class="table-responsive">
          <table id="example" class="table table-striped table-bordered first">
            <thead>
            <tr class="text-uppercase">
              <th style="display: none;">#</th>
              <th>Élève</th>
              <th>Classe/Matière</th>
              <th>Date</th>
              <th>Détail</th>
              <?php /* ?>
              <th>Action</th>
              <?php */ ?>
            </tr>
            </thead>
            <tbody>

@foreach($assiduite as $assidu)

              <tr>

                  <td style="display: none;">{{ $assidu->id }}</td>

                  <td>{{ $assidu->student->last_name . ' ' . $assidu->student->first_name }}</td>
                                  
                  <td>
                    <?php $FindSubject = \App\Subjects::find($assidu->subject_id); ?>
                    {{ $assidu->classe->name }} @if($FindSubject !== null ) - {{ $FindSubject->name }} @endif
                  </td>

                  
                  <td>{{ $assidu->date }} à {{ $assidu->hour }}</td>
                  
                  <td>
                    
                    <a class="btn btn-primary btn-sm" href="#" data-toggle="modal" data-target="#exampleModal-{{ $assidu->id }}"><i class="fa fa-eye"></i> détail</a>


<!-- Modal -->
<div class="modal fade" id="exampleModal-{{ $assidu->id }}" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel-{{ $assidu->id }}" aria-hidden="true">
<div class="modal-dialog modal-lg" role="document">
  <div class="modal-content">
    <div class="modal-header">
      <h5 class="modal-title" id="exampleModalLabel-{{ $assidu->id }}">Détails</h5>
      <a href="#" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></a>
    </div>
    <div class="modal-body">
      
      <?php echo html_entity_decode($assidu->details); ?>
   
    </div>
    <div class="modal-footer">
      <a href="#" class="btn btn-dark" data-dismiss="modal">Fermer</a>
    </div>
  </div>
</div>
</div>
<!-- End Modal -->


                  </td>
<?php /* ?>
                  <td>
                    <a onclick="return confirm('Supprimer?')" href="{{ URL::route('assiduite_delete', $assidu->id) }}" class="btn btn-danger btn-sm"><i class="fa fa-trash"></i>  </a>
                  </td>
<?php */ ?>
              </tr>

@endforeach
                  </tbody>
                  </table>
               </div>

    </div>
  </div>
</div>

                                     


</div><!-- END row -->
                
               

@stop