@extends('layouts.master_panel')

@section('title') Personnel @stop

@section('CSS') 


<link rel="stylesheet" type="text/css" href="{{url('/')}}/js/datatables/dataTables.bootstrap4.min.css">

@stop

@section('JS') 


<script src="{{url('/')}}/js/datatables/jquery.dataTables.min.js"></script>
<script src="{{url('/')}}/js/datatables/dataTables.bootstrap4.min.js"></script>

<script type="text/javascript" class="init">
  $(document).ready(function() {
    $("#example").dataTable({ "language": { "url": "{{ url('/') }}/js/datatables/lang/fr.json" }
    });
  });
  </script>

@stop


@section('content')


                  <!-- ============================================================== -->
                  <!-- pageheader  -->
                  <!-- ============================================================== -->
                  <div class="row">
                      <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                          <div class="page-header">
                              <h3 class="mb-2">Personnel </h3>
                           
                              <div class="page-breadcrumb">
                                  <nav aria-label="breadcrumb">
                                      <ol class="breadcrumb">
                                          <li class="breadcrumb-item"><a href="{{ URL::route('admin_index') }}" class="breadcrumb-link">Accueil</a></li>
                                          <li class="breadcrumb-item active" aria-current="page">Personnel</li>
                                      </ol>
                                  </nav>
                              </div>
                          </div>
                      </div>
                  </div>
                  <!-- ============================================================== -->
                  <!-- end pageheader  -->
                  <!-- ============================================================== -->


<div class="row">


<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
  <div class="card">
    <h5 class="card-header">

@if(auth()->user()->super_admin == 1)      
      <a href="#" class="btn btn-primary mb-1" data-toggle="modal" data-target="#exampleModal"><i class="fa fa-plus"></i> Ajouter </a>
@endif

    </h5>
  <div class="card-body">


<!-- Modal -->
<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
<div class="modal-dialog modal-lg" role="document">
  <div class="modal-content">
    <div class="modal-header">
      <h5 class="modal-title" id="exampleModalLabel">Ajouter</h5>
      <a href="#" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></a>
    </div>
    <div class="modal-body">

<form method="POST" action="{{ URL::route('personnel_store') }}"  enctype="multipart/form-data">

{{ csrf_field() }}

<div class="row">


<div class="col-md-12 mb-3">
    <label>Type:</label>
    <select name="catg_id" class="selectpicker" data-width="100%" required="required" title="Choisir"  >
        @foreach($personnel_catg as $personnel_cat)
        <option value="{{ $personnel_cat->id }}">{{ $personnel_cat->catg }}</option>
        @endforeach
    </select>
</div>


  <div class="col-md-6">
    <div class="form-group">
    <label>Nom</label>
    <div class="input-group">
    <div class="input-group-prepend"><span class="input-group-text"><i class="fas fa-address-card"></i></span></div>
    <input name="last_name" type="text" class="form-control" value="{{ old('last_name') }}" required>
    </div>
    </div>
  </div>

  <div class="col-md-6">
    <div class="form-group">
    <label>Prénom</label>
    <div class="input-group">
    <div class="input-group-prepend"><span class="input-group-text"><i class="fas fa-address-card"></i></span></div>
    <input name="first_name" type="text" class="form-control" value="{{ old('first_name') }}" required>
    </div>
    </div>
  </div>

</div>



<div class="row">

  <div class="col-md-6">
    <div class="form-group">
    <label>Téléphone</label>
    <div class="input-group">
    <div class="input-group-prepend"><span class="input-group-text"><i class="fa fa-phone"></i></span></div>
    <input name="phone" type="text" class="form-control" value="{{ old('phone') }}">
    </div>
    </div>
  </div>

  <div class="col-md-6">
    <div class="form-group">
    <label>Email</label>
    <div class="input-group">
    <div class="input-group-prepend"><span class="input-group-text"><i class="fa fa-envelope"></i></span></div>
    <input name="email" type="email" class="form-control" value="{{ old('email') }}" required="required">
    </div>
    </div>
    @if($errors->first('email'))
      <small class="form-text text-danger">{{ $errors->first('email') }}</small>
    @endif
  </div>

</div>


<div class="clearfix"></div><hr>

<div class="row">

  <div class="col-md-6">
    <div class="form-group">
    <label>Nom d'utilisateur</label>
    <div class="input-group">
    <div class="input-group-prepend"><span class="input-group-text">@</span></div>
    <input name="username" type="text" class="form-control" value="{{ old('username') }}" required="required">
    </div>
    </div>
    @if($errors->first('username'))
      <small class="form-text text-danger">{{ $errors->first('username') }}</small>
    @endif
  </div>

  <div class="col-md-6">
    <div class="form-group">
    <label>Mot de passe</label>
    <div class="input-group">
    <div class="input-group-prepend"><span class="input-group-text" style="cursor: pointer; " onclick="generatePassword();">Générer mot de passe</span></div>
    <input name="password" type="text" id="inputPassword" class="form-control input-lg" required="required">
    </div>
    </div>
  </div>

</div>

<div class="row">

    <div class="col-md-12">
      <label>Image</label>
        <div class="custom-file">
          <input type="file" name="image">
          
        </div>
        @if($errors->first('image'))
          <small class="form-text text-danger">{{ $errors->first('image') }}</small>
        @endif
    </div>
    
</div>

<script type="text/javascript">

function generatePassword() {
    var length = 8,
        charset = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789!@#$%&*",
        retVal = "";
    for (var i = 0, n = charset.length; i < length; ++i) {
        retVal += charset.charAt(Math.floor(Math.random() * n));
    }

  //  return retVal;
    $('#inputPassword').val(retVal); 
}

</script> 

<div class="row">
<div class="col-md-12 mt-3">
    <button class="btn btn-success btn-block" type="submit">Ajouter</button>
</div>
</div>

</form>

    </div>
    <div class="modal-footer">
      <a href="#" class="btn btn-dark" data-dismiss="modal">Fermer</a>
    </div>
  </div>
</div>
</div>
<!-- End Modal -->

  
<div class="clearfix"></div>

@if(Session::has('error'))

<div class="alert alert-danger alert-dismissible fade show text-center" role="alert">
  <strong>{{ Session::get('error') }}</strong>
  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
    <span aria-hidden="true">&times;</span>
  </button>
</div>

@endif

@if(Session::has('success'))
<div class="alert alert-success alert-dismissible fade show text-center" role="alert">
  <strong>{{ Session::get('success') }}</strong>
  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
    <span aria-hidden="true">&times;</span>
  </button>
</div>
@endif

<div class="clearfix"></div>

      <div class="table-responsive">
          <table id="example" class="table table-striped table-bordered first">
            <thead>
            <tr class="text-uppercase">
              <th></th>
              <th>Nom et Prénom</th>
              <th>Type</th>
              <th>Nom d'utilisateur</th>
              <th>Action</th>
            </tr>
            </thead>
            <tbody>

             @foreach($personnel as $perso)
                <tr style="font-size: 0.9em;">
                  

                   <td>
                    @if(!empty($perso->image))
                    <img style="max-width: 65px; max-height: 65px;" src="{{ url('/') }}/uploads/images/{{ $perso->image }}" alt="" class="rounded-circle user-avatar-xxl">
                    @else
                    <img style="max-width: 65px; max-height: 65px;" src="{{ url('/') }}/uploads/images/user.png" alt="" class="rounded-circle user-avatar-xxl">
                    @endif
                  </td>
                                           
                  <td>{{ $perso->last_name . ' ' . $perso->first_name }}</td>

                  <td>
                    <?php $getCat = \App\PersonnelCatg::find($perso->personnel_catg); ?>
                    @if($getCat !== null ) {{ $getCat->catg }} @endif
                  </td>

                  <td>{{ $perso->username }}</td>

                  
                    <td>
@if(auth()->user()->super_admin == 1)
                        <a href="{{ URL::route('personnel_edit', $perso->id) }}" class="btn btn-success btn-sm mb-1"><i class="fa fa-edit"></i> Modifier </a>

                        <a onclick="return confirm('Supprimer?')" href="{{ URL::route('personnel_destroy', $perso->id) }}" class="btn btn-danger btn-sm mb-1"><i class="fa fa-trash"></i> Supprimer </a>
@endif                       
                      </td>

                    </tr>

                    @endforeach
                  </tbody>
                  </table>
               </div>

    </div>
  </div>
</div>

                          
</div><!-- END row -->
                
               

@stop