<!doctype html>
<html lang="fr">
<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <meta name="csrf-token" content="{{ csrf_token() }}" />


    <title>Historique</title>

    <style type="text/css">

.table-border { border-collapse: collapse;  }

.table-border tr th, .table-border tr td{
border-width: 1px !important;
border-style: solid !important;
border-color: #000 !important;
}

.table-border tr th { font-size: 0.8em; padding: 4px !important; }
.table-border tr td { font-size: 0.8em; padding: 4px !important; }

.clear { clear: both; }
@media print {

    .pagebreak {
        clear: both; 
        page-break-after: always;
    }

    .no-print { display: none !important; }

    @page {
        size: a4;   
        margin: 4mm; 
        background-color: #FFFFFF;
        padding: 2mm;
    }

    

  
}

.btn {
    font-size: 20px;
    padding: 10px;
    border-radius: 2px;
    cursor: pointer;
}

.btn-primary {
    color: #fff;
    background-color: #5969ff;
    border-color: #5969ff;
}

.btn-danger {
    color: #fff;
    background-color: #DA0419;
    border-color: #DA0419;
    font-size: 0.9em;
    padding: 4px;
    border-radius: 2px;
    margin: 6px;
    text-decoration: none;
}

.btn-success {
    color: #fff;
    background-color: #21ae41;
    border-color: #21ae41;
    font-size: 0.9em;
    padding: 4px;
    border-radius: 2px;
    margin: 6px;
    text-decoration: none;
}

.btn-primary:hover {
    color: #fff;
    background-color: #4656e9;
    border-color: #4656e9;
}


</style>



</head>

<body class="p-2">

<a onclick="window.print();" style="float: left;" class="btn btn-primary no-print">Imprimer</a>
<div class="clear"></div>


<div class="col-md-12">
<?php 
function convertToHoursMins($time, $format = '%02d:%02d') {
    if ($time < 1) {
        return;
    }
    $hours = floor($time / 60);
    $minutes = ($time % 60);
    return sprintf($format, $hours, $minutes);
}

 ?>  



@if(isset($_GET['teacher_id']))

<?php 

if (empty($_GET['teacher_id'])) {

    if (!empty($_GET['statut'])) {
        $enseignants = \App\User::where('is_teacher', true)->where('teacher_type', e($_GET['statut']))->orderBy('id', 'desc')->get();
    } else {
    $enseignants = \App\User::where('is_teacher', true)->orderBy('id', 'desc')->get();
    }


} else {
    $enseignants = \App\User::where('id', e($_GET['teacher_id']))->where('is_teacher', true)->orderBy('id', 'desc')->get();
}


?>

@foreach($enseignants as $enseignant)

<?php 



if (!empty($_GET['from']) AND !empty($_GET['to'])) {
    
    $fromDateTime = \DateTime::createFromFormat('d/m/Y', e($_GET['from']));
    $toDateTime = \DateTime::createFromFormat('d/m/Y', e($_GET['to']));

    $from = date($fromDateTime->format('Y-m-d')) ;
    $to = date($toDateTime->format('Y-m-d')) ;


    $cahier_journal = \App\CahierJournal::where('teacher_id', $enseignant->id)
    ->where('year_id', $settings->default_year)
    ->whereBetween('date_en', [$from, $to])
    ->orderBy('date_en', 'asc')->get();


} else {

    $cahier_journal = \App\CahierJournal::where('teacher_id', $enseignant->id)->where('year_id', $settings->default_year)->orderBy('date_en', 'asc')->get();
}



 ?>


@if(count($cahier_journal) > 0)

 <h4 class="mb-2"><strong>Enseignant(e) :</strong> {{ $enseignant->last_name . ' ' . $enseignant->first_name }} 
<br><br>
@if (!empty($_GET['from']) AND !empty($_GET['to'])) 
<strong>Date :</strong> {{ e($_GET['from']) }} à {{ e($_GET['to']) }}
@endif

 </h4>

<table style="width: 100%; margin-top: 5px;" class="table table-border mt-5">
            <thead>
            <tr style="text-transform: uppercase;" align="left">

              <th>date</th>
              <th>Classe</th>
              <th>heures</th>
              <th>La duré</th>
              <th class="no-print">Action</th>
            </tr>
            </thead>
            <tbody>

<?php $total_hours = 0; ?>
@foreach($cahier_journal as $journal)

<?php 

$checkHour = \App\CahierJournal::where('id', '!=' ,$journal->id)->where('teacher_id', $enseignant->id)->where('date_en', $journal->date_en)->where('hour_start', $journal->hour_start)->where('hour_end', $journal->hour_end)->get();

if (count($checkHour) >= 1) {
    $divi = count($checkHour) + 1;
    $hours_differ = $journal->hours_differance/$divi;
} else { $hours_differ = $journal->hours_differance; }

 ?>

            <tr>
                
                <?php $frDateTime = \DateTime::createFromFormat('Y-m-d', $journal->date_en);?>  

                <td>{{ $frDateTime->format('d/m/Y') }}</td>

                <td>{{ $journal->classe->name }} - {{ $journal->subject->name }}</td>

                <td>{{ $journal->hour_start }} à {{ $journal->hour_end }} @if(count($checkHour) >= 1) (Classes groupées) @endif</td>

                <td>
                    <?php echo convertToHoursMins($journal->hours_differance, '%02d heures %02d minutes'); ?>
                </td>

                <td class="no-print">

                    @if(auth()->user()->super_admin == 1)
                        <a href="{{ URL::route('admin_journal_edit', $journal->id) }}" class="btn-success">Modifier</a>

                        <a onclick="return confirm('Supprimer?')" href="{{ URL::route('admin_journal_delete', $journal->id) }}" class="btn-danger">Supprimer</a>

                    @endif                      
                </td>


            </tr>

<?php $total_hours = $total_hours + $hours_differ; ?>

@endforeach

        </tbody>
    </table>


<br>

<table style="width: 50%" class="table table-border">
    <thead>
    <tr>
        <th style="width: 50%; text-transform: uppercase;">total heures :</th>
        <th style="width: 50%"><?php echo convertToHoursMins($total_hours, '%02d heures %02d minutes'); ?></th>
    </tr>
    </thead>
</table>

@endif


@endforeach

@endif

</div>

</body>
</html>