@extends('layouts.master_panel')

@section('title') Modifier @stop

@section('CSS') 


<link rel="stylesheet" type="text/css" href="{{url('/')}}/js/datatables/dataTables.bootstrap4.min.css">

<link rel="stylesheet" href="{{url('/')}}/assets/vendor/datepicker/tempusdominus-bootstrap-4.css" />

<link rel="stylesheet" href="{{url('/')}}/assets/vendor/summernote/css/summernote-bs4.css">

@stop


@section('content')


                  <!-- ============================================================== -->
                  <!-- pageheader  -->
                  <!-- ============================================================== -->
                  <div class="row">
                      <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                          <div class="page-header">
                              <h3 class="mb-2">Modifier </h3>
                           
                              <div class="page-breadcrumb">
                                  <nav aria-label="breadcrumb">
                                      <ol class="breadcrumb">
                                          <li class="breadcrumb-item active" aria-current="page">Modifier</li>
                                      </ol>
                                  </nav>
                              </div>
                          </div>
                      </div>
                  </div>
                  <!-- ============================================================== -->
                  <!-- end pageheader  -->
                  <!-- ============================================================== -->


<div class="row">


<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
  <div class="card">
  <div class="card-body">


<div class="clearfix"></div>

@if(Session::has('error'))

<div class="alert alert-danger alert-dismissible fade show text-center" role="alert">
  <strong>{{ Session::get('error') }}</strong>
  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
    <span aria-hidden="true">&times;</span>
  </button>
</div>

@endif

@if(Session::has('success'))
<div class="alert alert-success alert-dismissible fade show text-center" role="alert">
  <strong>{{ Session::get('success') }}</strong>
  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
    <span aria-hidden="true">&times;</span>
  </button>
</div>
@endif

<div class="clearfix"></div>


<form method="POST" action="{{ URL::route('admin_journal_update', $journal->id) }}" >

{{ csrf_field() }}


<?php 
$getSubject = \App\Subjects::find($journal->subject_id);
$getclass = \App\Classes::find($journal->class_id);
 ?>

<div class="form-row">

  <div class="col-md-12 mb-3">
      <label>Matières / Classes</label>
      <select name="subject_id" class="selectpicker" data-width="100%" required="required">   
      
      <option value="{{ $journal->id }}">{{ $getSubject->name }} ({{ $getclass->name }})</option>

      </select>
  </div>

  <div class="col-md-12 mb-3">
    <label>Date:</label>
    <div class="form-group">
    <div class="input-group date" id="datetimepickerdate" data-target-input="nearest">

    <input name="date" type="text" class="form-control datetimepicker-input" data-target="#datetimepickerdate" required="required" value="{{ $journal->date }}" />
    
      <div class="input-group-append" data-target="#datetimepickerdate" data-toggle="datetimepicker">
      <div class="input-group-text"><i class="far fa-calendar-alt"></i></div>
      </div>
    </div>
  </div>
  </div>


<?php $horaires1 = \App\Horaires::where('periode', 1)->orderBy('hour_id', 'ASC')->get(); ?>
<?php $horaires2 = \App\Horaires::where('periode', 2)->orderBy('hour_id', 'ASC')->get(); ?>

<div class="col-md-12 mb-4">
    <label>Heure début - Heure fin:</label>
    <select name="seance_heures" id="nombre_heures" class="selectpicker" data-width="100%"  required="required">

    <option selected="selected" value="{{ $journal->hour_start }} - {{ $journal->hour_end }}">{{ $journal->hour_start }} - {{ $journal->hour_end }}</option>

<optgroup label="Matin">
      @foreach($horaires1 as $horair1)
        <option value="{{ $horair1->entry_time }} - {{ $horair1->exit_time }}">{{ $horair1->entry_time }} - {{ $horair1->exit_time }}</option>
      @endforeach
</optgroup>

<optgroup label="Après-midi">
      @foreach($horaires2 as $horair2)
        <option value="{{ $horair2->entry_time }} - {{ $horair2->exit_time }}">{{ $horair2->entry_time }} - {{ $horair2->exit_time }}</option>
      @endforeach
</optgroup>

     </select>
</div>


  <div class="col-md-12 mb-3">
    <label>détails:</label>
    <textarea name="details" id="summernote" class="form-control" required="required"><?php echo html_entity_decode($journal->details); ?></textarea>
  </div>


 
</div>

<div class="form-row">
<div class="col-md-12">
    <button class="btn btn-success btn-block" type="submit">Modifier</button>
</div>
</div>

</form>


    </div>
  </div>
</div>

                                     

</div><!-- END row -->
                
               


@section('JS') 


<script src="{{url('/')}}/js/datatables/jquery.dataTables.min.js"></script>
<script src="{{url('/')}}/js/datatables/dataTables.bootstrap4.min.js"></script>

<script type="text/javascript" class="init">
  $(document).ready(function() {
    $("#example").dataTable({ "language": { "url": "{{ url('/') }}/js/datatables/lang/fr.json" },
      "order": [[ 0, "desc" ]]
    });
  });
  </script>


<script src="{{url('/')}}/assets/vendor/datepicker/moment.js"></script>
<script src="{{url('/')}}/assets/vendor/datepicker/tempusdominus-bootstrap-4.js"></script>
<script src="{{url('/')}}/assets/vendor/datepicker/datepicker.js"></script>

<script src="{{url('/')}}/assets/vendor/datepicker/fr.js"></script>

<script type="text/javascript">
    $(function () {
        $('#datetimepickerdate').datetimepicker({
          format: 'DD/MM/YYYY',
          locale: 'fr'
      });
    });

    $(function () {
        $('#datetimepickerdate2').datetimepicker({
          format: 'DD/MM/YYYY',
          locale: 'fr'
      });
    });

    $(function () {
        $('#datetimepickerdateImp').datetimepicker({
          format: 'DD/MM/YYYY',
          locale: 'fr'
      });
    });

    $(function () {
        $('#datetimepickerdateImp2').datetimepicker({
          format: 'DD/MM/YYYY',
          locale: 'fr'
      });
    });

    $(function () {
        $('#datetimepickerdateHon').datetimepicker({
          format: 'DD/MM/YYYY',
          locale: 'fr'
      });
    });

    $(function () {
        $('#datetimepickerdateHon2').datetimepicker({
          format: 'DD/MM/YYYY',
          locale: 'fr'
      });
    });

</script>


<script src="{{url('/')}}/assets/vendor/summernote/js/summernote-bs4.js"></script>

<script>
    $(document).ready(function() {
        $('#summernote').summernote({
            height: 150

        });
    });
</script>


<script type="text/javascript">
document.getElementById('mybutton').addEventListener('click', function(){
  window.open('{{ URL::route('journal_historique') }}', 'result', 'width=980,height=720');
  document.getElementById('myform').submit();
});
</script>




@stop




@stop