<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App;
use View;
use Hash;
use Redirect;
use Validator;
use Response;
use Auth;
use Illuminate\Validation\Rule;
use App\User;
use App\Settings;

use App\AcademicYear;
use App\Horaires;
use App\AssiduiteMotifs;

use App\DocumentsNames;

use App\PersonnelCatg;

use Excel;

use App\Imports\UsersUpdate;

use Illuminate\Support\Facades\DB;

class SettingsController extends Controller
{



    public function __construct()
    {
    //    $this->middleware('auth');
    }




    public function settings()
    {   

        $settings = Settings::find(1);
        $year = AcademicYear::find($settings->default_year);
        $horaires = Horaires::orderBy('id', 'desc')->get();

        $assiduite_motifs = AssiduiteMotifs::orderBy('id', 'desc')->get();

        $personnel_type = PersonnelCatg::orderBy('id', 'desc')->get();

        $documents_names = DocumentsNames::orderBy('id', 'desc')->get();

        return View::make('admin.settings', compact('settings', 'year', 'horaires', 'assiduite_motifs', 'personnel_type', 'documents_names'));
            
    }


    public function users_mass_update(Request $request)
    {   
        
        $inputs = $request->all();


        $validation = Validator::make($inputs, [
            'type_update'=>'required',
            'fichier_excel'=>'required',
        ]); 

            if ($validation->fails()) {

                return Redirect::back()->withInput()->withErrors($validation);

            } 

            else {

            $whitelist = array("xlsx","xls","XLS","XLSX");

            if ($request->hasFile('fichier_excel')) {

                if (!(in_array($request->file('fichier_excel')->extension(), $whitelist))) {
                    return Redirect::back()->withInput()->withError('Extension non autorisée');
                    die();
                } else {

                    $import = new UsersUpdate();

                    Excel::import($import, request()->file('fichier_excel'));

                }

            } 


            return Redirect::back()->withSuccess('Importé avec succèss');

            }

    }


    public function academic_year(Request $request)
    {  
        $inputs = $request->all();
        
        $validation = Validator::make($inputs, [
            'academic_year'=>'required',
        ]);

        if ($validation->fails()) { 
            return Redirect::back()->withErrors($validation);
        } else {

            $year = AcademicYear::find(1);

            $year->name = e($inputs['academic_year']);
            $year->save();

            return Redirect::back()->withSuccess('Mise à jour avec succès');
                

        }


    }



    public function pointage_password(Request $request)
    {  
        $inputs = $request->all();
        
        $validation = Validator::make($inputs, [
            'pointage_password'=>'required',
        ]);

        if ($validation->fails()) { 
            return Redirect::back()->withErrors($validation);
        } else {

            $settings = Settings::find(1);

            $settings->pointage_password = e($inputs['pointage_password']);
            $settings->save();

            return Redirect::back()->withSuccess('Mise à jour avec succès');
                

        }


    }


    public function pointage_checkpassword(Request $request)
    {  
        $inputs = $request->all();
        
        $validation = Validator::make($inputs, [
            'pointage_password'=>'required',
        ]);

        if ($validation->fails()) { 
            return Redirect::back()->withErrors($validation);
        } else {

            $settings = Settings::find(1);

            if ($settings->pointage_password == e($inputs['pointage_password'])) {
                
                $key_round = round(microtime(true)); 
                \Session::put("pointagePASSWORD", $key_round);

                return Redirect::route('pointage');

            }

        
            return Redirect::back()->withError('Mot de passe incorrect.');
                

        }


    }




    public function administrateur_update(Request $request)
    {   

        $user = User::find(Auth::user()->id);

        $inputs = $request->all();

        $validation = Validator::make($inputs, [
            'old_password'=>'required', 
            'email' => [ 'required', Rule::unique('users')->ignore($user->id),],
            'password'=>'required|min:4', 
            'password_confirm'=>'required|same:password'
        ]);


        if ($validation->fails()) {

            return Redirect::back()->withErrors($validation);

        } else {

            $old_password = $inputs['old_password'];

            if (Hash::check($old_password, $user->password)) {
                
                $user->password = Hash::make($inputs['password']);
                $user->email = $inputs['email'];
                $user->save();

                return Redirect::back()->withSuccess('Mise à jour avec succès');
                
            } else { return Redirect::back()->withError('Mot de passe incorrect.');  }

        }



    }

/*****************

Horaires

****************/

    public function horaires_store(Request $request)
    {   
        
        $inputs = $request->all();


        $validation = Validator::make($inputs, [
          'entry_time'=>'required',
          'exit_time'=>'required',
        ]); 

            if ($validation->fails()) {
                return 'false';
            } 

            else {

            if (preg_match("/^(?:2[0-3]|[01][0-9]):[0-5][0-9]$/", $inputs['entry_time']) AND preg_match("/^(?:2[0-3]|[01][0-9]):[0-5][0-9]$/", $inputs['exit_time'])) {

                $Horaire = Horaires::create([

                    'hour_id' => e($inputs['hour_id']),
                    'entry_time' => e($inputs['entry_time']),
                    'exit_time' => e($inputs['exit_time']),

                ]);

                $Horaire->save();

                return 'true';

            } else {
                 return 'false';
            }

            

            }

    }

    public function horaire_update($id, Request $request)
    {   
        
        $inputs = $request->all();

        $Horaire = Horaires::find(e($id));

        if ($Horaire !== null) {

            if (preg_match("/^(?:2[0-3]|[01][0-9]):[0-5][0-9]$/", $inputs['entry_time_up']) AND preg_match("/^(?:2[0-3]|[01][0-9]):[0-5][0-9]$/", $inputs['exit_time_up'])) {

                $Horaire->hour_id = e($inputs['hour_id_up']);
                $Horaire->entry_time = e($inputs['entry_time_up']);
                $Horaire->exit_time = e($inputs['exit_time_up']);
                $Horaire->save();
        
                return Redirect::back()->withSuccess('Modifier avec succès');
            }

        }



    }


    public function horaire_delete($id)
    {   
        $Horaire = Horaires::find(e($id));

        if ($Horaire !== null) {

            $Horaire->delete();
    
            return Redirect::back()->withError('Supprimé avec succès');
            
           
        } else {
            return View::make('404');
        }
        
    }




/*****************

assiduite motifs

****************/

    public function assiduite_motifs_store(Request $request)
    {   
        
        $inputs = $request->all();


        $validation = Validator::make($inputs, [
          'motif'=>'required',
        ]); 

            if ($validation->fails()) {
                return 'false';
            } 

            else { 

                $motif = AssiduiteMotifs::create([
                    'motif' => htmlspecialchars($inputs['motif']),
                ]);

                $motif->save();

                return 'true';

            }

    }

    public function assiduite_motifs_update($id, Request $request)
    {   
        
        $inputs = $request->all();

        $motif = AssiduiteMotifs::find(e($id));

        if ($motif !== null) {

                $motif->motif = htmlspecialchars($inputs['motif_up']);
                $motif->save();
        
                return Redirect::back()->withSuccess('Modifier avec succès');

        }



    }


    public function assiduite_motifs_delete($id)
    {   
        $motif = AssiduiteMotifs::find(e($id));

        if ($motif !== null) {

            $motif->delete();
    
            return Redirect::back()->withError('Supprimé avec succès');
            
           
        } else {
            return View::make('404');
        }
        
    }






/*****************

PersonnelCatg

****************/

    public function personnel_type_store(Request $request)
    {   
        
        $inputs = $request->all();


        $validation = Validator::make($inputs, [
          'catg'=>'required',
        ]); 

            if ($validation->fails()) {
                return 'false';
            } 

            else { 

                $catg = PersonnelCatg::create([
                    'catg' => htmlspecialchars($inputs['catg']),
                ]);

                $catg->save();

                return 'true';

            }

    }

    public function personnel_type_update($id, Request $request)
    {   
        
        $inputs = $request->all();

        $catg = PersonnelCatg::find(e($id));

        if ($catg !== null) {

                $catg->catg = htmlspecialchars($inputs['catg_up']);
                $catg->save();
        
                return Redirect::back()->withSuccess('Modifier avec succès');

        }



    }


    public function personnel_type_delete($id)
    {   
        $catg = PersonnelCatg::find(e($id));

        if ($catg !== null) {

            $catg->delete();
    
            return Redirect::back()->withError('Supprimé avec succès');
            
           
        } else {
            return View::make('404');
        }
        
    }




/*****************

documents request

****************/

    public function documents_request_store(Request $request)
    {   
        
        $inputs = $request->all();


        $validation = Validator::make($inputs, [
          'doc_name'=>'required',
        ]); 

            if ($validation->fails()) {
                return 'false';
            } 

            else { 

                $store = DocumentsNames::create([
                    'name' => htmlentities($inputs['doc_name']),
                ]);

                $store->save();

                return 'true';

            }

    }

    public function documents_request_update($id, Request $request)
    {   
        
        $inputs = $request->all();

        $docs = DocumentsNames::find(e($id));

        if ($docs !== null) {

                $docs->name = htmlentities($inputs['doc_name_up']);
                $docs->save();
        
                return Redirect::back()->withSuccess('Modifier avec succès');

        }



    }


    public function documents_request_delete($id)
    {   
        $docs = DocumentsNames::find(e($id));

        if ($docs !== null) {

            $docs->delete();
    
            return Redirect::back()->withError('Supprimé avec succès');
            
           
        } else {
            return View::make('404');
        }
        
    }






   


}