

<?php $__env->startSection('title'); ?> Simili <?php $__env->stopSection(); ?>

<?php $__env->startSection('CSS'); ?> 


<link rel="stylesheet" type="text/css" href="<?php echo e(url('/')); ?>/js/datatables/dataTables.bootstrap4.min.css">

<link rel="stylesheet" href="<?php echo e(url('/')); ?>/assets/vendor/datepicker/tempusdominus-bootstrap-4.css" />


<?php $__env->stopSection(); ?>

<?php $__env->startSection('JS'); ?> 


<script src="<?php echo e(url('/')); ?>/js/datatables/jquery.dataTables.min.js"></script>
<script src="<?php echo e(url('/')); ?>/js/datatables/dataTables.bootstrap4.min.js"></script>

<script type="text/javascript" class="init">
  $(document).ready(function() {
    $("#example").dataTable({ "language": { "url": "<?php echo e(url('/')); ?>/js/datatables/lang/fr.json" },
      "order": [[ 0, "desc" ]]
    });
  });
  </script>


<script src="<?php echo e(url('/')); ?>/assets/vendor/datepicker/moment.js"></script>
<script src="<?php echo e(url('/')); ?>/assets/vendor/datepicker/tempusdominus-bootstrap-4.js"></script>
<script src="<?php echo e(url('/')); ?>/assets/vendor/datepicker/datepicker.js"></script>

<script src="<?php echo e(url('/')); ?>/assets/vendor/datepicker/fr.js"></script>

<script type="text/javascript">
    $(function () {
        $('#datetimepickerdate').datetimepicker({
          format: 'DD/MM/YYYY',
          locale: 'fr'
      });
    });

</script>



<script type="text/javascript">
$(document).ready(function () { 

  $('.donebox').change(function() {

      var id = this.id;
      var idSplit = id.split("-");

      if(this.checked) {
        $('#is_absent'+idSplit[1]).val('1');
      } else {
        $('#is_absent'+idSplit[1]).val('0'); 
      } 
  
  });


});
</script>


<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>


                  <!-- ============================================================== -->
                  <!-- pageheader  -->
                  <!-- ============================================================== -->
                  <div class="row">
                      <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                          <div class="page-header">
                              <h3 class="mb-2">Simili </h3>
                           
                              <div class="page-breadcrumb">
                                  <nav aria-label="breadcrumb">
                                      <ol class="breadcrumb">
                                          <li class="breadcrumb-item active" aria-current="page">Simili  </li>
                                      </ol>
                                  </nav>
                              </div>
                          </div>
                      </div>
                  </div>
                  <!-- ============================================================== -->
                  <!-- end pageheader  -->
                  <!-- ============================================================== -->


<div class="row">

<div class="col-md-12">
<?php if(Session::has('error')): ?>

<div class="alert alert-danger alert-dismissible fade show text-center" role="alert">
  <strong><?php echo e(Session::get('error')); ?></strong>
  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
    <span aria-hidden="true">&times;</span>
  </button>
</div>

<?php endif; ?>

<?php if(Session::has('success')): ?>
<div class="alert alert-success alert-dismissible fade show text-center" role="alert">
  <strong><?php echo e(Session::get('success')); ?></strong>
  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
    <span aria-hidden="true">&times;</span>
  </button>
</div>
<?php endif; ?>
</div>
<div class="clearfix"></div>


<?php if(isset($_GET['subject_id'])): ?>

<?php 

$GetSubject = \App\Subjects::find(e($_GET['subject_id']));

if ($GetSubject !== null) {

  $students = \App\User::where('is_student', true)->where('class_id', $GetSubject->class_id)->orderBy('last_name', 'asc')->get();

  $GetClass = \App\Classes::find($GetSubject->class_id);

 ?>

<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
  <div class="card">
  <h5 class="card-header">Simili Évaluations</h5>
  <div class="card-body">

<h4><strong>Classe et Matière:</strong> <?php echo e($GetClass->name); ?> - <?php echo e($GetSubject->name); ?></h4>
<h4><strong>Note Sur:</strong> /<?php echo e(e($_GET['note_sur'])); ?></h4>
<h4><strong>Date:</strong> <?php echo e(e($_GET['date'])); ?></h4>
<div class="clearfix"></div><hr>


<form method="POST" action="<?php echo e(URL::route('simili_evaluations_store')); ?>" class="form-row">

 <?php echo csrf_field(); ?> 


<input type="hidden" name="subject_id" value="<?php echo e($GetSubject->id); ?>">
<input type="hidden" name="class_id" value="<?php echo e($GetSubject->class_id); ?>">
<input type="hidden" name="note_sur" value="<?php echo e(e($_GET['note_sur'])); ?>">
<input type="hidden" name="date" value="<?php echo e(e($_GET['date'])); ?>">

      <div class="table-responsive">
          <table class="table table-striped table-bordered first">
            <thead>
            <tr class="text-uppercase">
              <th>Nom et Prénom</th>
              <th>Absent(e)</th>
              <th>Note /<?php echo e(e($_GET['note_sur'])); ?></th>
              <th>état</th>
            </tr>
            </thead>
            <tbody>

<?php $__currentLoopData = $students; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $student): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

<tr>         

                  <td>
                    <?php echo e($student->last_name . ' ' . $student->first_name); ?> 
                    <input type="hidden" name="student_ids[]" value="<?php echo e($student->id); ?>">
                  </td>

                    <td>
                        <div class="checkbox">
                          <label>
                            <input type="checkbox" class="donebox" id="boxIsdone-<?php echo e($student->id); ?>" > Absent(e)
                          </label>
                        </div>
                        <input type="hidden" name="is_absent[]" value="0" id="is_absent<?php echo e($student->id); ?>">
                    </td>

                  

                  <td>
                    <input type="text" name="note[]" class="form-control" value=""> 
                  </td>

                  <td>
                    <i class="fa fa-hourglass text-warning" style="font-size: 26px;"></i>
                  </td>


</tr>



<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

              </tbody>
            </table>
        </div>


<div class="col-md-12 mt-3 mb-3">
    <button class="btn btn-success btn-lg btn-block" type="submit">Valider</button>
</div>

</form>





  </div>
  </div>
</div>

<?php } // END if $GetSubject !== null ?>





<?php elseif(isset($_GET['simili_id'])): ?>

<?php 

$GetSimili = \App\Simili::find(e($_GET['simili_id']));

if ($GetSimili !== null) {

  $students = \App\User::where('is_student', true)->where('class_id', $GetSimili->class_id)->orderBy('last_name', 'asc')->get();

 ?>

<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
  <div class="card">
  <h5 class="card-header">Simili Évaluations</h5>
  <div class="card-body">

<h4><strong>Classe et Matière:</strong> <?php echo e($GetSimili->classe->name); ?> - <?php echo e($GetSimili->subject->name); ?></h4>

<h4><strong>Note Sur:</strong> /<?php echo e($GetSimili->note_sur); ?></h4>

<?php $enTofr1 = DateTime::createFromFormat('Y-m-d', substr($GetSimili->date, 0, 10)); ?>

<h4><strong>Date:</strong> <?php echo e($enTofr1->format('d/m/Y')); ?></h4>
<div class="clearfix"></div><hr>


<?php if(auth()->user()->is_teacher == 1): ?>

<form method="POST" action="<?php echo e(URL::route('simili_evaluations_update', $GetSimili->id)); ?>" class="form-row">

<?php echo csrf_field(); ?> 

<?php endif; ?>

      <div class="table-responsive">
          <table class="table table-striped table-bordered first">
            <thead>
            <tr class="text-uppercase">
              <th>Nom et Prénom</th>
              <th>Absent(e)</th>
              <th>Note /<?php echo e($GetSimili->note_sur); ?></th>
              <th>état</th>
            </tr>
            </thead>
            <tbody>

<?php $__currentLoopData = $students; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $student): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

<?php 

$student_evaluations = \App\SimiliEvaluations::where('student_id', $student->id)->where('simili_id', $GetSimili->id)->first();

 ?>

<?php if($student_evaluations !== null): ?>
<tr>         

                    <td>
                      <?php echo e($student->last_name . ' ' . $student->first_name); ?> 
                      <input type="hidden" name="student_ids[]" value="<?php echo e($student->id); ?>">
                    </td>

                    <td>
                      <?php if($student_evaluations->is_absent == 1): ?>
                        <div class="checkbox">
                          <label>
                            <input type="checkbox" class="donebox" id="boxIsdone-<?php echo e($student->id); ?>" checked="checked"> Absent(e)
                          </label>
                        </div>
                        <input type="hidden" name="is_absent[]" value="1" id="is_absent<?php echo e($student->id); ?>">
                      <?php else: ?>
                        <div class="checkbox">
                          <label>
                            <input type="checkbox" class="donebox" id="boxIsdone-<?php echo e($student->id); ?>"> Absent(e)
                          </label>
                        </div>
                        <input type="hidden" name="is_absent[]" value="0" id="is_absent<?php echo e($student->id); ?>">
                      <?php endif; ?>   
                    </td>

                 

                  <td>
                    <input type="text" name="note[]" class="form-control" value="<?php echo e($student_evaluations->note); ?>"> 
                  </td>

                  <td>
                    <i class="fa fa-check-circle text-success" style="font-size: 20px;"></i> <?php $enTofr = DateTime::createFromFormat('Y-m-d H:i', substr($student_evaluations->updated_at, 0, 16)); echo $enTofr->format('d/m/Y H:i'); ?>

                  </td>



</tr>
<?php endif; ?>


<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

              </tbody>
            </table>
        </div>


<?php if(auth()->user()->is_teacher == 1): ?>

<div class="col-md-12 mt-3 mb-3">
    <button class="btn btn-success btn-lg btn-block" type="submit">Valider</button>
</div>

</form>

<?php endif; ?>



  </div>
  </div>
</div>

<?php } // END if $GetSimili !== null ?>


<?php else: ?>

<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
  <div class="card">

<?php if(auth()->user()->is_teacher == 1): ?>
    <h5 class="card-header">
      <a href="#" class="btn btn-primary mb-1" data-toggle="modal" data-target="#exampleModal"><i class="fa fa-plus"></i> Ajouter </a>
    </h5>
<?php endif; ?>

  <div class="card-body">

<?php if(auth()->user()->is_teacher == 1): ?>

<!-- Modal -->
<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
<div class="modal-dialog modal-lg" role="document">
  <div class="modal-content">
    <div class="modal-header">
      <h5 class="modal-title" id="exampleModalLabel">Ajouter</h5>
      <a href="#" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></a>
    </div>
    <div class="modal-body">

<form method="GET" action="<?php echo e(URL::route('enseignant_evaluations_simili')); ?>" >


<div class="form-row">

<div class="col-md-12 mb-3">
      <label>Matières / Classes</label>
      <select name="subject_id" class="selectpicker" data-width="100%" required="required">   
      <option value="">Choisir</option>
        <?php $__currentLoopData = $subjects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subject): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

        <?php $getclass = \App\Classes::find($subject->class_id); ?>

          <option value="<?php echo e($subject->id); ?>"><?php echo e($subject->name); ?> (<?php echo e($getclass->name); ?>)</option>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      </select>
  </div>


  <div class="col-md-12 mb-3">
    <label>Date:</label>
    <div class="form-group">
    <div class="input-group date" id="datetimepickerdate" data-target-input="nearest">

    <input name="date" type="text" class="form-control datetimepicker-input" data-target="#datetimepickerdate" required="required" value="<?php echo e(date('d/m/Y')); ?>" />
    
      <div class="input-group-append" data-target="#datetimepickerdate" data-toggle="datetimepicker">
      <div class="input-group-text"><i class="far fa-calendar-alt"></i></div>
      </div>
    </div>
  </div>
  </div>

<div class="col-md-12 mb-3">
    <label>Note sur:</label>
    <select name="note_sur" class="selectpicker" data-width="100%" required="required">
    <option value="10">/10</option>
    <option value="20">/20</option>
    <option value="40">/40</option>
    </select>
</div>


 
</div>

<div class="form-row mt-1">
<div class="col-md-12">
    <button class="btn btn-success btn-block" type="submit">Ajouter</button>
</div>
</div>

</form>

    </div>
    <div class="modal-footer">
      <a href="#" class="btn btn-dark" data-dismiss="modal">Fermer</a>
    </div>
  </div>
</div>
</div>
<!-- End Modal -->

<?php endif; ?>

<div class="clearfix"></div>



      <div class="table-responsive">
          <table id="example" class="table table-striped table-bordered first">
            <thead>
            <tr class="text-uppercase">
              <th style="display: none;"></th>
              <th>Classe/Matière</th>
              <?php if(auth()->user()->is_teacher !== 1): ?>
              <th>Enseignant</th>
              <?php endif; ?>
              <th>Date</th>
              <th>Action</th>
            </tr>
            </thead>
            <tbody>

             <?php $__currentLoopData = $similis; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $simil): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>

                  <td style="display: none;"><?php echo e($simil->id); ?></td>
                  
                                    
                  <td>
                    <?php echo e($simil->classe->name); ?> - <?php echo e($simil->subject->name); ?> 
                  </td>


                  <?php if(auth()->user()->is_teacher !== 1): ?>

                  <td><?php echo e($simil->teacher->last_name . ' ' . $simil->teacher->first_name); ?></td>
                  
                  <?php endif; ?>

                  <td>
                    <?php $enTofr1 = DateTime::createFromFormat('Y-m-d', substr($simil->date, 0, 10)); echo $enTofr1->format('d/m/Y') ?>
                  </td>


                      <td>

                        <a class="btn btn-success btn-sm" href="<?php echo e(URL::route('enseignant_evaluations_simili')); ?>?simili_id=<?php echo e($simil->id); ?>"><i class="fa fa-list"></i> Évaluations</a>

<?php if(auth()->user()->super_admin == 1 OR auth()->user()->is_teacher == 1): ?>
                      
                        <a onclick="return confirm('Supprimer?')" href="<?php echo e(URL::route('enseignant_destroy_simili', $simil->id)); ?>" class="btn btn-danger btn-sm"><i class="fa fa-trash"></i>  </a>
<?php endif; ?>                

                      </td>

                    </tr>

                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                  </tbody>
                  </table>
               </div>

    </div>
  </div>
</div>

                                     
<?php endif; ?>

</div><!-- END row -->
                
               

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master_panel', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/verdin/pedagogie.verdin.ma/resources/views/enseignants/simili.blade.php ENDPATH**/ ?>