<!doctype html>
<html lang="fr">
 
<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    
    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    
    <title>Se connecter</title>
    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="<?php echo e(url('/')); ?>/assets/vendor/bootstrap/css/bootstrap.min.css">
    <link href="<?php echo e(url('/')); ?>/assets/vendor/fonts/circular-std/style.css" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo e(url('/')); ?>/assets/libs/css/style.css">
    <link rel="stylesheet" href="<?php echo e(url('/')); ?>/assets/vendor/fonts/fontawesome/css/fontawesome-all.css">
    <style>
    html,
    body {
        height: 100%;
    }

    body {
        display: -ms-flexbox;
        display: flex;
        -ms-flex-align: center;
        align-items: center;
        padding-top: 40px;
        padding-bottom: 40px;
    }
    </style>
</head>

<body>
    <!-- ============================================================== -->
    <!-- login page  -->
    <!-- ============================================================== -->
    <div class="splash-container">

<?php /* ?>
<div class="alert alert-info alert-dismissible fade show text-center" role="alert">
  <strong>Afin d’améliorer notre service, le site est momentanément indisponible.
Veuillez nous excuser pour la gêne occasionnée.</strong>
</div>

<?php */ ?>

        <div class="card ">
            <div class="card-header text-center"><a href="#"><img class="logo-img img-fluid" width="100px" src="<?php echo e(url('/')); ?>/assets/images/logo2.png" alt="Groupe Scolaire Verdin"></a></div>
            <div class="card-body">


<?php if(Session::has('error')): ?>

<div class="alert alert-danger alert-dismissible fade show text-center" role="alert">
  <strong><?php echo e(Session::get('error')); ?></strong>
  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
    <span aria-hidden="true">&times;</span>
  </button>
</div>

<?php endif; ?>

<?php if(Session::has('success')): ?>
<div class="alert alert-success alert-dismissible fade show text-center" role="alert">
  <strong><?php echo e(Session::get('success')); ?></strong>
  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
    <span aria-hidden="true">&times;</span>
  </button>
</div>
<?php endif; ?>

<div class="clearfix"></div>              


<?php 

if (Request()->referrer) {
    $referrerURL = Request()->referrer;
} else {
   $referrerURL = '';
}
//echo url($referrerURL);

 ?>


<form method="POST" action="<?php echo e(URL::route('login_check')); ?>">

<?php echo csrf_field(); ?>

<input type="hidden" name="referrer_url" value="<?php echo e($referrerURL); ?>">


                    <label>Login:</label>
                    <div class="form-group">
                        <input name="username" class="form-control form-control-lg" id="username" type="text"  autocomplete="off">
                    </div>

                    <label>Mot de passe:</label>
                    <div class="form-group">
                        <div class="input-group">
                        <div class="input-group-prepend reveal"><span class="input-group-text"><i class="fa fa-eye"></i></span></div>
                        <input name="password" class="form-control form-control-lg pwd" id="password" type="password">
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="custom-control custom-checkbox">
                            <input name="remember" class="custom-control-input" type="checkbox"><span class="custom-control-label">Se Souvenir de moi </span>
                        </label>
                    </div>
                    <button type="submit" class="btn btn-primary btn-lg btn-block">Se connecter</button>
                </form>
            </div>
            <div class="card-footer bg-white p-0  ">

                <div class="card-footer-item card-footer-item-bordered">
                    <a href="#" class="footer-link">Mot de passe oublié</a>
                </div>
            </div>
        </div>

        
    </div>

  
    <!-- ============================================================== -->
    <!-- end login page  -->
    <!-- ============================================================== -->
    <!-- Optional JavaScript -->
    <script src="<?php echo e(url('/')); ?>/assets/vendor/jquery/jquery-3.3.1.min.js"></script>
    <script src="<?php echo e(url('/')); ?>/assets/vendor/bootstrap/js/bootstrap.bundle.js"></script>
<script type="text/javascript">
$(".reveal").on('click',function() {
    var $pwd = $(".pwd");
    if ($pwd.attr('type') === 'password') {
        $pwd.attr('type', 'text');
    } else {
        $pwd.attr('type', 'password');
    }
});
</script>

</body>
 
</html><?php /**PATH /home/verdin/pedagogie.verdin.ma/resources/views/login.blade.php ENDPATH**/ ?>