

<?php $__env->startSection('title'); ?> طلب الوثائق <?php $__env->stopSection(); ?>

<?php $__env->startSection('CSS'); ?> 


<link rel="stylesheet" type="text/css" href="<?php echo e(url('/')); ?>/js/datatables/dataTables.bootstrap4.min.css">

<link rel="stylesheet" href="<?php echo e(url('/')); ?>/assets/vendor/datepicker/tempusdominus-bootstrap-4.css" />

<link rel="stylesheet" href="<?php echo e(url('/')); ?>/assets/vendor/summernote/css/summernote-bs4.css">

<?php $__env->stopSection(); ?>

<?php $__env->startSection('JS'); ?> 


<script src="<?php echo e(url('/')); ?>/js/datatables/jquery.dataTables.min.js"></script>
<script src="<?php echo e(url('/')); ?>/js/datatables/dataTables.bootstrap4.min.js"></script>

<script type="text/javascript" class="init">
  $(document).ready(function() {
    $("#example").dataTable({ "language": { "url": "<?php echo e(url('/')); ?>/js/datatables/lang/fr.json" },
      "order": [[ 0, "desc" ]]
    });
  });
  </script>


<script src="<?php echo e(url('/')); ?>/assets/vendor/datepicker/moment.js"></script>
<script src="<?php echo e(url('/')); ?>/assets/vendor/datepicker/tempusdominus-bootstrap-4.js"></script>
<script src="<?php echo e(url('/')); ?>/assets/vendor/datepicker/datepicker.js"></script>

<script src="<?php echo e(url('/')); ?>/assets/vendor/datepicker/fr.js"></script>

<script type="text/javascript">
    $(function () {
        $('#datetimepickerdateONE').datetimepicker({
          format: 'DD/M/YYYY',
          locale: 'fr'
      });
    });

</script>



<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>


                  <!-- ============================================================== -->
                  <!-- pageheader  -->
                  <!-- ============================================================== -->
                  <div class="row">
                      <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                          <div class="page-header">
                            
                            <?php if(auth()->user()->is_admin == true): ?>
                              
                              <h3 class="mb-2">طلبات الوثائق</h3>
                           
                              <div class="page-breadcrumb">
                                  <nav aria-label="breadcrumb">
                                      <ol class="breadcrumb">
                                          <li class="breadcrumb-item active" aria-current="page">طلبات الوثائق</li>
                                      </ol>
                                  </nav>
                              </div>
                            
                            <?php else: ?>

                              <h3 class="mb-2">طلب الوثائق </h3>
                           
                              <div class="page-breadcrumb">
                                  <nav aria-label="breadcrumb">
                                      <ol class="breadcrumb">
                                          <li class="breadcrumb-item active" aria-current="page">طلب الوثائق </li>
                                      </ol>
                                  </nav>
                              </div>

                            <?php endif; ?>

                          </div>
                      </div>
                  </div>
                  <!-- ============================================================== -->
                  <!-- end pageheader  -->
                  <!-- ============================================================== -->


<div class="row">


<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
  <div class="card">

<?php if(auth()->user()->is_teacher == true): ?>
    <h5 class="card-header">
      <a href="#" class="btn btn-primary mb-1" data-toggle="modal" data-target="#exampleModal"><i class="fa fa-plus"></i> Demande</a>
    </h5>
<?php endif; ?>
  <div class="card-body">

<?php if(auth()->user()->is_teacher == true): ?>
<!-- Modal -->
<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
<div class="modal-dialog modal-lg" role="document">
  <div class="modal-content">
    <div class="modal-header">
      <h5 class="modal-title" id="exampleModalLabel">Demande</h5>
      <a href="#" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></a>
    </div>
    <div class="modal-body">

<form method="POST" action="<?php echo e(URL::route('demandes_documents_store')); ?>" >

<?php echo e(csrf_field()); ?>



<div class="form-row">



<div class="col-md-12 mb-3">
      <label>Documents:</label>
      <select name="doc_name" class="selectpicker" data-width="100%" required="required" title="Choisir">   
      <?php $__currentLoopData = $docs_names; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $doc_name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <option value="<?php echo e(html_entity_decode($doc_name->name)); ?>"><?php echo e(html_entity_decode($doc_name->name)); ?></option>
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      </select>
  </div>

 
</div>

<div class="form-row mt-1">
<div class="col-md-12">
    <button class="btn btn-success btn-block" type="submit">Demande</button>
</div>
</div>

</form>

    </div>
    <div class="modal-footer">
      <a href="#" class="btn btn-dark" data-dismiss="modal">Fermer</a>
    </div>
  </div>
</div>
</div>
<!-- End Modal -->
<?php endif; ?>


<div class="clearfix"></div>

<?php if(Session::has('error')): ?>

<div class="alert alert-danger alert-dismissible fade show text-center" role="alert">
  <strong><?php echo e(Session::get('error')); ?></strong>
  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
    <span aria-hidden="true">&times;</span>
  </button>
</div>

<?php endif; ?>

<?php if(Session::has('success')): ?>
<div class="alert alert-success alert-dismissible fade show text-center" role="alert">
  <strong><?php echo e(Session::get('success')); ?></strong>
  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
    <span aria-hidden="true">&times;</span>
  </button>
</div>
<?php endif; ?>

<div class="clearfix"></div>

      <div class="table-responsive">
          <table id="example" class="table table-striped table-bordered first">
            <thead>
            <tr class="text-uppercase">
              <th style="display: none;"></th>
              <?php if(auth()->user()->is_admin == true): ?>
              <th>Enseignant</th>
              <?php endif; ?>
              <th>document</th>
              <th>date</th>
              <th>état</th>
              <th>Action</th>
            </tr>
            </thead>
            <tbody>

<?php $__currentLoopData = $demandes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $demand): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

              <tr>

                  <td style="display: none;"><?php echo e($demand->id); ?></td>

                <?php if(auth()->user()->is_admin == true): ?>
                  <td><?php echo e($demand->teacher->last_name . ' ' . $demand->teacher->first_name); ?></td>
                <?php endif; ?>
                                    

                  <td>
                    <?php echo html_entity_decode($demand->doc_name); ?>
                  </td>

                  <td>
                    <?php $enTofr = DateTime::createFromFormat('Y-m-d H:i', substr($demand->created_at, 0, 16)); echo $enTofr->format('d/m/Y H:i') ?>
                  </td>


                  <td>
                    <?php if($demand->etat == 1): ?>
                      <span class="badge badge-success"><i class="fa fa-check-circle"></i> demande traitée</span>
                    <?php else: ?> 
                      <span class="badge badge-warning text-white"><i class="fa fa-hourglass"></i> en attente</span>
                    <?php endif; ?>
                  </td>


                    <td>

                      <?php if(auth()->user()->is_teacher == true): ?>
                        <a onclick="return confirm('Supprimer?')" href="<?php echo e(URL::route('demandes_documents_delete', $demand->id)); ?>" class="btn btn-danger btn-sm mb-1"><i class="fa fa-trash"></i> </a>
                      <?php endif; ?>


                      <?php if(auth()->user()->is_admin == true): ?>

                      <?php if($demand->etat == 0): ?>
                        <a onclick="return confirm('confirmer?')" href="<?php echo e(URL::route('admin_documents_traitee', $demand->id)); ?>" class="btn btn-warning text-white btn-sm mb-1"><i class="fa fa-info-circle"></i> Demande est traitée</a>
                      <?php endif; ?>

<?php if(auth()->user()->super_admin == 1): ?>
                      <a onclick="return confirm('Supprimer?')" href="<?php echo e(URL::route('admin_documents_delete', $demand->id)); ?>" class="btn btn-danger btn-sm mb-1"><i class="fa fa-trash"></i> </a>
<?php endif; ?>

                      <?php endif; ?>
                    </td>

                </tr>

<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                  </tbody>
                  </table>
               </div>

    </div>
  </div>
</div>

                                     


</div><!-- END row -->
                
               

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master_panel', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/verdin/pedagogie.verdin.ma/resources/views/enseignants/docs_demandes.blade.php ENDPATH**/ ?>