

<?php $__env->startSection('title'); ?> Les devoirs de la semaine <?php $__env->stopSection(); ?>

<?php $__env->startSection('CSS'); ?> 


<link rel="stylesheet" type="text/css" href="<?php echo e(url('/')); ?>/js/datatables/dataTables.bootstrap4.min.css">

<link rel="stylesheet" href="<?php echo e(url('/')); ?>/assets/vendor/datepicker/tempusdominus-bootstrap-4.css" />

<link rel="stylesheet" href="<?php echo e(url('/')); ?>/assets/vendor/summernote/css/summernote-bs4.css">

<?php $__env->stopSection(); ?>

<?php $__env->startSection('JS'); ?> 


<script src="<?php echo e(url('/')); ?>/js/datatables/jquery.dataTables.min.js"></script>
<script src="<?php echo e(url('/')); ?>/js/datatables/dataTables.bootstrap4.min.js"></script>

<script type="text/javascript" class="init">
  $(document).ready(function() {
    $("#example").dataTable({ "language": { "url": "<?php echo e(url('/')); ?>/js/datatables/lang/fr.json" },
      "order": [[ 0, "desc" ]]
    });
  });
  </script>


<script src="<?php echo e(url('/')); ?>/assets/vendor/datepicker/moment.js"></script>
<script src="<?php echo e(url('/')); ?>/assets/vendor/datepicker/tempusdominus-bootstrap-4.js"></script>
<script src="<?php echo e(url('/')); ?>/assets/vendor/datepicker/datepicker.js"></script>

<script src="<?php echo e(url('/')); ?>/assets/vendor/datepicker/fr.js"></script>

<script type="text/javascript">
    $(function () {
        $('#datetimepickerdate').datetimepicker({
          format: 'DD/MM/YYYY',
          locale: 'fr'
      });
    });

</script>


<script src="<?php echo e(url('/')); ?>/assets/vendor/summernote/js/summernote-bs4.js"></script>

<script>
    $(document).ready(function() {
        $('#summernote').summernote({
            height: 150

        });
    });
</script>


<script type="text/javascript">
function ValidateSize(file) {
  var FileSize = file.files[0].size / 1024 / 1024; // in MB
  if (FileSize > 10) {
      $('#file').val(''); //for clearing with Jquery
      alert('La taille du fichier dépasse 10 Mo');
      
  } 
}
</script>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>


                  <!-- ============================================================== -->
                  <!-- pageheader  -->
                  <!-- ============================================================== -->
                  <div class="row">
                      <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                          <div class="page-header">
                              <h3 class="mb-2">Les devoirs de la semaine  </h3>
                           
                              <div class="page-breadcrumb">
                                  <nav aria-label="breadcrumb">
                                      <ol class="breadcrumb">
                                          <li class="breadcrumb-item"><a href="<?php echo e(URL::route('enseignant_index')); ?>" class="breadcrumb-link">Accueil</a></li>
                                          <li class="breadcrumb-item active" aria-current="page">Les devoirs de la semaine </li>
                                      </ol>
                                  </nav>
                              </div>
                          </div>
                      </div>
                  </div>
                  <!-- ============================================================== -->
                  <!-- end pageheader  -->
                  <!-- ============================================================== -->


<div class="row">


<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
  <div class="card">
<?php if(!isset($_GET['id'])): ?>
    <h5 class="card-header">
      <a href="#" class="btn btn-primary mb-1" data-toggle="modal" data-target="#exampleModal"><i class="fa fa-plus"></i> Ajouter </a>
    </h5>
<?php endif; ?>    
  <div class="card-body">


<?php if(isset($_GET['id'])): ?>

<?php $getDevoirs = \App\Devoirs::find(e($_GET['id'])); ?>

<?php if($getDevoirs !== null AND $getDevoirs->teacher_id == auth()->user()->id): ?>

<style type="text/css">
  .table-responsive { display: none; }
</style>

<form method="POST" action="<?php echo e(URL::route('devoirs_update', $getDevoirs->id)); ?>"  enctype="multipart/form-data">

<?php echo e(csrf_field()); ?>



<?php 
$getSubject = \App\Subjects::find($getDevoirs->subject_id);
$getclass = \App\Classes::find($getSubject->class_id);
 ?>

<div class="form-row">

  <div class="col-md-12 mb-3">
      <label>Matières / Classes</label>
      <select name="subject_id" class="selectpicker" data-width="100%" required="required">   
      
      <option value="<?php echo e($getSubject->id); ?>"><?php echo e($getSubject->name); ?> (<?php echo e($getclass->name); ?>)</option>

      </select>
  </div>


  <div class="col-md-12 mb-3">
    <label>Travail à faire pour le:</label>
    <div class="form-group">
    <div class="input-group date" id="datetimepickerdate" data-target-input="nearest">

    <input name="date" type="text" class="form-control datetimepicker-input" data-target="#datetimepickerdate" required="required" value="<?php echo e($getDevoirs->date); ?>" />
    
      <div class="input-group-append" data-target="#datetimepickerdate" data-toggle="datetimepicker">
      <div class="input-group-text"><i class="far fa-calendar-alt"></i></div>
      </div>
    </div>
  </div>
  </div>

  <div class="col-md-12 mb-3">
    <div class="form-group">
    <label>Titre:</label>
    <div class="input-group">
    <div class="input-group-prepend"><span class="input-group-text"><i class="fas fa-pencil-alt"></i></span></div>
    <input name="title" type="text" class="form-control" value="<?php echo e($getDevoirs->title); ?>" required="required">
    </div>
    </div>
  </div>


  <div class="col-md-12 mb-3">
    <label>Détails:</label>
    <textarea name="details" id="summernote" class="form-control" required="required"><?php echo html_entity_decode($getDevoirs->details); ?></textarea>
  </div>


<div class="col-md-12 mb-3">
      <label>Fichier joint</label>
        <div class="custom-file">
          <input type="file" id="file" name="file_join" onchange="ValidateSize(this)">
        </div>
        <small class="form-text">Fichiers autorisés: <span class="text-uppercase">jpg|jpeg|gif|png|bmp|pdf|doc|docx|txt|ppt|pptx|xls|xlsx</span></small>
        <small class="form-text text-danger">La taille limite du fichier est de 10Mo </small>
        <?php if($errors->first('file_join')): ?>
          <small class="form-text text-danger"><?php echo e($errors->first('file_join')); ?></small>
        <?php endif; ?>
</div>

<div class="col-md-12 mb-3">
  <?php if(!empty($getDevoirs->file_join)): ?>
    <a target="_black" class="btn btn-info btn-sm" href="<?php echo e(url('/')); ?>/uploads/devoirs/<?php echo e($getDevoirs->file_join); ?>"><i class="fa fa-download"></i> Fichier joint</a>
  <?php endif; ?>
</div>


 
</div>

<div class="form-row">
<div class="col-md-12">
    <button class="btn btn-success btn-block" type="submit">Modifier</button>
</div>
</div>

</form>

<?php endif; ?>

<div class="clearfix"></div><hr>


<?php else: ?>

<!-- Modal -->
<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
<div class="modal-dialog modal-lg" role="document">
  <div class="modal-content">
    <div class="modal-header">
      <h5 class="modal-title" id="exampleModalLabel">Ajouter</h5>
      <a href="#" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></a>
    </div>
    <div class="modal-body">

<form method="POST" action="<?php echo e(URL::route('enseignant_store_devoirs')); ?>" enctype="multipart/form-data">

<?php echo e(csrf_field()); ?>



<div class="form-row">

<div class="col-md-12 mb-3">
      <label>Matières / Classes</label>
      <select name="subject_id" class="selectpicker" data-width="100%" required="required">   
        
      <option value="">Choisir</option>
        <?php $__currentLoopData = $subjects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subject): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

<?php $getclass = \App\Classes::find($subject->class_id); ?>

          <option value="<?php echo e($subject->id); ?>"><?php echo e($subject->name); ?> (<?php echo e($getclass->name); ?>)</option>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      </select>
  </div>


  <div class="col-md-12 mb-3">
    <label>Travail à faire pour le:</label>
    <div class="form-group">
    <div class="input-group date" id="datetimepickerdate" data-target-input="nearest">

    <input name="date" type="text" class="form-control datetimepicker-input" data-target="#datetimepickerdate" required="required" value="<?php echo e(date('d/m/Y')); ?>" />
    
      <div class="input-group-append" data-target="#datetimepickerdate" data-toggle="datetimepicker">
      <div class="input-group-text"><i class="far fa-calendar-alt"></i></div>
      </div>
    </div>
  </div>
  </div>

  <div class="col-md-12 mb-3">
    <div class="form-group">
    <label>Titre:</label>
    <div class="input-group">
    <div class="input-group-prepend"><span class="input-group-text"><i class="fas fa-pencil-alt"></i></span></div>
    <input name="title" type="text" class="form-control" value="<?php echo e(old('title')); ?>" required="required">
    </div>
    </div>
  </div>


  <div class="col-md-12 mb-3">
    <label>Détails:</label>
    <textarea name="details" id="summernote" class="form-control" required="required"><?php echo e(old('details')); ?></textarea>
  </div>


<div class="col-md-12 mb-3">
      <label>Fichier joint</label>
        <div class="custom-file">
          <input type="file" id="file" name="file_join" onchange="ValidateSize(this)">
        </div>
        <small class="form-text">Fichiers autorisés: <span class="text-uppercase">jpg|jpeg|gif|png|bmp|pdf|doc|docx|txt|ppt|pptx|xls|xlsx</span></small>
        <small class="form-text text-danger">La taille limite du fichier est de 10Mo </small>
        <?php if($errors->first('file_join')): ?>
          <small class="form-text text-danger"><?php echo e($errors->first('file_join')); ?></small>
        <?php endif; ?>
</div>


 
</div>

<div class="form-row mt-1">
<div class="col-md-12">
    <button class="btn btn-success btn-block" type="submit">Ajouter</button>
</div>
</div>

</form>

    </div>
    <div class="modal-footer">
      <a href="#" class="btn btn-dark" data-dismiss="modal">Fermer</a>
    </div>
  </div>
</div>
</div>
<!-- End Modal -->

<?php endif; ?>

<div class="clearfix"></div>

<?php if(Session::has('error')): ?>

<div class="alert alert-danger alert-dismissible fade show text-center" role="alert">
  <strong><?php echo e(Session::get('error')); ?></strong>
  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
    <span aria-hidden="true">&times;</span>
  </button>
</div>

<?php endif; ?>

<?php if(Session::has('success')): ?>
<div class="alert alert-success alert-dismissible fade show text-center" role="alert">
  <strong><?php echo e(Session::get('success')); ?></strong>
  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
    <span aria-hidden="true">&times;</span>
  </button>
</div>
<?php endif; ?>

<div class="clearfix"></div>

      <div class="table-responsive">
          <table id="example" class="table table-striped table-bordered first">
            <thead>
            <tr class="text-uppercase">
              <th style="display: none;"></th>
              <th style="width: 30%">Titre</th>
              <th>à faire pour le</th>
              <th>Classe/Matière</th>
              <th>détails</th>
              <th>Action</th>
            </tr>
            </thead>
            <tbody>

<?php $__currentLoopData = $devoirs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $devoir): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

<?php if(empty($devoir->preparation_exam)): ?>

                <tr>

                  <td style="display: none;"><?php echo e($devoir->id); ?></td>
                                    
                  <td><?php echo e($devoir->title); ?></td>
                  <td><?php echo e($devoir->date); ?></td>

                  <td>
                    <?php $FindSubject = \App\Subjects::find($devoir->subject_id); ?>
                    <?php echo e($devoir->classe->name); ?> <?php if($FindSubject !== null ): ?> - <?php echo e($FindSubject->name); ?> <?php endif; ?>
                  </td>
                  

                  <td>

                    <a class="btn btn-primary btn-sm mb-1" href="#" data-toggle="modal" data-target="#exampleModal-<?php echo e($devoir->id); ?>"><i class="fa fa-eye"></i> détail</a>

                    <?php if(!empty($devoir->file_join)): ?>
                      <a target="_black" class="btn btn-info btn-sm mb-1" href="<?php echo e(url('/')); ?>/uploads/devoirs/<?php echo e($devoir->file_join); ?>"><i class="fa fa-download"></i> Fichier joint</a>
                    <?php endif; ?>


      
<!-- Modal -->
<div class="modal fade" id="exampleModal-<?php echo e($devoir->id); ?>" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel-<?php echo e($devoir->id); ?>" aria-hidden="true">
<div class="modal-dialog modal-lg" role="document">
  <div class="modal-content">
    <div class="modal-header">
      <h5 class="modal-title" id="exampleModalLabel-<?php echo e($devoir->id); ?>">détails</h5>
      <a href="#" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></a>
    </div>
    <div class="modal-body">

      <?php echo html_entity_decode($devoir->details); ?>
   
    </div>
    <div class="modal-footer">
      <a href="#" class="btn btn-dark" data-dismiss="modal">Fermer</a>
    </div>
  </div>
</div>
</div>
<!-- End Modal -->
                    
                  </td>

                      <td>

                        <a class="btn btn-warning btn-sm mb-1" href="<?php echo e(URL::route('enseignant_evaluations')); ?>?subject_id=&devoir_id=<?php echo e($devoir->id); ?>"><i class="fa fa-list"></i> Évaluations</a>

                        <a href="<?php echo e(URL::current() . '?id=' . $devoir->id); ?>" class="btn btn-success btn-sm mb-1"><i class="fa fa-edit"></i>  </a>

                        <a onclick="return confirm('Supprimer?')" href="<?php echo e(URL::route('devoirs_delete', $devoir->id)); ?>" class="btn btn-danger btn-sm mb-1"><i class="fa fa-trash"></i>  </a>
                      </td>

                    </tr>

<?php endif; ?>

<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                  </tbody>
                  </table>
               </div>

    </div>
  </div>
</div>

                                     


</div><!-- END row -->
                
               

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master_panel', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/verdin/pedagogie.verdin.ma/resources/views/enseignants/devoirs.blade.php ENDPATH**/ ?>