@extends('layouts.master_panel')

@section('title') دفتر النصوص  @stop

@section('CSS') 


<link rel="stylesheet" type="text/css" href="{{url('/')}}/js/datatables/dataTables.bootstrap4.min.css">

<link rel="stylesheet" href="{{url('/')}}/assets/vendor/datepicker/tempusdominus-bootstrap-4.css" />

<link rel="stylesheet" href="{{url('/')}}/assets/vendor/summernote/css/summernote-bs4.css">

@stop

@section('JS') 


<script src="{{url('/')}}/js/datatables/jquery.dataTables.min.js"></script>
<script src="{{url('/')}}/js/datatables/dataTables.bootstrap4.min.js"></script>

<script type="text/javascript" class="init">
  $(document).ready(function() {
    $("#example").dataTable({ "language": { "url": "{{ url('/') }}/js/datatables/lang/fr.json" },
      "order": [[ 0, "desc" ]]
    });
  });
  </script>


<script src="{{url('/')}}/assets/vendor/datepicker/moment.js"></script>
<script src="{{url('/')}}/assets/vendor/datepicker/tempusdominus-bootstrap-4.js"></script>
<script src="{{url('/')}}/assets/vendor/datepicker/datepicker.js"></script>

<script src="{{url('/')}}/assets/vendor/datepicker/fr.js"></script>

<script type="text/javascript">
    $(function () {
        $('#datetimepickerdate').datetimepicker({
          format: 'DD/MM/YYYY',
          locale: 'fr'
      });
    });

    $(function () {
        $('#datetimepickerdateHon').datetimepicker({
          format: 'DD/MM/YYYY',
          locale: 'fr'
      });
    });

    $(function () {
        $('#datetimepickerdateHon2').datetimepicker({
          format: 'DD/MM/YYYY',
          locale: 'fr'
      });
    });

    $(function () {
        $('#datetimepicker').datetimepicker({
          format: 'HH:mm',
          locale: 'fr'
      });
    });


    $('#datetimepicker4').datetimepicker({
        format: 'HH:mm',
        locale: 'fr'
    });

</script>


<script src="{{url('/')}}/assets/vendor/summernote/js/summernote-bs4.js"></script>

<script>
    $(document).ready(function() {
        $('#summernote').summernote({
            height: 150

        });
    });
</script>


@stop


@section('content')


                  <!-- ============================================================== -->
                  <!-- pageheader  -->
                  <!-- ============================================================== -->
                  <div class="row">
                      <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                          <div class="page-header">
                              <h3 class="mb-2">دفتر النصوص  </h3>
                           
                              <div class="page-breadcrumb">
                                  <nav aria-label="breadcrumb">
                                      <ol class="breadcrumb">
                                          <li class="breadcrumb-item"><a href="{{ URL::route('enseignant_index') }}" class="breadcrumb-link">Accueil</a></li>
                                          <li class="breadcrumb-item active" aria-current="page">دفتر النصوص </li>
                                      </ol>
                                  </nav>
                              </div>
                          </div>
                      </div>
                  </div>
                  <!-- ============================================================== -->
                  <!-- end pageheader  -->
                  <!-- ============================================================== -->


<div class="row">


<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
  <div class="card">
@if(!isset($_GET['id']))
    <h5 class="card-header">
      <a href="#" class="btn btn-primary mb-1" data-toggle="modal" data-target="#exampleModal"><i class="fa fa-plus"></i> Ajouter </a>

      <a href="#" class="btn btn-primary mb-1" data-toggle="modal" data-target="#Historique"><i class="fas fa-history "></i> Historique</a>

    </h5>
@endif    
  <div class="card-body">


@if(isset($_GET['id']))

<?php $getjournal = \App\CahierJournal::find(e($_GET['id'])); ?>

@if($getjournal !== null AND $getjournal->teacher_id == auth()->user()->id)

<form method="POST" action="{{ URL::route('cahier_journal_update', $getjournal->id) }}" >

{{ csrf_field() }}


<?php 
$getSubject = \App\Subjects::find($getjournal->subject_id);
$getclass = \App\Classes::find($getjournal->class_id);
 ?>

<div class="form-row">

  <div class="col-md-12 mb-3">
      <label>Matières / Classes</label>
      <select name="subject_id" class="selectpicker" data-width="100%" required="required">   
      
      <option value="{{ $getSubject->id }}">{{ $getSubject->name }} ({{ $getclass->name }})</option>

      </select>
  </div>

  <div class="col-md-12 mb-3">
    <label>Date:</label>
    <div class="form-group">
    <div class="input-group date" id="datetimepickerdate" data-target-input="nearest">

    <input name="date" type="text" class="form-control datetimepicker-input" data-target="#datetimepickerdate" required="required" value="{{ $getjournal->date }}" />
    
      <div class="input-group-append" data-target="#datetimepickerdate" data-toggle="datetimepicker">
      <div class="input-group-text"><i class="far fa-calendar-alt"></i></div>
      </div>
    </div>
  </div>
  </div>



<?php $horaires1 = \App\Horaires::where('periode', 1)->orderBy('hour_id', 'ASC')->get(); ?>
<?php $horaires2 = \App\Horaires::where('periode', 2)->orderBy('hour_id', 'ASC')->get(); ?>

<div class="col-md-12 mb-3">
    <label>Heure début - Heure fin:</label>
    <select name="seance_heures" id="nombre_heures" class="selectpicker" data-width="100%"  required="required">

    <option selected="selected" value="{{ $getjournal->hour_start }} - {{ $getjournal->hour_end }}">{{ $getjournal->hour_start }} - {{ $getjournal->hour_end }}</option>

<optgroup label="Matin">
      @foreach($horaires1 as $horair1)
        <option value="{{ $horair1->entry_time }} - {{ $horair1->exit_time }}">{{ $horair1->entry_time }} - {{ $horair1->exit_time }}</option>
      @endforeach
</optgroup>

<optgroup label="Après-midi">
      @foreach($horaires2 as $horair2)
        <option value="{{ $horair2->entry_time }} - {{ $horair2->exit_time }}">{{ $horair2->entry_time }} - {{ $horair2->exit_time }}</option>
      @endforeach
</optgroup>

     </select>
</div>


  <div class="col-md-12 mb-3">
    <label>détails:</label>
    <textarea name="details" id="summernote" class="form-control" required="required"><?php echo html_entity_decode($getjournal->details); ?></textarea>
  </div>


 
</div>

<div class="form-row">
<div class="col-md-12">
    <button class="btn btn-success btn-block" type="submit">Modifier</button>
</div>
</div>

</form>

@endif

<div class="clearfix"></div><hr>


@else



<!-- Modal -->
<div class="modal fade" id="Historique" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel23" aria-hidden="true">
<div class="modal-dialog modal-lg" role="document">
  <div class="modal-content">
    <div class="modal-header">
      <h5 class="modal-title" id="exampleModalLabel23">Historique</h5>
      <a href="#" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></a>
    </div>
    <div class="modal-body">

<form method="GET" target="_black" action="{{ URL::route('teacher_cahierjournal_historique') }}" class="form-row">


<div class="col-md-6 mb-3">
    <label>Période du:</label>
    <div class="form-group">
    <div class="input-group date" id="datetimepickerdateHon" data-target-input="nearest">

    <input name="from" type="text" class="form-control datetimepicker-input" data-target="#datetimepickerdateHon" />
    
      <div class="input-group-append" data-target="#datetimepickerdateHon" data-toggle="datetimepicker">
      <div class="input-group-text"><i class="far fa-calendar-alt"></i></div>
      </div>
    </div>
  </div>
</div>

<div class="col-md-6 mb-3">
    <label>Période au:</label>
    <div class="form-group">
    <div class="input-group date" id="datetimepickerdateHon2" data-target-input="nearest">

    <input name="to" type="text" class="form-control datetimepicker-input" data-target="#datetimepickerdateHon2" />
    
      <div class="input-group-append" data-target="#datetimepickerdateHon2" data-toggle="datetimepicker">
      <div class="input-group-text"><i class="far fa-calendar-alt"></i></div>
      </div>
    </div>
  </div>
</div>




<div class="col-md-12 mb-3">
    <button class="btn btn-primary btn-block" type="submit">Historique</button>
</div>


</form>



    </div>

    <div class="modal-footer">
      <a href="#" class="btn btn-dark" data-dismiss="modal">Fermer</a>
    </div>

  </div>
</div>
</div>
<!-- End Modal -->



<!-- Modal -->
<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
<div class="modal-dialog modal-lg" role="document">
  <div class="modal-content">
    <div class="modal-header">
      <h5 class="modal-title" id="exampleModalLabel">دفتر النصوص </h5>
      <a href="#" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></a>
    </div>
    <div class="modal-body">

<form method="POST" action="{{ URL::route('cahier_journal_store') }}" >

{{ csrf_field() }}


<div class="form-row">


  <div class="col-md-12 mb-3">
      <label>Matières / Classes</label>
      <select name="subject_id" class="selectpicker" data-width="100%" required="required">   
        
      <option value="">Choisir</option>
        @foreach($subjects as $subject)

        <?php $getclass = \App\Classes::find($subject->class_id); ?>

          <option value="{{ $subject->id }}">{{ $subject->name }} ({{ $getclass->name }})</option>
          @endforeach
      </select>
  </div>
  

  <div class="col-md-12 mb-3">
    <label>Date:</label>
    <div class="form-group">
    <div class="input-group date" id="datetimepickerdate" data-target-input="nearest">

    <input name="date" type="text" class="form-control datetimepicker-input" data-target="#datetimepickerdate" value="{{ date('d/m/Y') }}" required="required" />
    
      <div class="input-group-append" data-target="#datetimepickerdate" data-toggle="datetimepicker">
      <div class="input-group-text"><i class="far fa-calendar-alt"></i></div>
      </div>
    </div>
  </div>
  </div>



<?php $horaires1 = \App\Horaires::where('periode', 1)->orderBy('hour_id', 'ASC')->get(); ?>
<?php $horaires2 = \App\Horaires::where('periode', 2)->orderBy('hour_id', 'ASC')->get(); ?>

<div class="col-md-12 mb-3">
    <label>Heure début - Heure fin:</label>
    <select name="seance_heures" id="nombre_heures" class="selectpicker" data-width="100%"  required="required" title="choisir">

<optgroup label="Matin">
      @foreach($horaires1 as $horair1)
        <option value="{{ $horair1->entry_time }} - {{ $horair1->exit_time }}">{{ $horair1->entry_time }} - {{ $horair1->exit_time }}</option>
      @endforeach
</optgroup>

<optgroup label="Après-midi">
      @foreach($horaires2 as $horair2)
        <option value="{{ $horair2->entry_time }} - {{ $horair2->exit_time }}">{{ $horair2->entry_time }} - {{ $horair2->exit_time }}</option>
      @endforeach
</optgroup>

     </select>
</div>


<?php /* ?>

  <div class="col-md-12 mb-3">
        <label>Heure début - Heure fin:</label>
        <select name="seance_heures" id="nombre_heures" class="selectpicker" data-width="100%"  required="required" title="choisir">

          <optgroup label="Matin">
              <option value="08:00 - 09:00">08:00 - 09:00</option>
              <option value="08:00 - 10:00">08:00 - 10:00</option>
              <option value="09:00 - 10:00">09:00 - 10:00</option>
              <option value="09:00 - 11:00">09:00 - 11:00</option>
              <option value="10:00 - 11:00">10:00 - 11:00</option>
              <option value="10:00 - 12:00">10:00 - 12:00</option>
              <option value="11:00 - 12:00">11:00 - 12:00</option>
          </optgroup>

          <optgroup label="Après-midi">

              <option value="12:30 - 13:30">12:30 - 13:30</option>
              <option value="12:30 - 14:00">12:30 - 14:00</option>
              <option value="12:30 - 14:00">12:30 - 14:30</option>

              <option value="13:00 - 14:00">13:00 - 14:00</option>
              <option value="13:00 - 14:30">13:00 - 14:30</option>
              <option value="13:00 - 15:00">13:00 - 15:00</option>

              <option value="13:30 - 14:30">13:30 - 14:30</option>
              <option value="13:30 - 15:00">13:30 - 15:00</option>
              <option value="13:30 - 15:30">13:30 - 15:30</option>

              <option value="14:00 - 15:00">14:00 - 15:00</option>
              <option value="14:00 - 15:30">14:00 - 15:30</option>
              <option value="14:00 - 16:00">14:00 - 16:00</option>

              <option value="14:30 - 15:30">14:30 - 15:30</option>
              <option value="14:30 - 16:00">14:30 - 16:00</option>
              <option value="14:30 - 16:30">14:30 - 16:30</option>

              <option value="15:00 - 16:00">15:00 - 16:00</option>
              <option value="15:00 - 16:30">15:00 - 16:30</option>
              <option value="15:00 - 17:00">15:00 - 17:00</option>

              <option value="15:30 - 16:30">15:30 - 16:30</option>
              <option value="15:30 - 17:00">15:30 - 17:00</option>
              <option value="15:30 - 17:30">15:30 - 17:30</option>

              <option value="16:00 - 17:00">16:00 - 17:00</option>
              <option value="16:00 - 17:30">16:00 - 17:30</option>
              <option value="16:00 - 18:00">16:00 - 18:00</option>

              <option value="16:30 - 17:30">16:30 - 17:30</option>
              <option value="16:30 - 18:00">16:30 - 18:00</option>

              <option value="17:00 - 18:00">17:00 - 18:00</option>

          </optgroup>



        </select>
  </div>


  <div class="col-md-6 mb-3">
    <label>Heure début de la séance:</label>
    <div class="form-group">
    <div class="input-group date" id="datetimepicker4" data-target-input="nearest">

    <input name="hour_start" type="text" class="form-control datetimepicker-input" data-target="#datetimepicker4" required="required" />
    
      <div class="input-group-append" data-target="#datetimepicker4" data-toggle="datetimepicker">
      <div class="input-group-text"><i class="far fa-clock"></i></div>
      </div>
    </div>
  </div>
  </div>

  <div class="col-md-6 mb-3">
    <label>Heure fin de la séance:</label>
    <div class="form-group">
    <div class="input-group date" id="datetimepicker" data-target-input="nearest">
  
      <input name="hour_end" type="text" class="form-control datetimepicker-input" data-target="#datetimepicker" required="required" />
 
      <div class="input-group-append" data-target="#datetimepicker" data-toggle="datetimepicker">
      <div class="input-group-text"><i class="far fa-clock"></i></div>
      </div>
    </div>
  </div>
  </div>

<?php */ ?>

  <div class="col-md-12 mb-3">
    <label>Détails:</label>
    <textarea name="details" id="summernote" class="form-control" required="required"></textarea>
  </div>


 
</div>

<div class="form-row">
<div class="col-md-12">
    <button class="btn btn-success btn-block" type="submit">Ajouter</button>
</div>
</div>

</form>

    </div>
    <div class="modal-footer">
      <a href="#" class="btn btn-dark" data-dismiss="modal">Fermer</a>
    </div>
  </div>
</div>
</div>
<!-- End Modal -->

@endif

<div class="clearfix"></div>

@if(Session::has('error'))

<div class="alert alert-danger alert-dismissible fade show text-center" role="alert">
  <strong>{{ Session::get('error') }}</strong>
  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
    <span aria-hidden="true">&times;</span>
  </button>
</div>

@endif

@if(Session::has('success'))
<div class="alert alert-success alert-dismissible fade show text-center" role="alert">
  <strong>{{ Session::get('success') }}</strong>
  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
    <span aria-hidden="true">&times;</span>
  </button>
</div>
@endif

<div class="clearfix"></div>

      <div class="table-responsive">
          <table id="example" class="table table-striped table-bordered first">
            <thead>
            <tr class="text-uppercase">

              <th>date</th>
              <th>matières - Classes</th>
              <th>Heure début de la séance</th>
              <th>Heure fin de la séance</th>
              <th>détails</th>
              <th>Action</th>
            </tr>
            </thead>
            <tbody>

             @foreach($cahier_journal as $cahier_journ)
                <tr>

                                  
                  <td>{{ $cahier_journ->date }}</td>
                  <td>{{ $cahier_journ->subject->name }} - {{ $cahier_journ->classe->name }}</td>
                  <td>{{ $cahier_journ->hour_start }}</td>
                  <td>{{ $cahier_journ->hour_end }}</td>
                  <td>
                    <a class="btn btn-primary btn-sm" href="#" data-toggle="modal" data-target="#exampleModal-{{ $cahier_journ->id }}"><i class="fa fa-eye"></i> détail</a>
      
<!-- Modal -->
<div class="modal fade" id="exampleModal-{{ $cahier_journ->id }}" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel-{{ $cahier_journ->id }}" aria-hidden="true">
<div class="modal-dialog modal-lg" role="document">
  <div class="modal-content">
    <div class="modal-header">
      <h5 class="modal-title" id="exampleModalLabel-{{ $cahier_journ->id }}">détails</h5>
      <a href="#" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></a>
    </div>
    <div class="modal-body">

      <?php echo html_entity_decode($cahier_journ->details); ?>
   
    </div>
    <div class="modal-footer">
      <a href="#" class="btn btn-dark" data-dismiss="modal">Fermer</a>
    </div>
  </div>
</div>
</div>
<!-- End Modal -->
                    
                  </td>

                      <td>

                        <a href="{{ URL::current() . '?id=' . $cahier_journ->id }}" class="btn btn-success btn-sm"><i class="fa fa-edit"></i>  </a>

                        <a onclick="return confirm('Supprimer?')" href="{{ URL::route('cahier_journal_delete', $cahier_journ->id) }}" class="btn btn-danger btn-sm"><i class="fa fa-trash"></i>  </a>
                      </td>

                    </tr>

                    @endforeach
                  </tbody>
                  </table>
               </div>

    </div>
  </div>
</div>

                                     


</div><!-- END row -->
                
               

@stop