@extends('layouts.other_panel')

@section('title') Agents @stop

@section('CSS') 


<link rel="stylesheet" type="text/css" href="{{url('/')}}/js/datatables/dataTables.bootstrap4.min.css">

<link rel="stylesheet" href="{{url('/')}}/assets/vendor/datepicker/tempusdominus-bootstrap-4.css" />

<style type="text/css">
.figure-attachment {
    min-height: 100px;
}
.fa-lg {
  font-size: 36px !important;
}
</style>

@stop



@section('content')


<!-- ============================================================== -->
                  <!-- pageheader  -->
                  <!-- ============================================================== -->
                  <div class="row">
                      <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                          <div class="page-header">
                              <h3 class="mb-2">Agents</h3>
                          </div>
                      </div>
                  </div>
                  <!-- ============================================================== -->
                  <!-- end pageheader  -->
                  <!-- ============================================================== -->

<div class="row">    



<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
  <div class="card">
    <h5 class="card-header">

@if(auth()->user()->super_admin == 1)      
      <a href="#" class="btn btn-primary mb-1" data-toggle="modal" data-target="#exampleModal"><i class="fa fa-plus"></i> Ajouter </a>

      <a target="_black" href="https://reg.scolarite-verdin.ma/admin/agents" class="btn btn-primary mb-1"><i class="fa fa-users"></i> Agents Réglement/Gestion du Transport </a>
@endif

    </h5>
  <div class="card-body">



<div class="clearfix"></div>

@if(Session::has('error'))

<div class="alert alert-danger alert-dismissible fade show text-center" role="alert">
  <strong>{{ Session::get('error') }}</strong>
  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
    <span aria-hidden="true">&times;</span>
  </button>
</div>

@endif

@if(Session::has('success'))
<div class="alert alert-success alert-dismissible fade show text-center" role="alert">
  <strong>{{ Session::get('success') }}</strong>
  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
    <span aria-hidden="true">&times;</span>
  </button>
</div>
@endif

<div class="clearfix"></div>




@if(isset($_GET['agent_id']))

<?php $personnel = \App\User::find(e($_GET['agent_id'])); ?>

@if($personnel !== null)


<div class="col-md-12" style="margin-bottom: 50px; border: 2px solid #ccc; padding: 50px;">

<form method="POST" action="{{ URL::route('update_agents_role', $personnel->id) }}"  enctype="multipart/form-data">

{{ csrf_field() }}

<div class="row">


<div class="col-md-6 mb-3">
    <label>Absences des élèves:</label>
    <select name="is_absences_agent" class="selectpicker" data-width="100%">
      @if($personnel->is_absences_agent == 1)
        <option value="1" selected="selected">Oui</option>
        <option value="0">Non</option>
      @else
        <option value="0">Non</option>
        <option value="1">Oui</option>
      @endif
    </select>
</div>

<div class="col-md-6 mb-3">
    <label>Archives:</label>
    <select name="is_archives_agent" class="selectpicker" data-width="100%">
      @if($personnel->is_archives_agent == 1)
        <option value="1" selected="selected">Oui</option>
        <option value="0">Non</option>
      @else
        <option value="0">Non</option>
        <option value="1">Oui</option>
      @endif
    </select>
</div>

<div class="col-md-6 mb-3">
    <label>Historique d'absences / Télécharger les absences:</label>
    <select name="is_historiqueabs_agent" class="selectpicker" data-width="100%">
      @if($personnel->is_historiqueabs_agent == 1)
        <option value="1" selected="selected">Oui</option>
        <option value="0">Non</option>
      @else
        <option value="0">Non</option>
        <option value="1">Oui</option>
      @endif
    </select>
</div>

<div class="col-md-6 mb-3">
    <label>Pointage des heures de travail:</label>
    <select name="is_pointage_agent" class="selectpicker" data-width="100%">
      @if($personnel->is_pointage_agent == 1)
        <option value="1" selected="selected">Oui</option>
        <option value="0">Non</option>
      @else
        <option value="0">Non</option>
        <option value="1">Oui</option>
      @endif
    </select>
</div>

<div class="col-md-6 mb-3">
    <label>Demande de renseignements:</label>
    <select name="is_renseignm_agent" class="selectpicker" data-width="100%">
      @if($personnel->is_renseignm_agent == 1)
        <option value="1" selected="selected">Oui</option>
        <option value="0">Non</option>
      @else
        <option value="0">Non</option>
        <option value="1">Oui</option>
      @endif
    </select>
</div>

<div class="col-md-6 mb-3">
    <label>Demande documents (Parents):</label>
    <select name="is_demandedocs_agent" class="selectpicker" data-width="100%">
      @if($personnel->is_demandedocs_agent == 1)
        <option value="1" selected="selected">Oui</option>
        <option value="0">Non</option>
      @else
        <option value="0">Non</option>
        <option value="1">Oui</option>
      @endif
    </select>
</div>

<div class="col-md-6 mb-3">
    <label>Gestion des charges:</label>
    <select name="is_charges_agent" class="selectpicker" id="is_charges_agent" data-width="100%">
      @if($personnel->is_charges_agent == 1)
        <option value="1" selected="selected">Oui</option>
        <option value="0">Non</option>
      @else
        <option value="0">Non</option>
        <option value="1">Oui</option>
      @endif
    </select>
</div>



<div class="col-md-6 mb-3">
    <label>Assiduité:</label>
    <select name="is_assiduite_agent" class="selectpicker" data-width="100%">
      @if($personnel->is_assiduite_agent == 1)
        <option value="1" selected="selected">Oui</option>
        <option value="0">Non</option>
      @else
        <option value="0">Non</option>
        <option value="1">Oui</option>
      @endif
    </select>
</div>

<div class="col-md-12 mb-3">
    <label>Affectation Enseignants-Séances:</label>
    <select name="is_affectation_agent" class="selectpicker" data-width="100%">
        @if($personnel->is_affectation_agent == 1)
        <option value="1" selected="selected">Oui</option>
        <option value="0">Non</option>
      @else
        <option value="0">Non</option>
        <option value="1">Oui</option>
      @endif
    </select>
</div>

<div class="col-md-12 mb-5">

<?php 
$classes_charges = array(
  5 => '1000 - Personnel',
  6 => '2000 - Transport',
  7 => '3000 - Frais d\'exploitation',
  8 => '4000 - Charges sociales',
);


$allowed_charges = explode(",", $personnel->agent_allowed_charges);
?>
    <label>Les classes de charges autorisées:</label>
    <select name="agent_allowed_charges[]" class="selectpicker" id="allowed_charges" data-width="100%" multiple="multiple">
      @foreach($classes_charges as $key => $classes_charge)
        <option value="{{ $key }}">{{ $classes_charge }}</option>
      @endforeach
    </select>

</div>


<div class="clearfix"></div>


  <div class="col-md-6 mb-3">
    <div class="form-group">
    <label>Nom</label>
    <div class="input-group">
    <div class="input-group-prepend"><span class="input-group-text"><i class="fa fa-edit"></i></span></div>
    <input name="last_name" type="text" class="form-control" value="{{ $personnel->last_name }}" required>
    </div>
    </div>
  </div>

  <div class="col-md-6 mb-3">
    <div class="form-group">
    <label>Prénom</label>
    <div class="input-group">
    <div class="input-group-prepend"><span class="input-group-text"><i class="fa fa-edit"></i></span></div>
    <input name="first_name" type="text" class="form-control" value="{{ $personnel->first_name }}" required>
    </div>
    </div>
  </div>

</div>



<div class="row">

  <div class="col-md-6">
    <div class="form-group">
    <label>Téléphone</label>
    <div class="input-group">
    <div class="input-group-prepend"><span class="input-group-text"><i class="fa fa-phone"></i></span></div>
    <input name="phone" type="text" class="form-control" value="{{ $personnel->phone }}">
    </div>
    </div>
  </div>

  <div class="col-md-6">
    <div class="form-group">
    <label>Email</label>
    <div class="input-group">
    <div class="input-group-prepend"><span class="input-group-text"><i class="fa fa-envelope"></i></span></div>
    <input name="email" type="email" class="form-control" value="{{ $personnel->email }}">
    </div>
    </div>
    @if($errors->first('email'))
      <small class="form-text text-danger">{{ $errors->first('email') }}</small>
    @endif
  </div>

</div>


<div class="row">
  <div class="col-md-12">
      <label>Image</label>
        <div class="custom-file">
          <input type="file" name="image">
          
        </div>
        @if($errors->first('image'))
          <small class="form-text text-danger">{{ $errors->first('image') }}</small>
        @endif
    </div>
</div>



<div class="row">
<div class="col-md-12 mt-3">
    <button class="btn btn-primary" type="submit">Modifier</button>
</div>
</div>

</form>

<div class="clearfix"></div><hr>

<form method="POST" action="{{ URL::route('personnel_password_update', $personnel->id) }}">

{{ csrf_field() }}

<div class="row">

  <div class="col-md-4">
    <div class="form-group">
    <label>Nom d'utilisateur</label>
    <div class="input-group">
    <div class="input-group-prepend"><span class="input-group-text">@</span></div>
    <input name="username" type="text" class="form-control" value="{{ $personnel->username }}">
    </div>
    </div>
    @if($errors->first('username'))
      <small class="form-text text-danger">{{ $errors->first('username') }}</small>
    @endif
  </div>

  <div class="col-md-4">
    <div class="form-group">
    <label>Mot de passe</label>
    <div class="input-group">
    <div class="input-group-prepend"><span class="input-group-text" style="cursor: pointer; " onclick="generatePassword();">Générer</span></div>
    <input name="password" type="text" id="inputPassword" class="form-control input-lg" required="required">
    </div>
    </div>
  </div>

  <div class="col-md-4">
      <label>Expiration du mot de passe:</label>
      <div class="form-group">
      <div class="input-group date" id="datetimepickerdateHon" data-target-input="nearest">

      <input name="date_expire_passe" type="text" class="form-control datetimepicker-input" data-target="#datetimepickerdateHon" style="height: 40px;"value="{{ $personnel->date_expire_passe }}" required="required"  />
      
        <div class="input-group-append" data-target="#datetimepickerdateHon" data-toggle="datetimepicker">
        <div class="input-group-text"><i class="far fa-calendar-alt"></i></div>
        </div>
      </div>
    </div>
  </div>




</div>


<script type="text/javascript">

function generatePassword() {
    var length = 8,
        charset = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789!@#$%&*",
        retVal = "";
    for (var i = 0, n = charset.length; i < length; ++i) {
        retVal += charset.charAt(Math.floor(Math.random() * n));
    }

  //  return retVal;
    $('#inputPassword').val(retVal); 
}

</script> 

<div class="row">
<div class="col-md-12">
    <button class="btn btn-danger" type="submit">Modifier</button>
</div>
</div>

</form>

</div>


@endif

@else 

<!-- Modal -->
<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
<div class="modal-dialog modal-lg" role="document">
  <div class="modal-content">
    <div class="modal-header">
      <h5 class="modal-title" id="exampleModalLabel">Ajouter</h5>
      <a href="#" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></a>
    </div>
    <div class="modal-body">

<form method="POST" action="{{ URL::route('store_agents_role') }}"  enctype="multipart/form-data">

{{ csrf_field() }}

<div class="row">


  <div class="col-md-6">
    <div class="form-group">
    <label>Nom</label>
    <div class="input-group">
    <div class="input-group-prepend"><span class="input-group-text"><i class="fas fa-address-card"></i></span></div>
    <input name="last_name" type="text" class="form-control" value="{{ old('last_name') }}" required>
    </div>
    </div>
  </div>

  <div class="col-md-6">
    <div class="form-group">
    <label>Prénom</label>
    <div class="input-group">
    <div class="input-group-prepend"><span class="input-group-text"><i class="fas fa-address-card"></i></span></div>
    <input name="first_name" type="text" class="form-control" value="{{ old('first_name') }}" required>
    </div>
    </div>
  </div>

</div>



<div class="row">

  <div class="col-md-6">
    <div class="form-group">
    <label>Téléphone</label>
    <div class="input-group">
    <div class="input-group-prepend"><span class="input-group-text"><i class="fa fa-phone"></i></span></div>
    <input name="phone" type="text" class="form-control" value="{{ old('phone') }}">
    </div>
    </div>
  </div>

  <div class="col-md-6">
    <div class="form-group">
    <label>Email</label>
    <div class="input-group">
    <div class="input-group-prepend"><span class="input-group-text"><i class="fa fa-envelope"></i></span></div>
    <input name="email" type="email" class="form-control" value="{{ old('email') }}" required="required">
    </div>
    </div>
    @if($errors->first('email'))
      <small class="form-text text-danger">{{ $errors->first('email') }}</small>
    @endif
  </div>

</div>


<div class="clearfix"></div><hr>

<div class="row">


  <div class="col-md-4">
    <div class="form-group">
    <label>Nom d'utilisateur</label>
    <div class="input-group">
    <div class="input-group-prepend"><span class="input-group-text">@</span></div>
    <input name="username" type="text" class="form-control" value="{{ old('username') }}" required="required">
    </div>
    </div>
    @if($errors->first('username'))
      <small class="form-text text-danger">{{ $errors->first('username') }}</small>
    @endif
  </div>

  <div class="col-md-4">
    <div class="form-group">
    <label>Mot de passe</label>
    <div class="input-group">
    <div class="input-group-prepend"><span class="input-group-text" style="cursor: pointer; " onclick="generatePassword();">Générer</span></div>
    <input name="password" type="text" id="inputPassword" class="form-control input-lg" required="required">
    </div>
    </div>
  </div>

  <div class="col-md-4">
      <label>Expiration du mot de passe:</label>
      <div class="form-group">
      <div class="input-group date" id="datetimepickerdateHon" data-target-input="nearest">

      <input name="date_expire_passe" type="text" class="form-control datetimepicker-input" data-target="#datetimepickerdateHon" style="height: 40px;"value="{{ date('d/m/Y') }}" required="required"  />
      
        <div class="input-group-append" data-target="#datetimepickerdateHon" data-toggle="datetimepicker">
        <div class="input-group-text"><i class="far fa-calendar-alt"></i></div>
        </div>
      </div>
    </div>
  </div>

  <div class="col-md-12">
        <div class="form-group">
          <label>Image</label>
          <input type="file" name="image" class="form-control">
        </div>
  </div>

</div>


<div class="clearfix"></div><hr>

<div class="row">

<div class="col-md-6 mb-3">
    <label>Absences des élèves:</label>
    <select name="is_absences_agent" class="selectpicker" data-width="100%">
        <option value="0">Non</option>
        <option value="1">Oui</option>
    </select>
</div>

<div class="col-md-6 mb-3">
    <label>Archives:</label>
    <select name="is_archives_agent" class="selectpicker" data-width="100%">
        <option value="0">Non</option>
        <option value="1">Oui</option>
    </select>
</div>

<div class="col-md-6 mb-3">
    <label>Historique d'absences / Télécharger les absences:</label>
    <select name="is_historiqueabs_agent" class="selectpicker" data-width="100%">
        <option value="0">Non</option>
        <option value="1">Oui</option>
    </select>
</div>

<div class="col-md-6 mb-3">
    <label>Pointage des heures de travail:</label>
    <select name="is_pointage_agent" class="selectpicker" data-width="100%">
        <option value="0">Non</option>
        <option value="1">Oui</option>
    </select>
</div>

<div class="col-md-6 mb-3">
    <label>Demande de renseignements:</label>
    <select name="is_renseignm_agent" class="selectpicker" data-width="100%">
        <option value="0">Non</option>
        <option value="1">Oui</option>
    </select>
</div>

<div class="col-md-6 mb-3">
    <label>Demande documents:</label>
    <select name="is_demandedocs_agent" class="selectpicker" data-width="100%">
        <option value="0">Non</option>
        <option value="1">Oui</option>
    </select>
</div>

<div class="col-md-6 mb-3">
    <label>Gestion des charges:</label>
    <select name="is_charges_agent" class="selectpicker" data-width="100%">
        <option value="0">Non</option>
        <option value="1">Oui</option>
    </select>
</div>

<div class="col-md-6 mb-3">
    <label>Assiduité:</label>
    <select name="is_assiduite_agent" class="selectpicker" data-width="100%">
        <option value="0">Non</option>
        <option value="1">Oui</option>
    </select>
</div>

<div class="col-md-6 mb-3">
    <label>Affectation Enseignants-Séances:</label>
    <select name="is_affectation_agent" class="selectpicker" data-width="100%">
        <option value="0">Non</option>
        <option value="1">Oui</option>
    </select>
</div>



</div>



<script type="text/javascript">

function generatePassword() {
    var length = 8,
        charset = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789!@#$%&*",
        retVal = "";
    for (var i = 0, n = charset.length; i < length; ++i) {
        retVal += charset.charAt(Math.floor(Math.random() * n));
    }

  //  return retVal;
    $('#inputPassword').val(retVal); 
}

</script> 

<div class="row">
<div class="col-md-12 mt-3">
    <button class="btn btn-success btn-block" type="submit">Ajouter</button>
</div>
</div>

</form>

    </div>
    <div class="modal-footer">
      <a href="#" class="btn btn-dark" data-dismiss="modal">Fermer</a>
    </div>
  </div>
</div>
</div>
<!-- End Modal -->

@endif



      <div class="table-responsive">
          <table class="table table-striped table-bordered first">
            <thead>
            <tr class="text-uppercase">
              <th></th>
              <th>Nom et Prénom</th>
              <th>Les tâches</th>
              <th>Nom d'utilisateur</th>
              <th>Action</th>
            </tr>
            </thead>
            <tbody>

             @foreach($agents as $agen)
                <tr style="font-size: 0.9em;">
                  

                   <td>
                    @if(!empty($agen->image))
                    <img style="max-width: 65px; max-height: 65px;" src="{{ url('/') }}/uploads/images/{{ $agen->image }}" alt="" class="rounded-circle user-avatar-xxl">
                    @else
                    <img style="max-width: 65px; max-height: 65px;" src="{{ url('/') }}/uploads/images/user.png" alt="" class="rounded-circle user-avatar-xxl">
                    @endif
                  </td>
                                           
                  <td>{{ $agen->last_name . ' ' . $agen->first_name }}</td>


                  <td>
@if($agen->is_absences_agent == 1) 
<span class="badge badge-info mb-2"> Absences des élèves </span>
@endif

@if($agen->is_historiqueabs_agent == 1) 
<span class="badge badge-info mb-2"> Historique/Télécharger les absences </span>
@endif

@if($agen->is_pointage_agent == 1) 
<span class="badge badge-info mb-2"> Pointage des heures de travail </span>
@endif

@if($agen->is_archives_agent == 1)
<span class="badge badge-info mb-2"> Archives </span>
@endif

@if($agen->is_renseignm_agent == 1)
<span class="badge badge-info mb-2"> Demande de renseignements </span>
@endif


@if($agen->is_demandedocs_agent == 1)
<span class="badge badge-info mb-2"> Demande documents </span>
@endif

@if($agen->is_assiduite_agent == 1)
<span class="badge badge-info mb-2"> Assiduité </span>
@endif

@if($agen->is_affectation_agent == 1)
<span class="badge badge-info mb-2"> Affectation Enseignants-Séances </span>
@endif


@if($agen->is_charges_agent == 1)

<?php 
$listclasses_charges = array(
  5 => '1000 - Personnel',
  6 => '2000 - Transport',
  7 => '3000 - Frais d\'exploitation',
  8 => '4000 - Charges sociales',
);

$allowed_charges = explode(",", $agen->agent_allowed_charges);
?>

  @foreach($listclasses_charges as $key2 => $listclasses_charge)
  @if(in_array($key2, $allowed_charges))
  <span class="badge badge-info mb-2">{{ $listclasses_charge }}</span>
  @endif
@endforeach
  
@endif


                  </td>

                  <td>{{ $agen->username }}</td>

                  
                    <td>
@if(auth()->user()->super_admin == 1)
                        <a href="{{ URL::current() . '?agent_id=' . $agen->id }}" class="btn btn-success btn-sm mb-1"><i class="fa fa-edit"></i> Modifier </a>

                        <a onclick="return confirm('Supprimer?')" href="{{ URL::route('personnel_destroy', $agen->id) }}" class="btn btn-danger btn-sm mb-1"><i class="fa fa-trash"></i> Supprimer </a>
@endif                       
                      </td>

                    </tr>

                    @endforeach
                  </tbody>
                  </table>
               </div>







    </div>
  </div>
</div>

                          
</div><!-- END row -->




@stop



@section('JS') 

@if(isset($_GET['agent_id']))
<script type="text/javascript">
$('#allowed_charges').val(<?php echo json_encode($allowed_charges); ?>);
</script>


<script type="text/javascript">
$(document).ready(function () { 
  
  $('#is_charges_agent').on('change',function(eg){

    var egg = eg.target.value;

    if (egg == 1) {
      $("#allowed_charges").attr('required', 'required');
    } else {
      $("#allowed_charges").removeAttr('required');
    }

  });

});
</script>


@endif




<script src="{{url('/')}}/assets/vendor/datepicker/moment.js"></script>
<script src="{{url('/')}}/assets/vendor/datepicker/tempusdominus-bootstrap-4.js"></script>
<script src="{{url('/')}}/assets/vendor/datepicker/datepicker.js"></script>

<script src="{{url('/')}}/assets/vendor/datepicker/fr.js"></script>

<script type="text/javascript">
     $(function () {
        $('#datetimepickerdateHon').datetimepicker({
          format: 'DD/MM/YYYY',
          locale: 'fr'
      });
    });

</script>


@stop