@extends('layouts.master_panel')

@section('title') Classes et matières @stop

@section('CSS') 


<link rel="stylesheet" type="text/css" href="{{url('/')}}/js/datatables/dataTables.bootstrap4.min.css">

@stop

@section('JS') 


<script src="{{url('/')}}/js/datatables/jquery.dataTables.min.js"></script>
<script src="{{url('/')}}/js/datatables/dataTables.bootstrap4.min.js"></script>

<script type="text/javascript" class="init">
  $(document).ready(function() {
    $("#example1").dataTable({ "language": { "url": "{{ url('/') }}/js/datatables/lang/fr.json" },

      "lengthChange": true,
      "pageLength": 5
    });

    $("#example2").dataTable({ "language": { "url": "{{ url('/') }}/js/datatables/lang/fr.json" },

      "lengthChange": true,
      "pageLength": 5
    });

    $("#example3").dataTable({ "language": { "url": "{{ url('/') }}/js/datatables/lang/fr.json" },

      "lengthChange": true,
      "pageLength": 5
    });

  });
</script>



<script type="text/javascript">
      

        $('#myForm').submit(function(event) {

          event.preventDefault();

          $('#resultajax').append('<div class="text-center"><img src="{{ url("/") }}/assets/images/loader.gif" alt="ajouter..." /></div>');

          $('#submit').hide();

          
           $.ajax({
            type: 'POST',
            url: '{{ route("subject_store") }}',
            data: $(this).serialize(),

            success: function(data) {

              $('#classID').selectpicker('deselectAll');
                              
                if(data == 'true') {   
                  $('#resultajax').html("<div class='alert alert-success text-center'><strong>Ajouter avec succès</strong></div>");
                  $('#submit').show();
                 }

                if(data == 'false') {
                  $('#resultajax').html("<div class='alert alert-danger text-center'><strong>Une erreur est survenue .. réessayer</strong></div>");
                  $('#submit').show();
                }
                                     
              }

            });
                          
          });

          function refresh() {
            // to current URL
            window.location='{{ URL::current() }}';
          }

</script>


@stop


@section('content')


                  <!-- ============================================================== -->
                  <!-- pageheader  -->
                  <!-- ============================================================== -->
                  <div class="row">
                      <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                          <div class="page-header">
                              <h3 class="mb-2">Classes et matières </h3>
                           
                              <div class="page-breadcrumb">
                                  <nav aria-label="breadcrumb">
                                      <ol class="breadcrumb">
                                          <li class="breadcrumb-item"><a href="{{ URL::route('admin_index') }}" class="breadcrumb-link">Accueil</a></li>
                                          <li class="breadcrumb-item active" aria-current="page">Classes et matières</li>
                                      </ol>
                                  </nav>
                              </div>
                          </div>
                      </div>
                  </div>
                  <!-- ============================================================== -->
                  <!-- end pageheader  -->
                  <!-- ============================================================== -->


<div class="row">

<div class="col-md-12">
@if(Session::has('error'))

<div class="alert alert-danger alert-dismissible fade show text-center" role="alert">
  <strong>{{ Session::get('error') }}</strong>
  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
    <span aria-hidden="true">&times;</span>
  </button>
</div>

@endif

@if(Session::has('success'))
<div class="alert alert-success alert-dismissible fade show text-center" role="alert">
  <strong>{{ Session::get('success') }}</strong>
  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
    <span aria-hidden="true">&times;</span>
  </button>
</div>
@endif
</div>
<div class="clearfix"></div>




<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
  <div class="card">
    <h5 class="card-header">
@if(!isset($_GET['class_id']))

@if(auth()->user()->super_admin == 1)
      <a href="#" class="btn btn-primary mb-1" data-toggle="modal" data-target="#exampleModal"><i class="fa fa-plus"></i> Ajouter Classe </a>
@endif

@endif
    </h5>
  <div class="card-body">



@if(isset($_GET['class_id']))

<?php $getClasse = \App\Classes::find(e($_GET['class_id'])); ?>

@if($getClasse !== null)


<form method="POST" action="{{ URL::route('classe_update', $getClasse->id) }}">

{{ csrf_field() }}


  <div class="col-md-12 mb-3">
    <div class="form-group">
    <label>Nom</label>
    <input name="name" type="text" class="form-control input-lg" value="{{ $getClasse->name }}" required>
    </div>
  </div>

  <div class="col-md-12 mb-3">
      <button class="btn btn-success btn-block" type="submit">Modifier</button>
  </div>


</form>

<div class="clear"></div><hr>

@endif

@else

<!-- Modal -->
<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
<div class="modal-dialog modal-lg" role="document">
  <div class="modal-content">
    <div class="modal-header">
      <h5 class="modal-title" id="exampleModalLabel">Ajouter Classe</h5>
      <a href="#" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></a>
    </div>
    <div class="modal-body">

<form method="POST" action="{{ URL::route('classes_store') }}">

{{ csrf_field() }}

  <div class="col-md-12 mb-3">
    <div class="form-group">
    <label>Nom</label>
    <input name="name" type="text" class="form-control input-lg" value="{{ old('name') }}" required>
    </div>
  </div>

<div class="col-md-12 mb-3">
    <button class="btn btn-success btn-block" type="submit">Ajouter</button>
</div>


</form>

    </div>
    <div class="modal-footer">
      <a href="#" class="btn btn-dark" data-dismiss="modal">Fermer</a>
    </div>
  </div>
</div>
</div>
<!-- End Modal -->

@endif
  
<div class="clearfix"></div>


        <div class="table-responsive">
          <table id="example2" class="table table-striped table-bordered first">
            <thead>
            <tr class="text-uppercase">
              <th >Classes</th>
              <th>Action</th>
            </tr>
            </thead>
            <tbody>

             @foreach($classes as $classe)
                <tr>
                                                
                  <td>{{ $classe->name }}</td>

                  <td>

@if(auth()->user()->super_admin == 1)
                        <a href="{{ URL::current() . '?class_id=' . $classe->id }}" class="btn btn-success btn-sm"><i class="fa fa-edit"></i>  </a>

                        <a onclick="return confirm('Supprimer?')" href="{{ URL::route('classe_destroy', $classe->id) }}" class="btn btn-danger btn-sm"><i class="fa fa-trash"></i>  </a>
@endif                    
                    </td>

                  </tr>

                    @endforeach
                  </tbody>
                  </table>
            </div>


    </div>
  </div>
</div><!-- Classes --->



<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
  <div class="card">
    <h5 class="card-header">

@if(auth()->user()->super_admin == 1)
      <a href="#" class="btn btn-primary mb-1" data-toggle="modal" data-target="#exampleModalSub"><i class="fa fa-plus"></i> Ajouter matière </a>
@endif

    </h5>
  <div class="card-body">


<!-- Modal -->
<div class="modal fade" id="exampleModalSub" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabelSub" aria-hidden="true">
<div class="modal-dialog modal-lg" role="document">
  <div class="modal-content">
    <div class="modal-header">
      <h5 class="modal-title" id="exampleModalLabelSub">Ajouter matière</h5>
      <a href="#" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></a>
    </div>
    <div class="modal-body">

<form method="POST" action="{{ URL::route('subject_names_store') }}">

{{ csrf_field() }}

  <div class="col-md-12 mb-3">
    <div class="form-group">
    <label>Nom</label>
    <input name="sub_name" type="text" class="form-control input-lg" value="{{ old('sub_name') }}" required>
    </div>
  </div>

<div class="col-md-12 mb-3">
    <button class="btn btn-success btn-block" type="submit">Ajouter</button>
</div>


</form>

    </div>
    <div class="modal-footer">
      <a href="#" class="btn btn-dark" data-dismiss="modal">Fermer</a>
    </div>
  </div>
</div>
</div>
<!-- End Modal -->

  
<div class="clearfix"></div>


        <div class="table-responsive">
          <table id="example1" class="table table-striped table-bordered first">
            <thead>
            <tr class="text-uppercase">
              <th>Matière</th>
              <th>Action</th>
            </tr>
            </thead>
            <tbody>

             @foreach($subject_names as $subject_name)
                <tr>
                                                
                  <td>{{ $subject_name->name }}</td>

                  <td>

@if(auth()->user()->super_admin == 1)
                     <a class="btn btn-success btn-sm" href="#" data-toggle="modal" data-target="#editsub-{{ $subject_name->id }}"><i class="fa fa-edit"></i></a>

                      <a onclick="return confirm('Supprimer?')" href="{{ URL::route('subject_names_destroy', $subject_name->id) }}" class="btn btn-danger btn-sm"><i class="fa fa-trash"></i>  </a>
@endif

<!-- Modal -->
<div class="modal fade" id="editsub-{{ $subject_name->id }}" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabelperso-{{ $subject_name->id }}" aria-hidden="true">
<div class="modal-dialog modal-lg" role="document">
  <div class="modal-content">
    <div class="modal-header">
      <h5 class="modal-title" id="exampleModalLabelperso-{{ $subject_name->id }}">Modifier</h5>
      <a href="#" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></a>
    </div>
    <div class="modal-body">

      
<form method="POST" action="{{ route('subject_names_update', $subject_name->id) }}" >

@csrf


<div class="form-row">

  <div class="col-md-12 mb-3">
    <label>Matière:</label>
    <div class="form-group">
    <div class="input-group">

    <input name="subname_up" type="text" class="form-control" value="{{ $subject_name->name }} " />
    
      <div class="input-group-append">
      <div class="input-group-text"><i class="fa fa-info-circle"></i></div>
      </div>
    </div>
  </div>
  </div>

</div>

<div class="form-row">
<div class="col-md-12">
    <button class="btn btn-success btn-block" type="submit" >Modifier</button>
</div>
</div>

</form>
   
    </div>
    <div class="modal-footer">
      <a href="#" class="btn btn-dark" data-dismiss="modal">Fermer</a>
    </div>
  </div>
</div>
</div>
<!-- End Modal -->


                    </td>

                  </tr>

                    @endforeach
                  </tbody>
                  </table>
            </div>


    </div>
  </div>
</div><!-- matières --->





<?php /* ?>




<div id="Affectation" class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
  <div class="card">
    <h5 class="card-header">
@if(!isset($_GET['subject_id']))

@if(auth()->user()->super_admin == 1)
      <a href="#" class="btn btn-primary mb-1" data-toggle="modal" data-target="#exampleModal2"><i class="fas fa-sync-alt"></i> Affectation Enseignants-Matières</a>
@endif

@endif
    </h5>
  <div class="card-body">


@if(isset($_GET['subject_id']))

<?php $getSubject = \App\Subjects::find(e($_GET['subject_id'])); ?>

@if($getSubject !== null)


<form method="POST" action="{{ URL::route('subject_update', $getSubject->id) }}">

{{ csrf_field() }}


<div class="col-md-12 mb-3">
    <div class="form-group">
    <label>Matière:</label>

    <select name="subject_name" class="selectpicker" data-width="100%" required="required">
        <option selected="selected" value="{{ $getSubject->name }}">{{ $getSubject->name }}</option>
        @foreach($subject_names as $sub_name)
        <option value="{{ $sub_name->name }}">{{ $sub_name->name }}</option>
        @endforeach
    </select>

    </div>
</div>


<div class="col-md-12 mb-3">
    <label>Enseignants:</label>
    <select name="teacher_id_up" class="selectpicker" data-width="100%" required="required">
        <option selected="selected" value="{{ $getSubject->teacher->id }}">{{ $getSubject->teacher->last_name . ' ' . $getSubject->teacher->first_name}}</option>
        @foreach($enseignants as $enseign)
        <option value="{{ $enseign->id }}">{{ $enseign->last_name . ' ' . $enseign->first_name }}</option>
        @endforeach
    </select>
</div>

<div class="col-md-12 mb-5">
    <label>Classes:</label>
    <select name="class_id_up" class="selectpicker" data-width="100%" required="required" >
      <option selected="selected" value="{{ $getSubject->classe->id }}">{{ $getSubject->classe->name }}</option>
        @foreach($classes as $clas)
        <option value="{{ $clas->id }}">{{ $clas->name }}</option>
        @endforeach
    </select>
</div>


<div class="col-md-12 mb-3">
    <button class="btn btn-success btn-block" type="submit">Modifier</button>
</div>


</form>

<div class="clear"></div><hr>

@endif

@else

<!-- Modal -->
<div class="modal fade" id="exampleModal2" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel2" aria-hidden="true">
<div class="modal-dialog modal-lg" role="document">
  <div class="modal-content">
    <div class="modal-header">
      <h5 class="modal-title" id="exampleModalLabel2">Affectation Enseignants-Matières</h5>
      <a  onclick="refresh();" href="#" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></a>
    </div>
    <div class="modal-body">

<form method="POST" action="#" id="myForm">

{{ csrf_field() }}

<div class="col-md-12" id="resultajax">

</div>

<div class="col-md-12 mb-3">
    <div class="form-group">
    <label>Matière:</label>

    <select name="subject_name" class="selectpicker" data-width="100%" required="required">
        <option value="">Choisir</option>
        @foreach($subject_names as $sub_name)
        <option value="{{ $sub_name->name }}">{{ $sub_name->name }}</option>
        @endforeach
    </select>

    </div>
</div>



<div class="col-md-12 mb-3">
    <label>Enseignants:</label>
    <select name="teacher_id" class="selectpicker" data-width="100%" required="required">
        <option value="">Choisir</option>
        @foreach($enseignants as $enseign)
        <option value="{{ $enseign->id }}">{{ $enseign->last_name . ' ' . $enseign->first_name }}</option>
        @endforeach
    </select>
</div>

<div class="col-md-12 mb-5">
    <label>Classes:</label>
    <select name="class_id[]" class="selectpicker" data-width="100%" required="required" multiple="multiple" title="Choisir" id="classID" >
        @foreach($classes as $clas)
        <option value="{{ $clas->id }}">{{ $clas->name }}</option>
        @endforeach
    </select>
</div>


<div class="col-md-12 mb-3">
    <button class="btn btn-success btn-block" type="submit" id="submit">Ajouter</button>
</div>


</form>

    </div>
    <div class="modal-footer">
      <a  onclick="refresh();" href="#" class="btn btn-dark" data-dismiss="modal">Fermer</a>
    </div>
  </div>
</div>
</div>
<!-- End Modal -->

@endif
  
<div class="clearfix"></div>



        <div class="table-responsive">
          <table id="example3" class="table table-striped table-bordered first">
            <thead>
            <tr class="text-uppercase">
              <th >Matière</th>
              <th >Classe</th>
              <th >Enseignant</th>
              <th>Action</th>
            </tr>
            </thead>
            <tbody>

             @foreach($subjects as $subject)
                <tr>
                                                
                  <td>{{ $subject->name }}</td>
                  <td>{{ $subject->classe->name }}</td>
                  <td>{{ $subject->teacher->last_name . ' ' . $subject->teacher->first_name }}</td>

                  <td>
@if(auth()->user()->super_admin == 1)
                        <a href="{{ URL::current() . '?subject_id=' . $subject->id }}#Affectation" class="btn btn-success btn-sm"><i class="fa fa-edit"></i>  </a>

                        <a onclick="return confirm('Supprimer?')" href="{{ URL::route('subject_destroy', $subject->id) }}" class="btn btn-danger btn-sm"><i class="fa fa-trash"></i>  </a>
@endif                    
                    </td>

                  </tr>

                    @endforeach
                  </tbody>
                  </table>
            </div>


    </div>
  </div>
</div><!-- Affectation Enseignants-Matières --->





<?php */ ?>


                          
</div><!-- END row -->
                
               

@stop