<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App;
use View;
use Hash;
use Redirect;
use Validator;
use Response;
use Auth;
use Illuminate\Validation\Rule;
use App\User;
use App\Settings;

use App\PersonnelCatg;

use App\Pointage;

use Excel;
use App\Imports\UsersImport;

use App\Imports\StudentsImport;

use Illuminate\Support\Facades\DB;

class PersonnelController extends Controller
{



    public function __construct()
    {
    //    $this->middleware('auth');
    }



/*============
    agents role
=============*/


    public function agents_role()
    {   

        if(auth()->user()->is_root_admin == 1) {
            $agents = User::where('is_personnel', true)->orderBy('id', 'desc')->get();
            return View::make('agents.index', compact('agents'));
        } else {
            Auth::logout();
            return Redirect::route('login');
        }
    
    }


    public function store_agents_role(Request $request)
    {   
        
        $inputs = $request->all();


        $validation = Validator::make($inputs, [

          'last_name'=>'required',
          'first_name'=>'required',
          'username'=>'required|unique:users',
          'email'=>'unique:users',
          'password'=>'required',
        
        ]); 

        if ($validation->fails()) {
            return Redirect::back()->withInput()->withErrors($validation);
        } 

        else {


            $barcode = date('Y').rand(11111, 99999);

            $checkBarcode = User::where('barcode', $barcode)->first();

            if ($checkBarcode !== null) {
                return Redirect::back()->with('error', 'Error! try again..');
                die();
            }

            $destinationPath = public_path().'/uploads/images';
            $whitelist = array("jpg","JPG","jpeg","JPEJ","gif","png","PNG");

    
            if ($request->hasFile('image')) {

                if (!(in_array($request->file('image')->extension(), $whitelist))) {
                    return Redirect::back()->withInput()->withError('Extension non autorisée');
                    die();
                } else {

                    $image = round(microtime(true)) .'.'. $request->file('image')->extension();

                    $request->file('image')->move($destinationPath, $image);
                }

            } else {
                $image = null;
            }


            $personnel = User::create([

                'is_personnel' => 1,

                'is_absences_agent' => e($inputs['is_absences_agent']),
                'is_archives_agent' => e($inputs['is_archives_agent']),
                'is_historiqueabs_agent' => e($inputs['is_historiqueabs_agent']),
                'is_pointage_agent' => e($inputs['is_pointage_agent']),
                'is_renseignm_agent' => e($inputs['is_renseignm_agent']),
                'is_charges_agent' => e($inputs['is_charges_agent']),

                'is_demandedocs_agent' => e($inputs['is_demandedocs_agent']),
                'is_assiduite_agent' => e($inputs['is_assiduite_agent']),
                
                'is_affectation_agent' => e($inputs['is_affectation_agent']),

                'last_name' => e($inputs['last_name']),
                'first_name' => e($inputs['first_name']),
                'email' => e($inputs['email']),
                'phone' => e($inputs['phone']),
                'username' => e($inputs['username']),
                'password' => Hash::make(e($inputs['password'])),
                'image' => $image,
                'barcode' => $barcode,

                'date_expire_passe' => e($inputs['date_expire_passe']),
                


            ]);

            $personnel->save();


            return Redirect::back()->withSuccess('Ajouter avec succès');

        }

        
    
    }


    public function update_agents_role($id, Request $request)
    { 
        $personnel = User::find($id);

        $inputs = $request->all();

        if ($personnel !== null) {

            $validation = Validator::make($inputs, [
              'last_name'=>'required',
              'first_name'=>'required',
              'email'=>'unique:users,email,'.$personnel->id,
            ]); 

            if ($validation->fails()) {
                return Redirect::back()->withInput()->withErrors($validation);
            } 

            else {

                $destinationPath = public_path().'/uploads/images';
                $whitelist = array("jpg","JPG","jpeg","JPEJ","gif","png","PNG");

                if ($request->hasFile('image')) {

                    if (!(in_array($request->file('image')->extension(), $whitelist))) {
                        return Redirect::back()->withInput()->withError('Extension non autorisée');
                        die();
                    } else {

                        // delete old image
                        if (!empty($personnel->image)) {
                            unlink(public_path()."/uploads/images/".$personnel->image);
                        }

                        $image = round(microtime(true)) .'.'. $request->file('image')->extension();

                        $request->file('image')->move($destinationPath, $image);

                        $personnel->image = $image;
                    }

                } 

    $personnel->is_absences_agent = e($inputs['is_absences_agent']);
    $personnel->is_archives_agent = e($inputs['is_archives_agent']);
    $personnel->is_historiqueabs_agent = e($inputs['is_historiqueabs_agent']);
    $personnel->is_pointage_agent = e($inputs['is_pointage_agent']);
    $personnel->is_renseignm_agent = e($inputs['is_renseignm_agent']);
    $personnel->is_charges_agent = e($inputs['is_charges_agent']);
    $personnel->is_demandedocs_agent = e($inputs['is_demandedocs_agent']);
    $personnel->is_assiduite_agent = e($inputs['is_assiduite_agent']);
    $personnel->is_affectation_agent = e($inputs['is_affectation_agent']);

    $personnel->last_name = e($inputs['last_name']);
    $personnel->first_name = e($inputs['first_name']);
    $personnel->email = e($inputs['email']);
    $personnel->phone = e($inputs['phone']);

    if (e($inputs['is_charges_agent']) == 1) {
        $allowed_charges = implode(",", $inputs['agent_allowed_charges']);
        $personnel->agent_allowed_charges = $allowed_charges;
    } else {
        $personnel->agent_allowed_charges = null;
    } 

    $personnel->save();

                return Redirect::route('agents_role')->withSuccess('Mise à jour avec succès');

            }

        } else {
            return View::make('404');
        }
    }



/*============
    personnel
=============*/



    public function personnel()
    {   
        $settings = Settings::first();

        $personnel_catg = PersonnelCatg::orderBy('id', 'asc')->get();

        $personnel = User::where('is_personnel', true)->orderBy('id', 'desc')->get();

        return View::make('admin.personnel', compact('personnel', 'personnel_catg'));
            
    }


    public function personnel_store(Request $request)
    {   
        
        $inputs = $request->all();


        $validation = Validator::make($inputs, [

          'last_name'=>'required',
          'first_name'=>'required',
          'username'=>'required|unique:users',
          'email'=>'unique:users',
          'password'=>'required',
        
        ]); 

            if ($validation->fails()) {

                return Redirect::back()->withInput()->withErrors($validation);

            } 

            else {



            $barcode = date('Y').rand(11111, 99999);

            $checkBarcode = User::where('barcode', $barcode)->first();

            if ($checkBarcode !== null) {
                return Redirect::back()->with('error', 'Error! try again..');
                die();
            }

            $destinationPath = public_path().'/uploads/images';
            $whitelist = array("jpg","JPG","jpeg","JPEJ","gif","png","PNG");

    
            if ($request->hasFile('image')) {

                if (!(in_array($request->file('image')->extension(), $whitelist))) {
                    return Redirect::back()->withInput()->withError('Extension non autorisée');
                    die();
                } else {

                    $image = round(microtime(true)) .'.'. $request->file('image')->extension();

                    $request->file('image')->move($destinationPath, $image);
                }

            } else {
                $image = null;
            }


            $personnel = User::create([

                'is_personnel' => 1,

                'personnel_catg' => e($inputs['catg_id']),

                'last_name' => e($inputs['last_name']),
                'first_name' => e($inputs['first_name']),
                'email' => e($inputs['email']),
                'phone' => e($inputs['phone']),
                'username' => e($inputs['username']),
                'password' => Hash::make(e($inputs['password'])),
                'image' => $image,
                'barcode' => $barcode,


            ]);

            $personnel->save();


            return Redirect::back()->withSuccess('Ajouter avec succès');

            }

    }



    public function personnel_edit($id)
    { 
        $personnel = User::find($id);

        if ($personnel !== null) {

            $personnel_catg = PersonnelCatg::orderBy('id', 'asc')->get();

            return View::make('admin.personnel_edit', compact('personnel', 'personnel_catg'));
        } else {
            return View::make('404');
        }
    }


    public function personnel_update($id, Request $request)
    { 
        $personnel = User::find($id);

        $inputs = $request->all();

        if ($personnel !== null) {

        
            $validation = Validator::make($inputs, [
              'last_name'=>'required',
              'first_name'=>'required',
              'email'=>'unique:users,email,'.$personnel->id,
            ]); 

            if ($validation->fails()) {

                return Redirect::back()->withInput()->withErrors($validation);

            } 

            else {

                $destinationPath = public_path().'/uploads/images';
                $whitelist = array("jpg","JPG","jpeg","JPEJ","gif","png","PNG");

                if ($request->hasFile('image')) {



                    if (!(in_array($request->file('image')->extension(), $whitelist))) {
                        return Redirect::back()->withInput()->withError('Extension non autorisée');
                        die();
                    } else {

                        // delete old image
                        if (!empty($personnel->image)) {
                            unlink(public_path()."/uploads/images/".$personnel->image);
                        }

                        $image = round(microtime(true)) .'.'. $request->file('image')->extension();

                        $request->file('image')->move($destinationPath, $image);

                        $personnel->image = $image;
                    }

                } 


                $personnel->personnel_catg = e($inputs['catg_id']);
                
                $personnel->last_name = e($inputs['last_name']);
                $personnel->first_name = e($inputs['first_name']);

                $personnel->email = e($inputs['email']);
                $personnel->phone = e($inputs['phone']);


                $personnel->save();

                return Redirect::back()->withSuccess('Mise à jour avec succès');

            }

        } else {
            return View::make('404');
        }
    }


    public function personnel_password_update($id, Request $request)
    { 
        $personnel = User::find($id);

        $inputs = $request->all();

        if ($personnel !== null) {


            $validation = Validator::make($inputs, [
              'date_expire_passe'=>'required',
              'username'=>'unique:users,username,'.$personnel->id,
            ]); 

            if ($validation->fails()) {

                return Redirect::back()->withInput()->withErrors($validation);

            } 

            else {

    
                $personnel->username = e($inputs['username']);
                $personnel->password = Hash::make(e($inputs['password']));

                $personnel->date_expire_passe = e($inputs['date_expire_passe']);

                $personnel->save();

                return Redirect::back()->withSuccess('Mise à jour avec succès');

            }

        } else {
            return View::make('404');
        }
    }


    public function personnel_destroy($id)
    { 
        $personnel = User::find(e($id));

        if ($personnel !== null) {


            //---> DemandeDocsParent
            $DemandeDocsParent = \App\DemandeDocsParent::where('agent_id', $personnel->id)->update(['agent_id' => null]);

            //---> AbsencesStudents
            $Absences = \App\AbsencesStudents::where('agent_id', $personnel->id)->update(['agent_id' => 1]);

            //---> EmailContent
            \App\EmailContent::where('user_id', $personnel->id)->delete();
            
            //---> Pointage
            Pointage::where('personnel_id', $personnel->id)->delete();

            if (!empty($personnel->image)) {
                unlink(public_path()."/uploads/images/".$personnel->image);
            }

            $personnel->delete();

            return Redirect::back()->withError('Supprimé avec succès');

           
        } else {
            return View::make('404');
        }
    }





}