<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App;
use View;
use Hash;
use Redirect;
use Validator;
use Response;
use Auth;
use Illuminate\Validation\Rule;
use App\User;
use App\Settings;
use App\Folders;
use App\EnseignantsFiles;
use App\Historique;

use App\Classes;
use App\Subjects;
use App\SubjectNames;

use App\Repartition;
use App\CahierJournal;
use App\Devoirs;

use App\Pointage;
use App\HorairesTravail;
use App\Horaires;

use App\Evaluations;
use App\DevoirsAlerts;
use App\DevoirsNotification;
use App\Assiduite;
use App\AssiduiteMotifs;

use App\ControleContinu;
use App\ControleContinuEvaluations;

use App\CompteRendu;

use App\RessourcesNotification;

use App\AbsenceRequest;

use App\Emploi;

use App\GrilleEvaluation;

use App\DocumentsNames;
use App\DemandesDocuments;

use App\DemandesRencontre;

use Excel;
use App\Imports\UsersImport;
use App\Imports\HorairesImport;

use Illuminate\Support\Facades\DB;

class EnseignantsController extends Controller
{



    public function __construct()
    {
    //    $this->middleware('auth');
    }




    public function enseignants()
    {   
        $horaires = Horaires::orderBy('hour_id', 'asc')->get();
        $enseignants = User::where('is_teacher', true)->orderBy('last_name', 'asc')->get();
        return View::make('admin.enseignants', compact('enseignants', 'horaires'));
            
    }


    public function enseignants_importer(Request $request)
    {   
        
        $inputs = $request->all();


        $validation = Validator::make($inputs, ['file'=>'required']); 

            if ($validation->fails()) {

                return Redirect::back()->withInput()->withErrors($validation);

            } 

            else {

            $whitelist = array("xlsx","xls","XLS","XLSX");

            if ($request->hasFile('file')) {

                if (!(in_array($request->file('file')->extension(), $whitelist))) {
                    return Redirect::back()->withInput()->withError('Extension non autorisée');
                    die();
                } else {


                //    Excel::import(new UsersImport, request()->file('file'));


                    $import = new UsersImport();
                //    $import->onlySheets('Worksheet1');

                    Excel::import($import, request()->file('file'));

                //    return var_dump($import);
     



                }

            } 




            return Redirect::back()->withSuccess('Importé avec succèss');

            }

    }


    public function enseignants_store(Request $request)
    {   
        
        $inputs = $request->all();


        $validation = Validator::make($inputs, [

          'last_name'=>'required',
          'first_name'=>'required',
          'username'=>'required|unique:users',
          'email'=>'email|unique:users',
          'password'=>'required',
        
        ]); 

            if ($validation->fails()) {

                return Redirect::back()->withInput()->withErrors($validation);

            } 

            else {

            $barcode = date('Y').rand(11111, 99999);

            $checkBarcode = User::where('barcode', $barcode)->first();

            if ($checkBarcode !== null) {
                return Redirect::back()->with('error', 'Error! try again..');
                die();
            }


            $destinationPath = public_path().'/uploads/images';
            $whitelist = array("jpg","JPG","jpeg","JPEJ","gif","png","PNG");

    
            if ($request->hasFile('image')) {

                if (!(in_array($request->file('image')->extension(), $whitelist))) {
                    return Redirect::back()->withInput()->withError('Extension non autorisée');
                    die();
                } else {

                    $image = round(microtime(true)) .'.'. $request->file('image')->extension();

                    $request->file('image')->move($destinationPath, $image);
                }

            } else {
                $image = null;
            }


            $enseignant = User::create([

                'is_teacher' => 1,

                'teacher_type' => e($inputs['teacher_type']),

                'last_name' => e($inputs['last_name']),
                'first_name' => e($inputs['first_name']),
                'email' => e($inputs['email']),
                'phone' => e($inputs['phone']),
                'username' => e($inputs['username']),
                'password' => Hash::make(e($inputs['password'])),
                'image' => $image,
                'barcode' => $barcode,
                


            ]);

            $enseignant->save();


            return Redirect::back()->withSuccess('Ajouter avec succès');

            }

    }



    public function enseignant_edit($id)
    { 
        $enseignant = User::find($id);

        if ($enseignant !== null) {

            $horaires_travail = HorairesTravail::where('teacher_id', $enseignant->id)->get();

            return View::make('admin.enseignant_edit', compact('enseignant', 'horaires_travail'));
        } else {
            return View::make('404');
        }
    }




    public function enseignant_update($id, Request $request)
    { 
        $enseignant = User::find($id);

        $inputs = $request->all();

        if ($enseignant !== null) {

            

            $validation = Validator::make($inputs, [

              'last_name'=>'required',
              'first_name'=>'required',
              'email'=>'unique:users,email,'.$enseignant->id,
            ]); 

            if ($validation->fails()) {

                return Redirect::back()->withInput()->withErrors($validation);

            } 

            else {

                $destinationPath = public_path().'/uploads/images';
                $whitelist = array("jpg","JPG","jpeg","JPEJ","gif","png","PNG");

                if ($request->hasFile('image')) {



                    if (!(in_array($request->file('image')->extension(), $whitelist))) {
                        return Redirect::back()->withInput()->withError('Extension non autorisée');
                        die();
                    } else {

                        // delete old image
                        if (!empty($enseignant->image)) {
                            unlink(public_path()."/uploads/images/".$enseignant->image);
                        }

                        $image = round(microtime(true)) .'.'. $request->file('image')->extension();

                        $request->file('image')->move($destinationPath, $image);

                        $enseignant->image = $image;
                    }

                } 


                $enseignant->teacher_type = e($inputs['teacher_type']);
                
                $enseignant->last_name = e($inputs['last_name']);
                $enseignant->first_name = e($inputs['first_name']);
                $enseignant->email = e($inputs['email']);
                $enseignant->phone = e($inputs['phone']);
                
                $enseignant->taux_horaire = e($inputs['taux_horaire']);

                $enseignant->save();

                return Redirect::back()->withSuccess('Mise à jour avec succès');

            }

        } else {
            return View::make('404');
        }
    }


    public function enseignant_password_update($id, Request $request)
    { 
        $enseignant = User::find($id);

        $inputs = $request->all();

        if ($enseignant !== null) {


            $validation = Validator::make($inputs, [
              'username'=>'unique:users,username,'.$enseignant->id,
            ]); 

            if ($validation->fails()) {

                return Redirect::back()->withInput()->withErrors($validation);

            } 

            else {

    
                $enseignant->username = e($inputs['username']);
                $enseignant->password = Hash::make(e($inputs['password']));

                $enseignant->save();

                return Redirect::back()->withSuccess('Mise à jour avec succès');

            }

        } else {
            return View::make('404');
        }
    }


    public function enseignant_destroy($id)
    { 
        $enseignant = User::find(e($id));

        if ($enseignant !== null) {


            //---> Simili
            $similis = \App\Simili::where('teacher_id', $enseignant->id)->get();
            foreach ($similis as $simil) {
                \App\SimiliEvaluations::where('simili_id', $simil->id)->delete();
                $simil->delete();
            }
            

            //---> SuiviPreparation
            \App\SuiviPreparation::where('teacher_id', $enseignant->id)->delete();
            
            //---> SeanceEnseignants
            \App\SeanceEnseignants::where('teacher_id', $enseignant->id)->delete();


            $rencontres = \App\DemandesRencontre::where('teacher_id', $enseignant->id)->get();

            foreach ($rencontres as $rencont) {
                \App\DemandesRencontreStds::where('rencontre_id', $rencont->id)->delete();
                $rencont->delete();
            }



            //---> PointageHeuresTravail
            \App\PointageHeuresTravail::where('teacher_id', $enseignant->id)->delete();

            //---> GrilleEvaluation
            GrilleEvaluation::where('teacher_id', $enseignant->id)->delete();

            //---> AbsencesStudents
            \App\AbsencesStudents::where('teacher_id', $enseignant->id)->delete();

            
            //---> DemandesDocuments
            DemandesDocuments::where('teacher_id', $enseignant->id)->delete();
            

            // Emploi
            $OLDemploi = Emploi::where('teacher_id', $enseignant->id)->first();

            if ($OLDemploi !== null) {

               if (!empty($OLDemploi->fichier)) {
                    unlink(public_path()."/uploads/emploi/".$OLDemploi->fichier);
                }

                $OLDemploi->delete();
            }



            $ControleContinu = ControleContinu::where('teacher_id', $enseignant->id)->get();

            foreach ($ControleContinu as $ControleCont) {

                ControleContinuEvaluations::where('control_id', $ControleCont->id)->delete();

                $ControleCont->delete();

            }


            //---> EnseignantsHeures

            $EnseignantsHeures = \App\EnseignantsHeures::where('teacher_id', $enseignant->id)->get();

            foreach ($EnseignantsHeures as $EnseignantHeur) {

                \App\HeuresEffectuees::where('teacher_id', $EnseignantHeur->teacher_id)->where('class_id', $EnseignantHeur->class_id)->where('subject_id', $EnseignantHeur->subject_id)->delete();

                $EnseignantHeur->delete();

            }



            //---> AbsenceRequest
            AbsenceRequest::where('teacher_id', $enseignant->id)->delete();


            //---> EmailContent
            \App\EmailContent::where('user_id', $enseignant->id)->delete();
            

            //---> CompteRendu
            CompteRendu::where('teacher_id', $enseignant->id)->delete();

            //---> Assiduite
            Assiduite::where('teacher_id', $enseignant->id)->delete();

            //---> Evaluations
            Evaluations::where('teacher_id', $enseignant->id)->delete();

            //---> HorairesTravail
            HorairesTravail::where('teacher_id', $enseignant->id)->delete();

            //---> Pointage
            Pointage::where('teacher_id', $enseignant->id)->delete();

            //---> Subjects
            Subjects::where('teacher_id', $enseignant->id)->delete();


            //---> CahierJournal
            CahierJournal::where('teacher_id', $enseignant->id)->orderBy('id', 'desc')->delete();

            //---> Repartition
            Repartition::where('teacher_id', $enseignant->id)->orderBy('id', 'desc')->delete();

            //---> Devoirs
            $devoirs = Devoirs::where('teacher_id', $enseignant->id)->orderBy('id', 'desc')->get();

            //---> DevoirsAlerts
            DevoirsAlerts::where('teacher_id', $enseignant->id)->delete();

            foreach ($devoirs as $devoir) {

                if (!empty($devoir->file_join)) {
                    unlink(public_path()."/uploads/devoirs/".$devoir->file_join);
                }

                $devoir->delete();

                
            }


            //---> add his Files to the admin
            EnseignantsFiles::where('teacher_id', $enseignant->id)->update(['teacher_id' => 1]);


            //---> add his Folders to the admin
            Folders::where('teacher_id', $enseignant->id)->update(['teacher_id' => 1]);



            Historique::where('teacher_id', $enseignant->id)->delete();

            if (!empty($enseignant->image)) {
                unlink(public_path()."/uploads/images/".$enseignant->image);
            }



            $enseignant->delete();

            return Redirect::back()->withError('Supprimé avec succès');


           
        } else {
            return View::make('404');
        }
    }




/*---------------------

 Horaires Travail

---------------------*/


    public function ajax_enseignant_classes(Request $request)
    {  
        $inputs = $request->all();


        $settings = Settings::first();

        $subjects = Subjects::where('year_id', $settings->default_year)->where('teacher_id', e($inputs['teacher_id']))->get();

        $classes_ids = array();
        foreach ($subjects as $subject) {
            $classes_ids[] = $subject->classe->id;
        }
   
        $classes = Classes::whereIn('id', $classes_ids)->where('year_id', $settings->default_year)->pluck('id', 'name');

        return response()->json($classes);

    }


    public function enseignant_horaires(Request $request)
    {   
        
        $inputs = $request->all();

        $validation = Validator::make($inputs, [
          'teacher_id'=>'required',
          'day_id'=>'required',
        ]); 

        if ($validation->fails()) {
            return 'false';
        } 

        else {

            $settings = Settings::first();

            $horaire = Horaires::find(e($inputs['horaire_id']));

            $checkOne = HorairesTravail::where('teacher_id', e($inputs['teacher_id']))->where('class_id', e($inputs['class_id']))->where('day_id', e($inputs['day_id']))->where('entry_time', $horaire->entry_time)->where('exit_time', $horaire->exit_time)->first();

            if ($checkOne !== null) {
                return 'repeat';
            }

            $Horaire = HorairesTravail::create([

                'teacher_id' => e($inputs['teacher_id']),
                'class_id' => e($inputs['class_id']),
                'day_id' => e($inputs['day_id']),
                'entry_time' => $horaire->entry_time,
                'exit_time' => $horaire->exit_time,
                'year_id' => $settings->default_year,

            ]);

            $Horaire->save();

            return 'true';

        }

    }

    public function horaires_destroy($id)
    {   
        $Horaire = HorairesTravail::find(e($id));

        if ($Horaire !== null) {

            $Horaire->delete();
    
            return Redirect::back()->withError('Supprimé avec succès');
            
           
        } else {
            return View::make('404');
        }
        
    }


    public function horaires_importer(Request $request)
    {   
        
        $inputs = $request->all();


        $validation = Validator::make($inputs, ['fichier_horaires'=>'required']); 

            if ($validation->fails()) {

                return Redirect::back()->withInput()->withErrors($validation);

            } 

            else {

            $whitelist = array("xlsx","xls","XLS","XLSX");

            if ($request->hasFile('fichier_horaires')) {

                if (!(in_array($request->file('fichier_horaires')->extension(), $whitelist))) {
                    return Redirect::back()->withInput()->withError('Extension non autorisée');
                    die();
                } else {

                    $import = new HorairesImport();

                    Excel::import($import, request()->file('fichier_horaires'));

                    

                }

            } 

            return Redirect::back()->withSuccess('Importé avec succèss');

            }

    }






/*---------------------

 classes et matières

---------------------*/

    public function classes_subjects()
    {   
        $settings = Settings::first();

        $enseignants = User::where('is_teacher', true)->orderBy('last_name', 'asc')->get();

        $classes = Classes::where('year_id', $settings->default_year)->orderBy('name', 'asc')->get();

        $subjects = Subjects::where('year_id', $settings->default_year)->orderBy('id', 'desc')->get();

        $subject_names = SubjectNames::orderBy('name', 'asc')->get();

        return View::make('admin.classes_subjects', compact('classes', 'subjects', 'enseignants', 'subject_names'));
            
    }
    

    public function classes_store(Request $request)
    {   
        $settings = Settings::first();

        $inputs = $request->all();

        $validation = Validator::make($inputs, [
          'name'=>'required',
        ]); 

            if ($validation->fails()) {

                return Redirect::back()->withInput()->withErrors($validation);

            } 

            else {

            $Classe = Classes::create([

                'name' => e($inputs['name']),
                'year_id' => $settings->default_year,


            ]);

            $Classe->save();

            return Redirect::back()->withSuccess('Ajouter avec succès');

            }

    }


    public function classe_update($id, Request $request)
    { 
        $inputs = $request->all();

        $classe = Classes::find(e($id));

        if ($classe !== null) {

            $classe->name = e($inputs['name']);
            $classe->save();

            return Redirect::route('classes_subjects')->withSuccess('Mise à jour avec succès');
           

        } else {
            return View::make('404');
        }
    }



    public function classe_destroy($id)
    { 

        $classe = Classes::find(e($id));

        if ($classe !== null) {


            //---> Simili
            $similis = \App\Simili::where('class_id', $classe->id)->get();
            foreach ($similis as $simil) {
                \App\SimiliEvaluations::where('simili_id', $simil->id)->delete();
                $simil->delete();
            }


            //---> SuiviPreparation
            \App\SuiviPreparation::where('class_id', $classe->id)->delete();

            //---> SeanceEnseignants
            \App\SeanceEnseignants::where('class_id', $classe->id)->delete();


            $rencontres = \App\DemandesRencontre::where('class_id', $classe->id)->get();

            foreach ($rencontres as $rencont) {
                \App\DemandesRencontreStds::where('rencontre_id', $rencont->id)->delete();
                $rencont->delete();
            }

            //---> PointageHeuresTravail
            \App\PointageHeuresTravail::where('class_id', $classe->id)->delete();


            //---> Orientation
            \App\Orientation::where('class_id', $classe->id)->delete();


            //---> OrientationStudents
            \App\OrientationStudents::where('class_id', $classe->id)->delete();

            //---> AbsencesStudents
            \App\AbsencesStudents::where('class_id', $classe->id)->delete();



            $planning = \App\PlanningDevoirs::where('class_id', $classe->id)->get();

            foreach ($planning as $planni) {

               if (!empty($planni->fichier)) {
                    unlink(public_path()."/uploads/planning_devoirs/".$planni->fichier);
                }

                \App\PlanningDevoirsNotifs::where('planning_id', $planni->id)->delete();

                $planni->delete();
            }

            


            // Emploi
            $OLDemploi = Emploi::where('class_id', $classe->id)->first();

            if ($OLDemploi !== null) {
                
               if (!empty($OLDemploi->fichier)) {
                    unlink(public_path()."/uploads/emploi/".$OLDemploi->fichier);
                }

                $OLDemploi->delete();
            }


            //---> EnseignantsHeures

            $EnseignantsHeures = \App\EnseignantsHeures::where('class_id', $classe->id)->get();

            foreach ($EnseignantsHeures as $EnseignantHeur) {

                \App\HeuresEffectuees::where('teacher_id', $EnseignantHeur->teacher_id)->where('class_id', $EnseignantHeur->class_id)->where('subject_id', $EnseignantHeur->subject_id)->delete();

                $EnseignantHeur->delete();

            }



            $ControleContinu = ControleContinu::where('class_id', $classe->id)->get();

            foreach ($ControleContinu as $ControleCont) {

                ControleContinuEvaluations::where('control_id', $ControleCont->id)->delete();

                $ControleCont->delete();

            }

            //---> Reclamations
            \App\Reclamations::where('class_id', $classe->id)->delete();


            //---> CompteRendu
            CompteRendu::where('class_id', $classe->id)->delete();

            //---> Assiduite
            Assiduite::where('class_id', $classe->id)->delete();

            //---> DevoirsAlerts
            DevoirsAlerts::where('class_id', $classe->id)->delete();


            //---> students
            User::where('is_student', true)->where('class_id', $classe->id)->delete();


            $subjects = Subjects::where('class_id', $classe->id)->orderBy('id', 'desc')->get();


            foreach ($subjects as $subject) {

                //---> CahierJournal
                CahierJournal::where('subject_id', $subject->id)->orderBy('id', 'desc')->delete();

                //---> Repartition
                Repartition::where('subject_id', $subject->id)->orderBy('id', 'desc')->delete();

                //---> Devoirs
                $devoirs = Devoirs::where('subject_id', $subject->id)->orderBy('id', 'desc')->get();

                foreach ($devoirs as $devoir) {

                    if (!empty($devoir->file_join)) {
                        unlink(public_path()."/uploads/devoirs/".$devoir->file_join);
                    }

                    $devoir->delete();

                }


                $subject->delete();

            }

            //---> delete 
            $classe->delete();


            return Redirect::back()->withError('Supprimé avec succès');

        
        } else {
            return View::make('404');
        }
    }


/***************

    subject

****************/
    

    public function subject_names(Request $request)
    {   
        $settings = Settings::first();

        $inputs = $request->all();


        $validation = Validator::make($inputs, [
          'sub_name'=>'required',
        ]); 

            if ($validation->fails()) {

                return Redirect::back()->withInput()->withErrors($validation);
               // return 'false';
            } 

            else {
            
            $SubjectName = SubjectNames::create([

                'name' => e($inputs['sub_name']),
                'year_id' => $settings->default_year,


            ]);

            $SubjectName->save();
        
           // return 'true';
             return Redirect::back()->withSuccess('Ajouter avec succès');


            }

    }


    public function subject_names_update($id, Request $request)
    {   

        $inputs = $request->all();

        $subject = SubjectNames::find(e($id));

        if ($subject !== null) {
            
            // update Subjects table
            Subjects::where('name', $subject->name)->update([
                'name'=> e($inputs['subname_up'])
            ]);

            $subject->name = e($inputs['subname_up']);
            $subject->save();


            return Redirect::back()->withSuccess('Mise à jour avec succès');

        
        } else {
            return View::make('404');
        }
    }


    public function subject_names_destroy($id)
    { 

        $subject = SubjectNames::find(e($id));

        if ($subject !== null) {
            
            //---> delete 
            $subject->delete();

            return Redirect::back()->withError('Supprimé avec succès');

        
        } else {
            return View::make('404');
        }
    }


/*
    public function subject_store(Request $request)
    {   
        $settings = Settings::first();

        $inputs = $request->all();


        $validation = Validator::make($inputs, [
          'class_id'=>'required',
          'teacher_id'=>'required',
          'subject_name'=>'required',
        ]); 

            if ($validation->fails()) {

               // return Redirect::back()->withInput()->withErrors($validation);
                return 'false';
            } 

            else {
    

            $class_id = $inputs['class_id'];

            for ($i=0; $i < count($class_id); $i++) {

                // check duplicate 
                $checkName = Subjects::where('teacher_id', e($inputs['teacher_id']))->where('class_id', $class_id[$i])->where('name', 'like', '%' .e($inputs['subject_name']). '%')->first();

                if ($checkName == null) {

                    Subjects::create([

                        'name' => e($inputs['subject_name']),
                        'class_id' => $class_id[$i],
                        'teacher_id' => e($inputs['teacher_id']),
                        'year_id' => $settings->default_year,


                    ]);

                }
            }

            return 'true';
            // return Redirect::back()->withSuccess('Ajouter avec succès');


            }

    }


    public function subject_update($id, Request $request)
    { 
        $inputs = $request->all();

        $subject = Subjects::find(e($id));

        if ($subject !== null) {

            $subject->name = e($inputs['subject_name']);
            $subject->teacher_id = e($inputs['teacher_id_up']);
            $subject->class_id = e($inputs['class_id_up']);
            $subject->save();

            return Redirect::route('classes_subjects')->withSuccess('Mise à jour avec succès');
           

        } else {
            return View::make('404');
        }
    }



    public function subject_destroy($id)
    { 

        $subject = Subjects::find(e($id));

        if ($subject !== null) {


            //---> SeanceEnseignants
            \App\SeanceEnseignants::where('subject_id', $subject->id)->delete();

            
            //---> AbsencesStudents
            \App\AbsencesStudents::where('subject_id', $subject->id)->delete();


            //---> EnseignantsHeures

            $EnseignantsHeures = \App\EnseignantsHeures::where('subject_id', $subject->id)->get();

            foreach ($EnseignantsHeures as $EnseignantHeur) {

                \App\HeuresEffectuees::where('teacher_id', $EnseignantHeur->teacher_id)->where('class_id', $EnseignantHeur->class_id)->where('subject_id', $EnseignantHeur->subject_id)->delete();

                $EnseignantHeur->delete();

            }

            

            //---> CompteRendu
            CompteRendu::where('subject_id', $subject->id)->delete();

            $ControleContinu = ControleContinu::where('subject_id', $subject->id)->get();

            foreach ($ControleContinu as $ControleCont) {

                ControleContinuEvaluations::where('control_id', $ControleCont->id)->delete();

                $ControleCont->delete();

            }


            //---> CahierJournal
            CahierJournal::where('subject_id', $subject->id)->orderBy('id', 'desc')->delete();

            //---> Repartition
            Repartition::where('subject_id', $subject->id)->orderBy('id', 'desc')->delete();

            //---> Devoirs
            $devoirs = Devoirs::where('subject_id', $subject->id)->orderBy('id', 'desc')->get();

            foreach ($devoirs as $devoir) {

                if (!empty($devoir->file_join)) {
                    unlink(public_path()."/uploads/devoirs/".$devoir->file_join);
                }

                $devoir->delete();
            }

            //---> delete 
            $subject->delete();

            return Redirect::back()->withError('Supprimé avec succès');

        
        } else {
            return View::make('404');
        }
    }

*/

    
/*---------------------

 espace enseignant

---------------------*/


    public function enseignant_profile()
    {   
        $enseignant = User::find(auth()->user()->id);
        return view('enseignants.profile', compact('enseignant'));
    }


    public function enseignant_profile_update(Request $request)
    { 
        $enseignant = User::find(auth()->user()->id);

        $inputs = $request->all();

        if ($enseignant !== null) {

            $validation = Validator::make($inputs, [

              'last_name'=>'required',
              'first_name'=>'required',
              'email'=>'unique:users,email,'.$enseignant->id,
            ]); 

            if ($validation->fails()) {

                return Redirect::back()->withInput()->withErrors($validation);

            } 

            else {

                $destinationPath = public_path().'/uploads/images';
                $whitelist = array("jpg","JPG","jpeg","JPEJ","gif","png","PNG");

                if ($request->hasFile('image')) {


                    if (!(in_array($request->file('image')->extension(), $whitelist))) {
                        return Redirect::back()->withInput()->withError('Extension non autorisée');
                        die();
                    } else {

                        // delete old image
                        if (!empty($enseignant->image)) {
                            unlink(public_path()."/uploads/images/".$enseignant->image);
                        }

                        $image = round(microtime(true)) .'.'. $request->file('image')->extension();

                        $request->file('image')->move($destinationPath, $image);

                        $enseignant->image = $image;
                    }

                } 


                $enseignant->last_name = e($inputs['last_name']);
                $enseignant->first_name = e($inputs['first_name']);
                $enseignant->email = e($inputs['email']);
                $enseignant->phone = e($inputs['phone']);

                $enseignant->save();

                return Redirect::back()->withSuccess('Mise à jour avec succès');

            }

        } else {
            return View::make('404');
        }
    }


    public function enseignant_profile_password_update(Request $request)
    { 
        $enseignant = User::find(auth()->user()->id);

        $inputs = $request->all();

        if ($enseignant !== null) {

            $old_password = $inputs['old_password'];

            if (Hash::check($old_password, $enseignant->password)) {


                $enseignant->password = Hash::make(e($inputs['password']));
                $enseignant->save();

                return Redirect::back()->withSuccess('Mise à jour avec succès');

             } else { 
                return Redirect::back()->withError('Mot de passe incorrect.');
            }

            
        } else {
            return View::make('404');
        }
    }


    public function enseignant_index()
    { 
        $settings = Settings::first();

        $folders = Folders::where('teacher_id', auth()->user()->id)->orderBy('id', 'desc')->get();

        $files = EnseignantsFiles::where('teacher_id', auth()->user()->id)->orderBy('id', 'desc')->get();

        $devoirs = Devoirs::where('preparation_exam', null)->where('teacher_id', auth()->user()->id)->where('year_id', $settings->default_year)->orderBy('id', 'desc')->get();

        return view('enseignants.index', compact('folders', 'files', 'devoirs'));
    }


    public function enseignant_documents()
    {   

        $settings = Settings::first();

        $subjects = Subjects::join('classes', 'classes.id', '=', 'subjects.class_id')
        ->where('subjects.teacher_id', auth()->user()->id)
        ->where('subjects.year_id', $settings->default_year)
        ->select(
            'classes.id as cl_id', 
            'classes.name as cl_name', 
            'subjects.id as sbj_id', 
            'subjects.name as sbj_name',
            'subjects.teacher_id as tch_id')
        ->orderBy('classes.id', 'DESC')
        ->get();


        $folders = Folders::where('teacher_id', auth()->user()->id)->orderBy('id', 'desc')->get();
        return view('enseignants.documents', compact('folders', 'subjects'));
    }


/*---------------------

 folders

---------------------*/


    public function folders_store(Request $request)
    { 
        $inputs = $request->all();

        $validation = Validator::make($inputs, ['folder_name'=>'required']); 

        if ($validation->fails()) {

            return Redirect::back()->withInput()->withErrors($validation);

        } 

        else {

            $folder = Folders::create([

                'folder_name' => htmlentities($inputs['folder_name']),
                'class_id' => e($inputs['class_id']),
                'teacher_id' => auth()->user()->id,

            ]);

            $folder->save();

            // add historique
            $historique = Historique::create([
                'historique' => 'Créé un dossier (' . $folder->folder_name . ')',
                'teacher_id' => auth()->user()->id,
            ]);

            $historique->save();



            return Redirect::back()->withSuccess('Ajouter avec succès');

        }

    }


    public function folder_files($id)
    { 
        $folder = Folders::find($id);

        if ($folder !== null AND $folder->teacher_id == auth()->user()->id) {

            $files = EnseignantsFiles::where('folder_id', $folder->id)->orderBy('id', 'desc')->get();

            return view('enseignants.folder_files', compact('folder', 'files'));
           
        } else {
            return View::make('404');
        }
    }




    public function files_store($id, Request $request)
    { 

// if (Request::ajax()){


        $Folder = Folders::find(e($id));

        $inputs = $request->all();

        if ($Folder !== null) {


            $validation = Validator::make($inputs, [
              'file_name'=>'required',
              'file' => 'required|max:50240',
            ]); 

            if ($validation->fails()) {

               // return Redirect::back()->withInput()->withErrors($validation);

                return '<div class="alert alert-danger" role="alert">
  <h5 class="alert-heading">Error!</h5><hr>
  <p class="mb-0">* Veuillez entrer le nom de fichier</p>
  <p class="mb-0">* La taille limite du fichier est de 50Mo</p>
</div><div class="clearfix"></div>'; 

            } 

            else {

$destinationPath = public_path().'/uploads/files';
$whitelist = array(
    "jpg","jpeg","gif","png","bmp",
    "pdf","doc","docx","txt","ppt","pptx","xls","xlsx","zip","rar",
    "mp4", "avi", "mpeg", "mpg", "mov", "wmv", "rm", "3gp", "webm"
);


                if ($request->hasFile('file')) {

                    $file_type = $request->file('file')->extension();
                    $file_size = $request->file('file')->getSize();

                    if (!(in_array(strtolower($request->file('file')->extension()), $whitelist))) {
                     //   return Redirect::back()->withInput()->withError('Error: Extension non autorisée');
                        return '<div class="alert alert-danger" role="alert">
  <h4 class="alert-heading">Error!</h4><hr>
  <p class="mb-0">Extension non autorisée</p>
</div><div class="clearfix"></div>'; 
                        die();
                    } else {

                        $file_path = round(microtime(true)) .'.'. strtolower($request->file('file')->extension());

                        $request->file('file')->move($destinationPath, $file_path);

                        

                        $EnseignantsFiles = EnseignantsFiles::create([

                            'folder_id' => $Folder->id,
                            'teacher_id' => auth()->user()->id,
                            'file_name' => htmlentities($inputs['file_name']),
                            'file_path' => $file_path,
                            'file_size' => $file_size,
                            'file_type' => $file_type,


                        ]);

                        $EnseignantsFiles->save();


                        // add historique
                        $historique = Historique::create([
                            'historique' => 'Téléversé (' . $EnseignantsFiles->file_name . ') dans le dossier (' . $Folder->folder_name . ')',
                            'teacher_id' => auth()->user()->id,
                        ]);

                        $historique->save();


            //--> store notification
            $students = User::where('is_student', true)->where('class_id', $Folder->class_id)->get();

            foreach ($students as $student) {
                
                $notif = RessourcesNotification::create([

                    'folder_id' => $Folder->id,
                    'class_id' => $Folder->class_id,
                    'student_id' => $student->id,
                    'teacher_id' => auth()->user()->id,

                ]);

                $notif->save();
            }
            //--> End store notification




                    //    return Redirect::back()->withSuccess('Ajouter avec succès');

                        return  '<div class="alert alert-success" role="alert">
                          <h4 class="alert-heading">Ajouté avec succès!</h4><hr>
                          <p class="mb-0">le fichier a été téléversé avec succès</p>
                        </div><div class="clearfix"></div>';


                    }

                } 


               
            }


        } else {
            return View::make('404');
        }

// } // END if (Request::ajax()){

    }



    public function folder_update($id, Request $request)
    { 
        $inputs = $request->all();

        $folder = Folders::find(e($id));

        if ($folder !== null) {

            if ($folder->teacher_id == auth()->user()->id OR auth()->user()->is_admin == 1) {

                // add historique
                $historique = Historique::create([
                    'historique' => 'Renommé le dossier (' . $folder->folder_name . ') par (' . htmlentities($inputs['folder_name_up']) . ')',
                    'teacher_id' => auth()->user()->id,
                ]);

                $historique->save();



                $folder->folder_name = htmlentities($inputs['folder_name_up']);
                $folder->class_id = e($inputs['class_id_up']);

                $folder->save();

                return Redirect::back()->withSuccess('Mise à jour avec succès');

            }
           

        } else {
            return View::make('404');
        }
    }


    public function files_update($id, $file, Request $request)
    { 
        $inputs = $request->all();

        $folder = Folders::find(e($id));

        $EnseignantsFiles = EnseignantsFiles::find(e($file));

        if ($folder !== null AND $EnseignantsFiles !== null) {

            if ($EnseignantsFiles->teacher_id == auth()->user()->id OR auth()->user()->is_admin == 1) {

                // add historique
                $historique = Historique::create([
                    'historique' => 'Renommé la ressource (' . $EnseignantsFiles->file_name . ') par (' . htmlentities($inputs['file_name_up']) . ')',
                    'teacher_id' => auth()->user()->id,
                ]);

                $historique->save();


                $EnseignantsFiles->file_name = htmlentities($inputs['file_name_up']);

                $EnseignantsFiles->save();

                return Redirect::back()->withSuccess('Mise à jour avec succès');

            }
           
        } else {
            return View::make('404');
        }
    }


/*---------------------

 cahier journal

---------------------*/

    public function cahier_journal()
    {   
        $settings = Settings::first();

        $subjects = Subjects::where('year_id', $settings->default_year)->where('teacher_id', auth()->user()->id)->orderBy('id', 'desc')->get();

        $cahier_journal = CahierJournal::where('year_id', $settings->default_year)->where('teacher_id', auth()->user()->id)->orderBy('id', 'desc')->get();

        return View::make('enseignants.cahier_journal', compact('cahier_journal', 'subjects'));
            
    }



    public function teacher_cahierjournal_historique()
    { 
        $settings = Settings::first();

        return view('enseignants.cahier_journal_historique', compact('settings'));
        
    }




    public function cahier_journal_store(Request $request)
    {   
        $settings = Settings::first();

        $inputs = $request->all();

        $validation = Validator::make($inputs, [
          'details'=>'required',
          'seance_heures'=>'required',
        ]); 

        if ($validation->fails()) {
            return Redirect::back()->withInput()->withErrors($validation);
        } 

        else {


$heures = explode(" - ", $inputs['seance_heures']);

$time1 = $heures[0];
$time2 = $heures[1];

            $to_time = strtotime($time1.":00");
            $from_time = strtotime($time2.":00");
          //  return round(abs($to_time - $from_time) / 60,2). " minute";

            $hours_differance = round(abs($to_time - $from_time) / 60,2);

            $myDateTime = \DateTime::createFromFormat('d/m/Y', e($inputs['date']));
            $date_en = $myDateTime->format('Y-m-d');


            $getSubject = Subjects::find(e($inputs['subject_id'])); 


            $journal = CahierJournal::create([

                'class_id' => $getSubject->class_id,
                'subject_id' => $getSubject->id,

                'teacher_id' => auth()->user()->id,

                'date' => e($inputs['date']),
                'date_en' => $date_en,
                'hour_start' => $time1,
                'hour_end' => $time2,
                'details' => htmlentities($inputs['details']),
                'year_id' => $settings->default_year,

                'hours_differance' => $hours_differance,

            ]);

            $journal->save();

            return Redirect::back()->withSuccess('Ajouter avec succès');

        }

    }


    public function cahier_journal_update($id, Request $request)
    { 
        $inputs = $request->all();

        $journal = CahierJournal::find(e($id));

        if ($journal !== null AND $journal->teacher_id == auth()->user()->id) {


$heures = explode(" - ", $inputs['seance_heures']);

$time1 = $heures[0];
$time2 = $heures[1];

$to_time = strtotime($time1.":00");
$from_time = strtotime($time2.":00");
$hours_differance = round(abs($to_time - $from_time) / 60,2);

                $myDateTime = \DateTime::createFromFormat('d/m/Y', e($inputs['date']));
                $date_en = $myDateTime->format('Y-m-d');


                $journal->date_en = $date_en;
                $journal->date = e($inputs['date']);
                $journal->hour_start = $time1;
                $journal->hour_end = $time2;
                $journal->details = htmlentities($inputs['details']);
                $journal->hours_differance = $hours_differance;
                $journal->save();

                return Redirect::route('cahier_journal')->withSuccess('Mise à jour avec succès');
           

        } else {
            return View::make('404');
        }
    }


    public function cahier_journal_delete($id)
    { 

        $journal = CahierJournal::find(e($id));

        if ($journal !== null) {

            if ($journal->teacher_id == auth()->user()->id OR auth()->user()->is_admin == 1) {

                $journal->delete();

                return Redirect::back()->withError('Supprimé avec succès');

            }
           

        } else {
            return View::make('404');
        }
    }


   
/*---------------------

 repartition

---------------------*/

    public function enseignant_repartition()
    {   
        $settings = Settings::first();

        $subjects = Subjects::where('year_id', $settings->default_year)->where('teacher_id', auth()->user()->id)->orderBy('id', 'desc')->get();

        return View::make('enseignants.repartition', compact('subjects'));
            
    }
    

    public function enseignant_store_repartition(Request $request)
    {   
        $settings = Settings::first();

        $inputs = $request->all();

        $validation = Validator::make($inputs, [
          'details'=>'required',
        ]); 

        if ($validation->fails()) {
            return Redirect::back()->withInput()->withErrors($validation);
        } 

        else {

            // delete old

            Repartition::where('teacher_id', auth()->user()->id)->where('class_id', e($inputs['class_id']))->where('subject_id', e($inputs['subject_id']))->where('week', e($inputs['week']))->where('semestre', e($inputs['semestre']))->delete();


            $Repartition = Repartition::create([

                'teacher_id' => auth()->user()->id,
                'class_id' => e($inputs['class_id']),
                
                'semestre' => e($inputs['semestre']),

                'subject_id' => e($inputs['subject_id']),
                'week' => e($inputs['week']),
                'date_start' => e($inputs['date_start']),
                'date_end' => e($inputs['date_end']),
                'details' => htmlspecialchars($inputs['details']),
                'year_id' => $settings->default_year,

            ]);

            $Repartition->save();

            return Redirect::back()->withSuccess('Ajouter avec succès');

        }

    }



   
/*---------------------

    Préparation à l'exam

---------------------*/

    public function enseignant_preparation(Request $request)
    {   
        $inputs = $request->all();

        $settings = Settings::first();

        $devoirs = Devoirs::where('year_id', $settings->default_year)->where('teacher_id', auth()->user()->id)->where('preparation_exam', e($inputs['cl']))->orderBy('id', 'desc')->get();

        $subjects = Subjects::where('year_id', $settings->default_year)->where('teacher_id', auth()->user()->id)->orderBy('id', 'desc')->get();

        return View::make('enseignants.preparation', compact('subjects', 'devoirs'));
            
    }


     public function preparation_store(Request $request)
    {   
        $settings = Settings::first();

        $inputs = $request->all();


        $validation = Validator::make($inputs, [
          'title'=>'required',
          'file_join'=>'max:10240',
        ]); 

        if ($validation->fails()) {
            return Redirect::back()->withInput()->withErrors($validation);
        } 

        else {


$destinationPath = public_path().'/uploads/devoirs';

$whitelist = array(
    "jpg","jpeg","gif","png","bmp",
    "pdf","doc","docx","txt","ppt","pptx","xls","xlsx"
);

    
            if ($request->hasFile('file_join')) {

                if (!(in_array($request->file('file_join')->extension(), $whitelist))) {
                    return Redirect::back()->withInput()->withError('Extension non autorisée');
                    die();
                } else {

                    $file_join = round(microtime(true)) .'.'. $request->file('file_join')->extension();

                    $request->file('file_join')->move($destinationPath, $file_join);
                }

            } else {
                $file_join = null;
            }



            $getSubject = Subjects::find(e($inputs['subject_id'])); 


            $devoir = Devoirs::create([

                'preparation_exam' => e($inputs['preparation_exam']),

                'class_id' => $getSubject->class_id,
                'subject_id' => $getSubject->id,

                'teacher_id' => auth()->user()->id,
                
                'title' => htmlspecialchars($inputs['title']),

                'details' => htmlentities($inputs['details']),
                'file_join' => $file_join,
                'year_id' => $settings->default_year,

            ]);

            $devoir->save();

            //--> store notification

            $students = User::where('is_student', true)->where('class_id', $getSubject->class_id)->get();

            foreach ($students as $student) {
                
                $notif = DevoirsNotification::create([

                    'devoir_id' => $devoir->id,
                    'is_preparation' => 1,
                    'class_id' => $getSubject->class_id,
                    'student_id' => $student->id,
                    'teacher_id' => auth()->user()->id,

                ]);

                $notif->save();
            }

            //--> End store notification


            return Redirect::back()->withSuccess('Ajouter avec succès');

        }

    }


    public function preparation_update($id, Request $request)
    { 
        $inputs = $request->all();

        $devoir = Devoirs::find(e($id));

        if ($devoir !== null AND $devoir->teacher_id == auth()->user()->id) {


                

$destinationPath = public_path().'/uploads/devoirs';

$whitelist = array(
    "jpg","jpeg","gif","png","bmp",
    "pdf","doc","docx","txt","ppt","pptx","xls","xlsx"
);

    
            if ($request->hasFile('file_join')) {

                if (!(in_array($request->file('file_join')->extension(), $whitelist))) {
                    return Redirect::back()->withInput()->withError('Extension non autorisée');
                    die();
                } else {

                    // delete old one
                    if (!empty($devoir->file_join)) {
                        unlink(public_path()."/uploads/devoirs/".$devoir->file_join);
                    }


                    $file_join = round(microtime(true)) .'.'. $request->file('file_join')->extension();

                    $request->file('file_join')->move($destinationPath, $file_join);


                    $devoir->file_join = $file_join;

                }

            } 

                $devoir->title = htmlspecialchars($inputs['title']);
                $devoir->details = htmlentities($inputs['details']);

                $devoir->save();

                return Redirect::back()->withSuccess('Mise à jour avec succès');
           

        } else {
            return View::make('404');
        }
    }
    



   
/*---------------------

    devoirs

---------------------*/

    public function enseignant_devoirs()
    {   
        $settings = Settings::first();

        $devoirs = Devoirs::where('year_id', $settings->default_year)->where('teacher_id', auth()->user()->id)->orderBy('id', 'desc')->get();

        $subjects = Subjects::where('year_id', $settings->default_year)->where('teacher_id', auth()->user()->id)->orderBy('id', 'desc')->get();

        return View::make('enseignants.devoirs', compact('subjects', 'devoirs'));
            
    }

    public function enseignant_store_devoirs(Request $request)
    {   
        $settings = Settings::first();

        $inputs = $request->all();

        $validation = Validator::make($inputs, [
          'date'=>'required',
          'title'=>'required',
          'file_join'=>'max:10240',
        ]); 

        if ($validation->fails()) {
            return Redirect::back()->withInput()->withErrors($validation);
        } 

        else {


$destinationPath = public_path().'/uploads/devoirs';

$whitelist = array(
    "jpg","jpeg","gif","png","bmp",
    "pdf","doc","docx","txt","ppt","pptx","xls","xlsx"
);

    
            if ($request->hasFile('file_join')) {

                if (!(in_array($request->file('file_join')->extension(), $whitelist))) {
                    return Redirect::back()->withInput()->withError('Extension non autorisée');
                    die();
                } else {

                    $file_join = round(microtime(true)) .'.'. $request->file('file_join')->extension();

                    $request->file('file_join')->move($destinationPath, $file_join);
                }

            } else {
                $file_join = null;
            }



            $getSubject = Subjects::find(e($inputs['subject_id'])); 

$DateTime = \DateTime::createFromFormat('d/m/Y', e($inputs['date']));
$date_en = $DateTime->format('Y-m-d');


            $devoir = Devoirs::create([

                'class_id' => $getSubject->class_id,
                'subject_id' => $getSubject->id,

                'teacher_id' => auth()->user()->id,
                
                'title' => htmlspecialchars($inputs['title']),
                'date' => e($inputs['date']),
                'date_en' => $date_en,
                'details' => htmlentities($inputs['details']),
                'file_join' => $file_join,
                'year_id' => $settings->default_year,

            ]);

            $devoir->save();

            
            //--> store notification

            $students = User::where('is_student', true)->where('class_id', $getSubject->class_id)->get();

            foreach ($students as $student) {
                
                $notif = DevoirsNotification::create([

                    'devoir_id' => $devoir->id,
                    'is_preparation' => 0,
                    'class_id' => $getSubject->class_id,
                    'student_id' => $student->id,
                    'teacher_id' => auth()->user()->id,

                ]);

                $notif->save();
            }

            //--> End store notification


            return Redirect::back()->withSuccess('Ajouter avec succès');

        }

    }


    public function devoirs_update($id, Request $request)
    { 
        $inputs = $request->all();

        $devoir = Devoirs::find(e($id));

        if ($devoir !== null AND $devoir->teacher_id == auth()->user()->id) {


                

$destinationPath = public_path().'/uploads/devoirs';

$whitelist = array(
    "jpg","jpeg","gif","png","bmp",
    "pdf","doc","docx","txt","ppt","pptx","xls","xlsx"
);

    
            if ($request->hasFile('file_join')) {

                if (!(in_array($request->file('file_join')->extension(), $whitelist))) {
                    return Redirect::back()->withInput()->withError('Extension non autorisée');
                    die();
                } else {

                    // delete old one
                    if (!empty($devoir->file_join)) {
                        unlink(public_path()."/uploads/devoirs/".$devoir->file_join);
                    }


                    $file_join = round(microtime(true)) .'.'. $request->file('file_join')->extension();

                    $request->file('file_join')->move($destinationPath, $file_join);


                    $devoir->file_join = $file_join;

                }

            } 


$DateTime = \DateTime::createFromFormat('d/m/Y', e($inputs['date']));
$date_en = $DateTime->format('Y-m-d');

                $devoir->date = e($inputs['date']);
                $devoir->date_en = $date_en;
                $devoir->title = htmlspecialchars($inputs['title']);
                $devoir->details = htmlentities($inputs['details']);

                $devoir->save();

                return Redirect::route('enseignant_devoirs')->withSuccess('Mise à jour avec succès');
           

        } else {
            return View::make('404');
        }
    }



    public function devoirs_delete($id)
    { 

        $devoir = Devoirs::find(e($id));

        if ($devoir !== null) {

            if ($devoir->teacher_id == auth()->user()->id OR auth()->user()->is_admin == 1) {

                if (!empty($devoir->file_join)) {
                    unlink(public_path()."/uploads/devoirs/".$devoir->file_join);
                }

                //---> DevoirsNotification
                DevoirsNotification::where('devoir_id', $devoir->id)->delete();

                //---> DevoirsAlerts
                DevoirsAlerts::where('devoir_id', $devoir->id)->delete();

                //---> Evaluations
                Evaluations::where('devoir_id', $devoir->id)->delete();

                $devoir->delete();

                return Redirect::back()->withError('Supprimé avec succès');

            }
           

        } else {
            return View::make('404');
        }
    }




/*---------------------

     assiduite

---------------------*/

    public function enseignant_assiduite()
    {   
        $settings = Settings::first();

        $subjects = Subjects::where('year_id', $settings->default_year)->where('teacher_id', auth()->user()->id)->orderBy('id', 'desc')->get();

        $assiduite = Assiduite::where('year_id', $settings->default_year)->where('teacher_id', auth()->user()->id)->orderBy('id', 'desc')->get();

        $assiduite_motifs = AssiduiteMotifs::orderBy('id', 'desc')->get();

        return View::make('enseignants.assiduite', compact('subjects', 'assiduite', 'assiduite_motifs'));
            
    }

    public function ajax_students_class(Request $request)
    {  
        $inputs = $request->all();

        $settings = Settings::first();

        $students = User::where('is_student', true)->where('class_id', e($inputs['class_id']))->select('id', 'last_name', 'first_name')->orderBy('last_name', 'asc')->get();

        return response()->json($students);

    }

    public function ajax_subject_class(Request $request)
    {  
        $inputs = $request->all();

        $settings = Settings::first();

        $GetSubject = Subjects::find(e($inputs['subject_id']));

        if ($GetSubject !== null) {
            $class_id = $GetSubject->class_id;
            return $class_id;
        }

        

    }



    public function enseignant_assiduite_store(Request $request)
    { 
        
        $inputs = $request->all();

        $validation = Validator::make($inputs, [
          'class_id'=>'required',
          'student_id'=>'required',
          'motif'=>'required',
        ]); 

        if ($validation->fails()) {
            return Redirect::back()->withInput()->withErrors($validation);
        } 

        else {

            $settings = Settings::first();

            $myDateTime = \DateTime::createFromFormat('d/m/Y', e($inputs['date']));
            $date_en = $myDateTime->format('Y-m-d');

            $assiduite = Assiduite::create([


                'teacher_id' => auth()->user()->id,

                'class_id' => e($inputs['class_id']),
                'subject_id' => e($inputs['subject_id']),

                'student_id' => e($inputs['student_id']),

                'date' => e($inputs['date']),
                'date_en' => $date_en,
                'hour' => e($inputs['hour']),
                'motif' => htmlspecialchars($inputs['motif']),
                'year_id' => $settings->default_year,


            ]);

            $assiduite->save();

            return Redirect::back()->withSuccess('Ajouter avec succès');

        }


    }


    public function assiduite_delete($id)
    { 

        $assiduite = Assiduite::find(e($id));

        if ($assiduite !== null) {

            if ($assiduite->teacher_id == auth()->user()->id OR auth()->user()->is_admin == 1) {

                $assiduite->delete();

                return Redirect::back()->withError('Supprimé avec succès');

            }
           

        } else {
            return View::make('404');
        }
    }



/*---------------------

    evaluations

---------------------*/

    public function enseignant_evaluations()
    {   
        $settings = Settings::first();

        $devoirs = Devoirs::where('year_id', $settings->default_year)->where('teacher_id', auth()->user()->id)->orderBy('id', 'desc')->get();

        $subjects = Subjects::where('year_id', $settings->default_year)->where('teacher_id', auth()->user()->id)->orderBy('id', 'desc')->get();

        return View::make('enseignants.evaluations', compact('subjects', 'devoirs'));
            
    }

    public function ajax_class_devoirs(Request $request)
    {  
        $inputs = $request->all();


        $settings = Settings::first();

        if (!empty($inputs['subject_id'])) {

            $devoirs = Devoirs::where('year_id', $settings->default_year)->where('subject_id', e($inputs['subject_id']))->select('id', 'title', 'date')->orderBy('id', 'asc')->get();

        } else {

            $devoirs = Devoirs::where('year_id', $settings->default_year)->where('teacher_id', auth()->user()->id)->select('id', 'title', 'date')->orderBy('id', 'asc')->get();
        }

        return response()->json($devoirs);

    }


    public function evaluations_store(Request $request)
    {  
        $inputs = $request->all();

        $settings = Settings::first();

        $devoir_id = $inputs['devoir_id'];
        $class_id = $inputs['class_id'];

        $student_ids = $inputs['student_ids'];

        $is_done = $inputs['is_done'];
        $is_incomplete = $inputs['is_incomplete'];
        $is_notdone = $inputs['is_notdone'];
        $observation = $inputs['observation'];

        //--> for student_ids
        for($i=0;$i<count($inputs['student_ids']);$i++){

            $checkOne = Evaluations::where('student_id', $student_ids[$i])->where('devoir_id', e($devoir_id))->first();

            if ($checkOne !== null) {
                $checkOne->delete();
            }

        //--> Devoirs Alerts

            $checkTwo = DevoirsAlerts::where('student_id', $student_ids[$i])->where('devoir_id', e($devoir_id))->first();

            if ($checkTwo !== null) { $checkTwo->delete(); }
            

            if ($is_incomplete[$i] == 1 OR $is_notdone[$i] == 1) {
                
                if ($is_incomplete[$i] == 1) { 
                    $alert_type = 1;
                } else {
                    $alert_type = 2;
                }

                DevoirsAlerts::create([

                    'teacher_id' => auth()->user()->id,
                    'student_id' => $student_ids[$i],
                    'class_id' => $class_id,
                    'devoir_id' => $devoir_id,

                    'alert_type' => $alert_type,

                    'year_id' => $settings->default_year,

                ]);


            }
        //--> End Devoirs Alerts

            


            $storeEvaluations = Evaluations::create([

                'teacher_id' => auth()->user()->id,
                'student_id' => $student_ids[$i],

                'class_id' => $class_id,
                'devoir_id' => $devoir_id,

                'is_done' => $is_done[$i],
                'is_incomplete' => $is_incomplete[$i],
                'is_notdone' => $is_notdone[$i],
                'observation' => $observation[$i],

                'year_id' => $settings->default_year,

            ]);

            $storeEvaluations->save();


        } // End for student_ids

       

       return Redirect::back()->with('success', 'ajouté avec succès!');


    }







/*---------------------

    Contrôle continu

---------------------*/

    public function enseignant_evaluations_controle()
    {   
        $settings = Settings::first();

        $controlesContinu = ControleContinu::where('year_id', $settings->default_year)->where('teacher_id', auth()->user()->id)->orderBy('id', 'desc')->get();

        $subjects = Subjects::where('year_id', $settings->default_year)->where('teacher_id', auth()->user()->id)->orderBy('id', 'desc')->get();

        return View::make('enseignants.controle_continu', compact('subjects', 'controlesContinu'));
            
    }




    public function controle_evaluations_store(Request $request)
    {  
        $inputs = $request->all();

        $settings = Settings::first();

        $subject_id = $inputs['subject_id'];
        $class_id = $inputs['class_id'];

        $student_ids = $inputs['student_ids'];

        $is_absent = $inputs['is_absent'];
        $note = $inputs['note'];


        $myDateTime = \DateTime::createFromFormat('d/m/Y', e($inputs['date']));
        $date_en = $myDateTime->format('Y-m-d');


        $ControleStore = ControleContinu::create([
            'teacher_id' => auth()->user()->id,
            'titre' => htmlspecialchars($inputs['titre']),
            'class_id' => $class_id,
            'subject_id' => $subject_id,
            'date' => $date_en,
            'note_sur' => e($inputs['note_sur']),
            'year_id' => $settings->default_year,
        ]);

        $ControleStore->save();


        //--> for student_ids
        for($i=0;$i<count($inputs['student_ids']);$i++){


            $storeEvaluations = ControleContinuEvaluations::create([
                'control_id' => $ControleStore->id,
                'student_id' => $student_ids[$i],
                'is_absent' => $is_absent[$i],
                'note' => $note[$i],
                'year_id' => $settings->default_year,
            ]);

            $storeEvaluations->save();


        } // End for student_ids

       

       return Redirect::route('enseignant_evaluations_controle')->with('success', 'ajouté avec succès!');


    }


    public function controle_evaluations_update($id, Request $request)
    {  
        $settings = Settings::first();

        $inputs = $request->all();

        $ControleStore = ControleContinu::find(e($id));

        $student_ids = $inputs['student_ids'];

        $is_absent = $inputs['is_absent'];
        $note = $inputs['note'];

        //--> delete olds
        ControleContinuEvaluations::where('control_id', $ControleStore->id)->delete();

        //--> for student_ids
        for($i=0;$i<count($inputs['student_ids']);$i++){


            $storeEvaluations = ControleContinuEvaluations::create([
                'control_id' => $ControleStore->id,
                'student_id' => $student_ids[$i],
                'is_absent' => $is_absent[$i],
                'note' => $note[$i],
                'year_id' => $settings->default_year,
            ]);

            $storeEvaluations->save();


        } // End for student_ids

       

       return Redirect::back()->with('success', 'Modifier avec succès!');


    }


    public function enseignant_destroy_controle($id)
    {  

        $ControleStore = ControleContinu::find(e($id));

        if ($ControleStore->teacher_id == auth()->user()->id OR auth()->user()->is_admin == 1) {
            
            //--> delete ControleContinuEvaluations
            ControleContinuEvaluations::where('control_id', $ControleStore->id)->delete();

            $ControleStore->delete();

            return Redirect::back()->with('success', 'Supprimé avec succès!');
        }

        


    }



/*---------------------

      compte rendu

---------------------*/

    public function enseignant_compte_rendu()
    {   
        $settings = Settings::first();

        $subjects = Subjects::where('year_id', $settings->default_year)->where('teacher_id', auth()->user()->id)->orderBy('id', 'desc')->get();

        $compte_rendu = CompteRendu::where('year_id', $settings->default_year)->where('teacher_id', auth()->user()->id)->orderBy('id', 'desc')->get();


        return View::make('enseignants.compte_rendu', compact('subjects', 'compte_rendu'));
            
    }




    public function enseignant_compte_rendu_store(Request $request)
    { 
        
        $inputs = $request->all();

        $validation = Validator::make($inputs, [
          'class_id'=>'required',
          'student_id'=>'required',
          'details'=>'required',
        ]); 

        if ($validation->fails()) {
            return Redirect::back()->withInput()->withErrors($validation);
        } 

        else {

            $settings = Settings::first();


            $storeCompteRendu = CompteRendu::create([


                'teacher_id' => auth()->user()->id,

                'class_id' => e($inputs['class_id']),
                'subject_id' => e($inputs['subject_id']),

                'student_id' => e($inputs['student_id']),

                'date' => e($inputs['date']),
                'details' => htmlentities($inputs['details']),
                'year_id' => $settings->default_year,


            ]);

            $storeCompteRendu->save();

            return Redirect::back()->withSuccess('Ajouter avec succès');

        }


    }


    public function compte_rendu_update($id, Request $request)
    {   
        $inputs = $request->all();

        $compte_rendu = CompteRendu::find(e($id));

        if ($compte_rendu !== null) {

            if ($compte_rendu->teacher_id == auth()->user()->id OR auth()->user()->is_admin == 1) {

                $compte_rendu->date = e($inputs['date']);
                $compte_rendu->details = htmlentities($inputs['details']);

                $compte_rendu->save();

                return Redirect::route('enseignant_compte_rendu')->withSuccess('Mise à jour avec succès');

            }
           
        } else {
            return View::make('404');
        }
    }


                

    public function compte_rendu_delete($id)
    { 

        $compte_rendu = CompteRendu::find(e($id));

        if ($compte_rendu !== null) {

            if ($compte_rendu->teacher_id == auth()->user()->id OR auth()->user()->is_admin == 1) {

                $compte_rendu->delete();

                return Redirect::back()->withError('Supprimé avec succès');

            }
           

        } else {
            return View::make('404');
        }
    }





   
/*---------------------

    absence request

---------------------*/

    public function enseignant_absence_request()
    {   
        $settings = Settings::first();

        if (auth()->user()->is_admin == true) {

            $absences = AbsenceRequest::where('year_id', $settings->default_year)->orderBy('id', 'desc')->get();

            foreach ($absences as $absence) {
                $absence->is_readed = 1;
                $absence->save();
            }

            return View::make('enseignants.absences', compact('absences'));

        } else {

            $absences = AbsenceRequest::where('year_id', $settings->default_year)->where('teacher_id', auth()->user()->id)->orderBy('id', 'desc')->get();

            return View::make('enseignants.absences', compact('absences'));
        }
        

        
            
    }

    public function absence_request_store(Request $request)
    {   
        $settings = Settings::first();

        $inputs = $request->all();

        $validation = Validator::make($inputs, [
          'date_du'=>'required',
          'date_au'=>'required',
          'date_reprise'=>'required',
          'motif'=>'required|max:255',
          'file_join'=>'max:10240',
        ]); 

        if ($validation->fails()) {
            return Redirect::back()->withInput()->withErrors($validation);
        } 

        else {


$destinationPath = public_path().'/uploads/absences_justification';

$whitelist = array(
    "jpg","jpeg","gif","png","bmp",
    "pdf","doc","docx","txt","ppt","pptx","xls","xlsx"
);

    
            if ($request->hasFile('file_join')) {

                if (!(in_array($request->file('file_join')->extension(), $whitelist))) {
                    return Redirect::back()->withInput()->withError('Extension non autorisée');
                    die();
                } else {

                    $file_join = round(microtime(true)) .'.'. $request->file('file_join')->extension();

                    $request->file('file_join')->move($destinationPath, $file_join);
                }

            } else {
                $file_join = null;
            }



            $store = AbsenceRequest::create([

                'teacher_id' => auth()->user()->id,
                
                'date_du' => e($inputs['date_du']),
                'date_au' => e($inputs['date_au']),
                'date_reprise' => e($inputs['date_reprise']),
                'motif' => htmlentities($inputs['motif']),
                'fichier_joint' => $file_join,
                'year_id' => $settings->default_year,

            ]);

            $store->save();

            return Redirect::back()->withSuccess('Envoyé avec succès');

        }

    }




    public function absence_request_decision($id, Request $request)
    { 
        
        $inputs = $request->all();

        $validation = Validator::make($inputs, [
          'decision'=>'max:255',
        ]); 

        if ($validation->fails()) {
            return Redirect::back()->withInput()->withErrors($validation);
        } 

        else {

            $absence = AbsenceRequest::find(e($id));

            if (auth()->user()->is_admin == 1) {

                $absence->decision = htmlentities($inputs['decision']);
                $absence->save();

                return Redirect::back()->withSuccess('Envoyé avec succès');

            }


        }

    }




    public function absence_request_delete($id)
    { 

        $absence = AbsenceRequest::find(e($id));

        if ($absence !== null) {

            if ($absence->teacher_id == auth()->user()->id OR auth()->user()->is_admin == 1) {

                if (!empty($absence->fichier_joint)) {
                    unlink(public_path()."/uploads/absences_justification/".$absence->fichier_joint);
                }

                $absence->delete();

                return Redirect::back()->withError('Supprimé avec succès');

            }
           

        } else {
            return View::make('404');
        }
    }


/*-----------
Notification Heures Effectuees
------------*/

    public function enseignants_heures_notif($id)
    { 

        $GetNotif = \App\EnseignantsHeures::find(e($id));

        if ($GetNotif !== null AND $GetNotif->teacher_id == auth()->user()->id) {

            $GetNotif->is_notified = 0;
            $GetNotif->save();

            return Redirect::back(); 

        } 

    }





   
/*---------------------

   demander des documents

---------------------*/

    public function demandes_documents()
    {   
        $settings = Settings::first();

        $docs_names = DocumentsNames::orderBy('id', 'desc')->get();

        if (auth()->user()->is_admin == true) {

            $demandes = DemandesDocuments::orderBy('id', 'desc')->get();

            foreach ($demandes as $dem) {
                $dem->is_readed = 1;
                $dem->save();
            }

            return View::make('enseignants.docs_demandes', compact('demandes', 'docs_names'));

        } else {

            $demandes = DemandesDocuments::where('teacher_id', auth()->user()->id)->orderBy('id', 'desc')->get();

            return View::make('enseignants.docs_demandes', compact('demandes', 'docs_names'));
        }
        

        
            
    }

    public function demandes_documents_store(Request $request)
    {   
        $settings = Settings::first();

        $inputs = $request->all();

        $validation = Validator::make($inputs, [
          'doc_name'=>'required',
        ]); 

        if ($validation->fails()) {
            return Redirect::back()->withInput()->withErrors($validation);
        } 

        else {


            $store = DemandesDocuments::create([
                'teacher_id' => auth()->user()->id,
                'doc_name' => htmlentities($inputs['doc_name']),
            ]);

            $store->save();

            return Redirect::back()->withSuccess('Envoyé avec succès');

        }

    }




    public function demandes_documents_traitee($id)
    { 

        $Demande = DemandesDocuments::find(e($id));

        if ($Demande !== null AND auth()->user()->is_admin == 1) {

            $Demande->etat = 1;
            $Demande->save();

            return Redirect::back()->withSuccess('la demande est traitée');

        } 

    }


    public function demandes_documents_delete($id)
    { 

        $Demande = DemandesDocuments::find(e($id));

        if ($Demande !== null) {

            if ($Demande->teacher_id == auth()->user()->id OR auth()->user()->is_admin == 1) {

                $Demande->delete();

                return Redirect::back()->withError('Supprimé avec succès');

            }
           

        } else {
            return View::make('404');
        }
    }





/*---------------------

   Grille d'évaluation de l'enseignant

---------------------*/

    public function grille_evaluation()
    {   
        $settings = Settings::first();

        if (auth()->user()->is_admin == 1) {
            $grille_evaluations = GrilleEvaluation::where('year_id', $settings->default_year)->orderBy('id', 'desc')->get();
        } else {
            
            $grille_evaluations = GrilleEvaluation::where('teacher_id', auth()->user()->id)->where('year_id', $settings->default_year)->orderBy('id', 'desc')->get();

            foreach ($grille_evaluations as $grille_evaluat) {
                $grille_evaluat->readed = 1;
                $grille_evaluat->save();
            }

        }

        

        return View::make('admin.grille_evaluation', compact('grille_evaluations'));
        
            
    }

    public function new_grille_evaluation()
    {   
        $settings = Settings::first();

        $enseignants = User::where('is_teacher', true)->orderBy('last_name', 'asc')->get();

        return View::make('admin.grille_evaluation_new', compact('enseignants'));
        
            
    }

    public function ajax_enseignant_classes_subjects(Request $request)
    {  
        
        $inputs = $request->all();
        $settings = Settings::first();

        $subjects = Subjects::join('classes', 'classes.id', '=', 'subjects.class_id')
        ->where('subjects.teacher_id', e($inputs['teacher_id']))

        ->select(
            'classes.id as cl_id', 
            'classes.name as cl_name', 
            'subjects.id as sbj_id', 
            'subjects.name as sbj_name',
            'subjects.teacher_id as tch_id')
        ->orderBy('classes.id', 'DESC')
        ->get();

        return response()->json($subjects);


    }


    public function grille_evaluation_details($id)
    { 

        $grille_evaluation = GrilleEvaluation::find(e($id));

        if ($grille_evaluation !== null) {

            if ($grille_evaluation->teacher_id == auth()->user()->id OR auth()->user()->is_admin == 1) {

                return View::make('admin.grille_evaluation_details', compact('grille_evaluation'));

            }

        } else {
            return View::make('404');
        }
    }

    public function store_grille_evaluation(Request $request)
    {   
        $settings = Settings::first();

        $inputs = $request->all();

        $validation = Validator::make($inputs, [
          'teacher_id'=>'required',
          'subject_id'=>'required',
          'titre'=>'required',
        ]); 

        if ($validation->fails()) {
            return Redirect::back()->withInput()->withErrors($validation);
        } 

        else {


$DateTime = \DateTime::createFromFormat('d/m/Y', e($inputs['date']));
$date_en = $DateTime->format('Y-m-d');

$getSubject = Subjects::find(e($inputs['subject_id'])); 


GrilleEvaluation::create([

    'year_id' => $settings->default_year,

    'teacher_id' => $inputs['teacher_id'],
    'subject_id' => $inputs['subject_id'],
    'class_id' => $getSubject->class_id,
    'date' => $date_en,
    'heure' => $inputs['heure'],
    'titre' => $inputs['titre'],

    'progression_annuelle_respectee' => $inputs['progression_annuelle_respectee'],
    'progression_annuelle_validee' => $inputs['progression_annuelle_validee'],
    'progression_semestrielle_respectee' => $inputs['progression_semestrielle_respectee'],
    'progression_semestrielle_validee' => $inputs['progression_semestrielle_validee'],
    'emploi_temps_respecte' => $inputs['emploi_temps_respecte'],
    'cahier_journal_ajour' => $inputs['cahier_journal_ajour'],
    'cahier_journal_detaille' => $inputs['cahier_journal_detaille'],
    'cahier_journal_bpresente' => $inputs['cahier_journal_bpresente'],
    'fiches_preparation_fpexiste' => $inputs['fiches_preparation_fpexiste'],
    'fiches_preparation_fnexiste' => $inputs['fiches_preparation_fnexiste'],
    'fiches_preparation_bpresente' => $inputs['fiches_preparation_bpresente'],
    'fiches_preparation_conforment' => $inputs['fiches_preparation_conforment'],
    'fiches_preparation_soutien_approfon' => $inputs['fiches_preparation_soutien_approfon'],

    'cahiers_exercices_frequence' => $inputs['cahiers_exercices_frequence'],
    'cahiers_exercices_qualiteappropries' => $inputs['cahiers_exercices_qualiteappropries'],
    'cahiers_exercices_qualitediversifies' => $inputs['cahiers_exercices_qualitediversifies'],
    'cahiers_exercices_qualitetachescomplexe' => $inputs['cahiers_exercices_qualitetachescomplexe'],
    'cahiers_exercices_correction' => $inputs['cahiers_exercices_correction'],
    'cahiers_exercices_soinsproprete' => $inputs['cahiers_exercices_soinsproprete'],
    'cahiers_exercices_soinssoulignement' => $inputs['cahiers_exercices_soinssoulignement'],
    'cahiers_exercices_notation' => $inputs['cahiers_exercices_notation'],
    'cahiers_exercices_appreciationsexist' => $inputs['cahiers_exercices_appreciationsexist'],
    'cahiers_exercices_appreciationsimplication' => $inputs['cahiers_exercices_appreciationsimplication'],

    'cahiers_lecons_soinsproprete' => $inputs['cahiers_lecons_soinsproprete'],
    'cahiers_lecons_soinssoulignement' => $inputs['cahiers_lecons_soinssoulignement'],
    'cahiers_lecons_visesenseignant' => $inputs['cahiers_lecons_visesenseignant'],
    'cahiers_lecons_ajour' => $inputs['cahiers_lecons_ajour'],
    'cahiers_lecons_vises' => $inputs['cahiers_lecons_vises'],

    'cahiers_maison_frequence' => $inputs['cahiers_maison_frequence'],
    'cahiers_maison_qualiteappropries' => $inputs['cahiers_maison_qualiteappropries'],
    'cahiers_maison_qualitediversifies' => $inputs['cahiers_maison_qualitediversifies'],
    'cahiers_maison_qualitetachescomplexe' => $inputs['cahiers_maison_qualitetachescomplexe'],
    'cahiers_maison_correction' => $inputs['cahiers_maison_correction'],
    'cahiers_maison_soinsproprete' => $inputs['cahiers_maison_soinsproprete'],
    'cahiers_maison_soinssoulignement' => $inputs['cahiers_maison_soinssoulignement'],
    'cahiers_maison_notation' => $inputs['cahiers_maison_notation'],
    'cahiers_maison_appreciationsexist' => $inputs['cahiers_maison_appreciationsexist'],
    'cahiers_maison_vises' => $inputs['cahiers_maison_vises'],

    'interet_supportspedagogiques' => $inputs['interet_supportspedagogiques'],
    'interet_lirenotes' => $inputs['interet_lirenotes'],
    'interet_implicationspratiques' => $inputs['interet_implicationspratiques'],
    'interet_montreenthousiasme' => $inputs['interet_montreenthousiasme'],

    'clartecours_paroleapproprie' => $inputs['clartecours_paroleapproprie'],
    'clartecours_nonmonotone' => $inputs['clartecours_nonmonotone'],
    'clartecours_exprimeclairement' => $inputs['clartecours_exprimeclairement'],
    'clartecours_avancecoursvmesuree' => $inputs['clartecours_avancecoursvmesuree'],
    'clartecours_utilisetableau' => $inputs['clartecours_utilisetableau'],

    'relationeleves_pointsvuedivergents' => $inputs['relationeleves_pointsvuedivergents'],
    'relationeleves_apporteaide' => $inputs['relationeleves_apporteaide'],
    'relationeleves_montrerespect' => $inputs['relationeleves_montrerespect'],
    
    'organisationcours_donneobjectifs' => $inputs['organisationcours_donneobjectifs'],
    'organisationcours_organise' => $inputs['organisationcours_organise'],
    'organisationcours_donnedocuments' => $inputs['organisationcours_donnedocuments'],
    'organisationcours_faitsyntheses' => $inputs['organisationcours_faitsyntheses'],
    'organisationcours_respecte3temps' => $inputs['organisationcours_respecte3temps'],


    'incitationparticipation_encouragequestions' => $inputs['incitationparticipation_encouragequestions'],
    'incitationparticipation_questionneindividuellement' => $inputs['incitationparticipation_questionneindividuellement'],
    'incitationparticipation_posequestions' => $inputs['incitationparticipation_posequestions'],
    'incitationparticipation_inciteeleves' => $inputs['incitationparticipation_inciteeleves'],
    'incitationparticipation_questionscomplexes' => $inputs['incitationparticipation_questionscomplexes'],


    'explications_utiliseexemples' => $inputs['explications_utiliseexemples'],
    'explications_repetedifficile' => $inputs['explications_repetedifficile'],
    'explications_pointscentraux' => $inputs['explications_pointscentraux'],
    'explications_donnedetails' => $inputs['explications_donnedetails'],
    'explications_pointscles' => $inputs['explications_pointscles'],

    'attitudeeleves_attentifs' => $inputs['attitudeeleves_attentifs'],
    'attitudeeleves_participentactivement' => $inputs['attitudeeleves_participentactivement'],
    'attitudeeleves_respectent' => $inputs['attitudeeleves_respectent'],
    'attitudeeleves_motives' => $inputs['attitudeeleves_motives'],

    'materieldidactique_existant' => $inputs['materieldidactique_existant'],
    'materieldidactique_bienutilise' => $inputs['materieldidactique_bienutilise'],
    'tc_respecteemploi' => $inputs['tc_respecteemploi'],
    'tc_respectetempsattribue' => $inputs['tc_respectetempsattribue'],

    'appreciation_general' => htmlentities(nl2br($inputs['appreciation_general'])),
    'recommandations' => htmlentities(nl2br($inputs['recommandations'])),




]);


return Redirect::back()->withSuccess('Ajouté avec succès');


        }


    }



    public function grille_evaluation_edit($id)
    { 

        $grille_evaluation = GrilleEvaluation::find(e($id));

        if ($grille_evaluation !== null) {

            return View::make('admin.grille_evaluation_edit', compact('grille_evaluation'));
            
        } else {
            return View::make('404');
        }
    }



    public function grille_evaluation_update($id, Request $request)
    { 


        $settings = Settings::first();

        $inputs = $request->all();

        $validation = Validator::make($inputs, [
          'teacher_id'=>'required',
          'subject_id'=>'required',
          'titre'=>'required',
        ]); 

        if ($validation->fails()) {
            return Redirect::back()->withInput()->withErrors($validation);
        } 

        else {



$DateTime = \DateTime::createFromFormat('d/m/Y', e($inputs['date']));
$date_en = $DateTime->format('Y-m-d');

$getSubject = Subjects::find(e($inputs['subject_id'])); 



    GrilleEvaluation::where('id', e($id))->update([

//   'year_id' => $settings->default_year,

//    'teacher_id' => $inputs['teacher_id'],
//    'subject_id' => $inputs['subject_id'],
//    'class_id' => $getSubject->class_id,
    'date' => $date_en,
    'heure' => $inputs['heure'],
    'titre' => $inputs['titre'],

    'progression_annuelle_respectee' => $inputs['progression_annuelle_respectee'],
    'progression_annuelle_validee' => $inputs['progression_annuelle_validee'],
    'progression_semestrielle_respectee' => $inputs['progression_semestrielle_respectee'],
    'progression_semestrielle_validee' => $inputs['progression_semestrielle_validee'],
    'emploi_temps_respecte' => $inputs['emploi_temps_respecte'],
    'cahier_journal_ajour' => $inputs['cahier_journal_ajour'],
    'cahier_journal_detaille' => $inputs['cahier_journal_detaille'],
    'cahier_journal_bpresente' => $inputs['cahier_journal_bpresente'],
    'fiches_preparation_fpexiste' => $inputs['fiches_preparation_fpexiste'],
    'fiches_preparation_fnexiste' => $inputs['fiches_preparation_fnexiste'],
    'fiches_preparation_bpresente' => $inputs['fiches_preparation_bpresente'],
    'fiches_preparation_conforment' => $inputs['fiches_preparation_conforment'],
    'fiches_preparation_soutien_approfon' => $inputs['fiches_preparation_soutien_approfon'],

    'cahiers_exercices_frequence' => $inputs['cahiers_exercices_frequence'],
    'cahiers_exercices_qualiteappropries' => $inputs['cahiers_exercices_qualiteappropries'],
    'cahiers_exercices_qualitediversifies' => $inputs['cahiers_exercices_qualitediversifies'],
    'cahiers_exercices_qualitetachescomplexe' => $inputs['cahiers_exercices_qualitetachescomplexe'],
    'cahiers_exercices_correction' => $inputs['cahiers_exercices_correction'],
    'cahiers_exercices_soinsproprete' => $inputs['cahiers_exercices_soinsproprete'],
    'cahiers_exercices_soinssoulignement' => $inputs['cahiers_exercices_soinssoulignement'],
    'cahiers_exercices_notation' => $inputs['cahiers_exercices_notation'],
    'cahiers_exercices_appreciationsexist' => $inputs['cahiers_exercices_appreciationsexist'],
    'cahiers_exercices_appreciationsimplication' => $inputs['cahiers_exercices_appreciationsimplication'],

    'cahiers_lecons_soinsproprete' => $inputs['cahiers_lecons_soinsproprete'],
    'cahiers_lecons_soinssoulignement' => $inputs['cahiers_lecons_soinssoulignement'],
    'cahiers_lecons_visesenseignant' => $inputs['cahiers_lecons_visesenseignant'],
    'cahiers_lecons_ajour' => $inputs['cahiers_lecons_ajour'],
    'cahiers_lecons_vises' => $inputs['cahiers_lecons_vises'],

    'cahiers_maison_frequence' => $inputs['cahiers_maison_frequence'],
    'cahiers_maison_qualiteappropries' => $inputs['cahiers_maison_qualiteappropries'],
    'cahiers_maison_qualitediversifies' => $inputs['cahiers_maison_qualitediversifies'],
    'cahiers_maison_qualitetachescomplexe' => $inputs['cahiers_maison_qualitetachescomplexe'],
    'cahiers_maison_correction' => $inputs['cahiers_maison_correction'],
    'cahiers_maison_soinsproprete' => $inputs['cahiers_maison_soinsproprete'],
    'cahiers_maison_soinssoulignement' => $inputs['cahiers_maison_soinssoulignement'],
    'cahiers_maison_notation' => $inputs['cahiers_maison_notation'],
    'cahiers_maison_appreciationsexist' => $inputs['cahiers_maison_appreciationsexist'],
    'cahiers_maison_vises' => $inputs['cahiers_maison_vises'],

    'interet_supportspedagogiques' => $inputs['interet_supportspedagogiques'],
    'interet_lirenotes' => $inputs['interet_lirenotes'],
    'interet_implicationspratiques' => $inputs['interet_implicationspratiques'],
    'interet_montreenthousiasme' => $inputs['interet_montreenthousiasme'],

    'clartecours_paroleapproprie' => $inputs['clartecours_paroleapproprie'],
    'clartecours_nonmonotone' => $inputs['clartecours_nonmonotone'],
    'clartecours_exprimeclairement' => $inputs['clartecours_exprimeclairement'],
    'clartecours_avancecoursvmesuree' => $inputs['clartecours_avancecoursvmesuree'],
    'clartecours_utilisetableau' => $inputs['clartecours_utilisetableau'],

    'relationeleves_pointsvuedivergents' => $inputs['relationeleves_pointsvuedivergents'],
    'relationeleves_apporteaide' => $inputs['relationeleves_apporteaide'],
    'relationeleves_montrerespect' => $inputs['relationeleves_montrerespect'],
    
    'organisationcours_donneobjectifs' => $inputs['organisationcours_donneobjectifs'],
    'organisationcours_organise' => $inputs['organisationcours_organise'],
    'organisationcours_donnedocuments' => $inputs['organisationcours_donnedocuments'],
    'organisationcours_faitsyntheses' => $inputs['organisationcours_faitsyntheses'],
    'organisationcours_respecte3temps' => $inputs['organisationcours_respecte3temps'],


    'incitationparticipation_encouragequestions' => $inputs['incitationparticipation_encouragequestions'],
    'incitationparticipation_questionneindividuellement' => $inputs['incitationparticipation_questionneindividuellement'],
    'incitationparticipation_posequestions' => $inputs['incitationparticipation_posequestions'],
    'incitationparticipation_inciteeleves' => $inputs['incitationparticipation_inciteeleves'],
    'incitationparticipation_questionscomplexes' => $inputs['incitationparticipation_questionscomplexes'],


    'explications_utiliseexemples' => $inputs['explications_utiliseexemples'],
    'explications_repetedifficile' => $inputs['explications_repetedifficile'],
    'explications_pointscentraux' => $inputs['explications_pointscentraux'],
    'explications_donnedetails' => $inputs['explications_donnedetails'],
    'explications_pointscles' => $inputs['explications_pointscles'],

    'attitudeeleves_attentifs' => $inputs['attitudeeleves_attentifs'],
    'attitudeeleves_participentactivement' => $inputs['attitudeeleves_participentactivement'],
    'attitudeeleves_respectent' => $inputs['attitudeeleves_respectent'],
    'attitudeeleves_motives' => $inputs['attitudeeleves_motives'],

    'materieldidactique_existant' => $inputs['materieldidactique_existant'],
    'materieldidactique_bienutilise' => $inputs['materieldidactique_bienutilise'],
    'tc_respecteemploi' => $inputs['tc_respecteemploi'],
    'tc_respectetempsattribue' => $inputs['tc_respectetempsattribue'],

    'appreciation_general' => htmlentities(nl2br($inputs['appreciation_general'])),
    'recommandations' => htmlentities(nl2br($inputs['recommandations'])),

    ]);


return Redirect::back()->withSuccess('Modifié avec succès');


        }
        
       


    }




    public function grille_evaluation_delete($id)
    { 

        $grille_evaluation = GrilleEvaluation::find(e($id));

        if ($grille_evaluation !== null) {

            $grille_evaluation->delete();

            return Redirect::back()->withError('Supprimé avec succès');

        } else {
            return View::make('404');
        }
    }




/*---------------------

    demandes de rencontre avec les parents

---------------------*/


    public function admin_demandes_rencontre()
    {   
        $settings = Settings::first();

        DemandesRencontre::where('readed', 0)->update(['readed'=>1]);

        $demandes_rencontre = DemandesRencontre::orderBy('id', 'desc')->get();

        return View::make('enseignants.demandes_rencontre', compact('demandes_rencontre'));
        
    }


    public function demandes_rencontre_update($id, Request $request)
    { 
        $inputs = $request->all();
        $settings = Settings::first();
        $demand = DemandesRencontre::find(e($id));

        if ($demand !== null) {

            if (auth()->user()->is_admin == true) {

                $DateTime = \DateTime::createFromFormat('d/m/Y', e($inputs['date']));
                
                $demand->date = $DateTime->format('Y-m-d');
                $demand->heure = $inputs['heure'];
                $demand->etat = $inputs['etat'];
                $demand->save();

                \App\DemandesRencontreStds::where('rencontre_id', $demand->id)->update(['readed'=>0]);

                return Redirect::route('admin_demandes_rencontre')->withSuccess('Mise à jour avec succès');
            }


        } else {
            return View::make('404');
        }
    }


    public function demandes_rencontre_rapport($id, Request $request)
    { 
        $inputs = $request->all();
        $settings = Settings::first();
        $demand = DemandesRencontre::find(e($id));

        if ($demand !== null) {

            if (auth()->user()->is_admin == true) {

                $demand->rapport = htmlentities(nl2br($inputs['rapport']));
                $demand->save();

                \App\DemandesRencontreStds::where('rencontre_id', $demand->id)->update(['readed'=>0]);

                return Redirect::route('admin_demandes_rencontre')->withSuccess('Mise à jour avec succès');
            }


        } else {
            return View::make('404');
        }
    }



    public function enseignant_demandes_rencontre()
    {   
        $settings = Settings::first();

        $demandes_rencontre = DemandesRencontre::where('teacher_id', auth()->user()->id)->orderBy('id', 'desc')->get();

        $classes = Subjects::join('classes', 'classes.id', '=', 'subjects.class_id')
        ->where('subjects.teacher_id', auth()->user()->id)

        ->select(
            'classes.id as cl_id', 
            'classes.name as cl_name', 
            'subjects.id as sbj_id', 
            'subjects.name as sbj_name',
            'subjects.teacher_id as tch_id')
        ->orderBy('classes.id', 'DESC')
        ->get();

        return View::make('enseignants.demandes_rencontre', compact('demandes_rencontre', 'classes'));
        
    }





    public function demandes_rencontre_store(Request $request)
    {   
        $settings = Settings::first();

        $inputs = $request->all();

        $validation = Validator::make($inputs, [
          'class_id'=>'required',
          'date'=>'required',
          'objet'=>'required',
        ]); 

        if ($validation->fails()) {
            return Redirect::back()->withInput()->withErrors($validation);
        } 

        else {


            $DateTime = \DateTime::createFromFormat('d/m/Y', e($inputs['date']));


            $Demand = DemandesRencontre::create([
                'teacher_id' => auth()->user()->id,
                'class_id' => $inputs['class_id'],
                'date' => $DateTime->format('Y-m-d'),
                'heure' => $inputs['heure'],
                'objet' => $inputs['objet'],
                'details' => htmlentities(nl2br($inputs['details'])),
            ]);

            $Demand->save();


            for($i=0;$i<count($inputs['student_ids']);$i++){

                \App\DemandesRencontreStds::create([

                    'rencontre_id' => $Demand->id,
                    'student_id' => $inputs['student_ids'][$i],
   
                ]);

            }

            return Redirect::back()->withSuccess('Ajouté avec succès');


        }


    }


    public function demandes_rencontre_delete($id)
    { 

        $emand = DemandesRencontre::find(e($id));

        if ($emand !== null) {

            if ($emand->teacher_id == auth()->user()->id OR auth()->user()->is_admin == true) {

                 \App\DemandesRencontreStds::where('rencontre_id', $emand->id)->delete();
                
                $emand->delete();

                return Redirect::back()->withError('Supprimé avec succès');
            }

            

        } else {
            return View::make('404');
        }
    }






/*---------------------

    Simili

---------------------*/

    public function enseignant_evaluations_simili()
    {   
        $settings = Settings::first();

        $similis = \App\Simili::where('year_id', $settings->default_year)->where('teacher_id', auth()->user()->id)->orderBy('id', 'desc')->get();

        $subjects = Subjects::where('year_id', $settings->default_year)->where('teacher_id', auth()->user()->id)->orderBy('id', 'desc')->get();

        return View::make('enseignants.simili', compact('subjects', 'similis'));
            
    }




    public function simili_evaluations_store(Request $request)
    {  
        $inputs = $request->all();

        $settings = Settings::first();

        $subject_id = $inputs['subject_id'];
        $class_id = $inputs['class_id'];

        $student_ids = $inputs['student_ids'];

        $is_absent = $inputs['is_absent'];
        $note = $inputs['note'];


        $myDateTime = \DateTime::createFromFormat('d/m/Y', e($inputs['date']));
        $date_en = $myDateTime->format('Y-m-d');


        $SimiliStore = \App\Simili::create([
            'teacher_id' => auth()->user()->id,
            'class_id' => $class_id,
            'subject_id' => $subject_id,
            'date' => $date_en,
            'note_sur' => e($inputs['note_sur']),
            'year_id' => $settings->default_year,
        ]);

        $SimiliStore->save();


        //--> for student_ids
        for($i=0;$i<count($inputs['student_ids']);$i++){


            $clearNote = str_replace(' ', '', $note[$i]);
            $clearNote = str_replace('.', ',', $clearNote);


            \App\SimiliEvaluations::create([
                'simili_id' => $SimiliStore->id,
                'student_id' => $student_ids[$i],
                'is_absent' => $is_absent[$i],
                'note' => $clearNote,
                'year_id' => $settings->default_year,
            ]);



        } // End for student_ids

       

       return Redirect::route('enseignant_evaluations_simili')->with('success', 'ajouté avec succès!');


    }


    public function simili_evaluations_update($id, Request $request)
    {  
        $settings = Settings::first();

        $inputs = $request->all();

        $SimiliStored = \App\Simili::find(e($id));

        $student_ids = $inputs['student_ids'];

        $is_absent = $inputs['is_absent'];
        $note = $inputs['note'];

        //--> delete olds
        \App\SimiliEvaluations::where('simili_id', $SimiliStored->id)->delete();

        //--> for student_ids
        for($i=0;$i<count($inputs['student_ids']);$i++){

            $clearNote = str_replace(' ', '', $note[$i]);
            $clearNote = str_replace('.', ',', $clearNote);

            \App\SimiliEvaluations::create([
                'simili_id' => $SimiliStored->id,
                'student_id' => $student_ids[$i],
                'is_absent' => $is_absent[$i],
                'note' => $clearNote,
                'year_id' => $settings->default_year,
            ]);


        } // End for student_ids

       

       return Redirect::back()->with('success', 'Modifier avec succès!');


    }



    public function enseignant_destroy_simili($id)
    {  

        $SimiliStored = \App\Simili::find(e($id));

        if ($SimiliStored->teacher_id == auth()->user()->id OR auth()->user()->is_admin == 1) {
            
            //--> delete SimiliEvaluations
            \App\SimiliEvaluations::where('simili_id', $SimiliStored->id)->delete();

            $SimiliStored->delete();

            return Redirect::back()->with('success', 'Supprimé avec succès!');
        }

        


    }







/**********************
     avis notes
**********************/

    public function enseignant_avis_notes()
    { 
        $settings = Settings::first();

        $liste_avis = \App\AvisNotes::where('for_teachers', 1)->where('year_id', $settings->default_year)->orderBy('id', 'desc')->paginate(50);

        \App\AvisNotifications::where('user_id', auth()->user()->id)->where('user_type', 1)->delete(); 

        return View::make('avis', compact('liste_avis'));
    }








}